/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Restrict promotion to specific stay dates the user wants to arrive.")
@JsonPropertyOrder(value={"effectiveDate", "expireDate"})
@JsonTypeName(value="StayDateRateQualifier_SupplierDetails")
public class StayDateRateQualifierSupplierDetails {
    public static final String JSON_PROPERTY_EFFECTIVE_DATE = "effectiveDate";
    private LocalDate effectiveDate;
    public static final String JSON_PROPERTY_EXPIRE_DATE = "expireDate";
    private LocalDate expireDate;

    public StayDateRateQualifierSupplierDetails effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The effective (start) date of the stay date rate qualifier")
    @JsonProperty(value="effectiveDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="effectiveDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public StayDateRateQualifierSupplierDetails expireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The expiration (end) date of the stay date rate qualifier")
    @JsonProperty(value="expireDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    @JsonProperty(value="expireDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StayDateRateQualifierSupplierDetails stayDateRateQualifierSupplierDetails = (StayDateRateQualifierSupplierDetails)o;
        return Objects.equals(this.effectiveDate, stayDateRateQualifierSupplierDetails.effectiveDate) && Objects.equals(this.expireDate, stayDateRateQualifierSupplierDetails.expireDate);
    }

    public int hashCode() {
        return Objects.hash(this.effectiveDate, this.expireDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StayDateRateQualifierSupplierDetails {\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    expireDate: ").append(this.toIndentedString(this.expireDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

