/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.InventorySupplier;
import travel.wink.sdk.extranet.model.InventoryUpdateRequestSupplier;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.PageInventorySupplier;
import travel.wink.sdk.extranet.model.SelectableKeyValuePairSupplier;
import travel.wink.sdk.extranet.model.StateSupplier;

public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showChannelActivitiesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelActivities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/activity/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showChannelActivities(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelActivitiesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showChannelActivitiesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelActivitiesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelAddOnsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelAddOns", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/addon/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showChannelAddOns(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelAddOnsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showChannelAddOnsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelAddOnsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelAttractionsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelAttractions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/attraction/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showChannelAttractions(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelAttractionsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showChannelAttractionsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelAttractionsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelMeetingRoomsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelMeetingRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/meetingroom/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showChannelMeetingRooms(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelMeetingRoomsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showChannelMeetingRoomsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelMeetingRoomsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelPlacesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelPlaces", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/place/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showChannelPlaces(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelPlacesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showChannelPlacesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelPlacesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelRestaurantsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelRestaurants", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/restaurant/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showChannelRestaurants(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelRestaurantsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showChannelRestaurantsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelRestaurantsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showChannelSpasRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannelSpas", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/spa/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showChannelSpas(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelSpasRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showChannelSpasWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showChannelSpasRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryRequestCreation(String hotelIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/{inventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventorySupplier> showInventory(String hotelIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.showInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventorySupplier>> showInventoryWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.showInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryListRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventorySupplier> showInventoryList(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.showInventoryListRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventorySupplier>>> showInventoryListWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.showInventoryListRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryNamesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventoryNames", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/name/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<String> showInventoryNames(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryNamesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showInventoryNamesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryNamesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showInventoryTypesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInventoryTypes", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/type/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<String> showInventoryTypes(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryTypesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<String>>> showInventoryTypesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(){};
        return this.showInventoryTypesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showMasterRatesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/guestroom/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showMasterRates(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showMasterRatesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showMasterRatesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showMasterRatesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showPageableChannelInventoryRequestCreation(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPageableChannelInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showPageableChannelInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventorySupplier> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventorySupplier> showPageableChannelInventory(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplier> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplier>(){};
        return this.showPageableChannelInventoryRequestCreation(hotelIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventorySupplier>> showPageableChannelInventoryWithHttpInfo(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplier> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplier>(){};
        return this.showPageableChannelInventoryRequestCreation(hotelIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec showSalesChannelListByInventoryRequestCreation(String hotelIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelListByInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showSalesChannelListByInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/{inventoryIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePairSupplier> showSalesChannelListByInventory(String hotelIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(){};
        return this.showSalesChannelListByInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelListByInventoryWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(){};
        return this.showSalesChannelListByInventoryRequestCreation(hotelIdentifier, inventoryIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec toggleInventoryAvailabilityRequestCreation(String hotelIdentifier, String inventoryIdentifier, InventoryUpdateRequestSupplier inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        InventoryUpdateRequestSupplier postBody = inventoryUpdateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleInventoryAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling toggleInventoryAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleInventoryAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/{inventoryIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventorySupplier> toggleInventoryAvailability(String hotelIdentifier, String inventoryIdentifier, InventoryUpdateRequestSupplier inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.toggleInventoryAvailabilityRequestCreation(hotelIdentifier, inventoryIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventorySupplier>> toggleInventoryAvailabilityWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, InventoryUpdateRequestSupplier inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.toggleInventoryAvailabilityRequestCreation(hotelIdentifier, inventoryIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec toggleInventoryListAvailabilityRequestCreation(String hotelIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        List<InventoryUpdateRequestSupplier> postBody = inventoryUpdateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleInventoryListAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleInventoryListAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/inventory/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventorySupplier> toggleInventoryListAvailability(String hotelIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.toggleInventoryListAvailabilityRequestCreation(hotelIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventorySupplier>>> toggleInventoryListAvailabilityWithHttpInfo(String hotelIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplier> localVarReturnType = new ParameterizedTypeReference<InventorySupplier>(){};
        return this.toggleInventoryListAvailabilityRequestCreation(hotelIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }
}

