/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.AddressSupplierDetails;
import travel.wink.sdk.extranet.model.ContactSupplierDetails;
import travel.wink.sdk.extranet.model.LocalizedPriceSupplierDetails;

@ApiModel(description="Add-on records.")
@JsonPropertyOrder(value={"hotelIdentifier", "typeIdentifier", "transactionalTravelInventoryIdentifier", "name", "pricingType", "type", "price", "startDate", "endDate", "attendees", "imageIdentifier", "imageUrl", "localizedName", "localizedDescription", "contact", "address", "commissionable", "commission"})
@JsonTypeName(value="BookingAncillary_SupplierDetails")
public class BookingAncillarySupplierDetails {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
    private UUID typeIdentifier;
    public static final String JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER = "transactionalTravelInventoryIdentifier";
    private UUID transactionalTravelInventoryIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PRICE = "price";
    private LocalizedPriceSupplierDetails price;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDateTime startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDateTime endDate;
    public static final String JSON_PROPERTY_ATTENDEES = "attendees";
    private Integer attendees = 1;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_IMAGE_URL = "imageUrl";
    private String imageUrl;
    public static final String JSON_PROPERTY_LOCALIZED_NAME = "localizedName";
    private String localizedName;
    public static final String JSON_PROPERTY_LOCALIZED_DESCRIPTION = "localizedDescription";
    private String localizedDescription;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactSupplierDetails contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressSupplierDetails address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Float commission;

    public BookingAncillarySupplierDetails hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Hotel identifier")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public BookingAncillarySupplierDetails typeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Travel inventory identifier")
    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public BookingAncillarySupplierDetails transactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
        this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Travel inventory identifier")
    @JsonProperty(value="transactionalTravelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTransactionalTravelInventoryIdentifier() {
        return this.transactionalTravelInventoryIdentifier;
    }

    @JsonProperty(value="transactionalTravelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
        this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
    }

    public BookingAncillarySupplierDetails name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Place 1", required=true, value="Name of inventory")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public BookingAncillarySupplierDetails pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PER_USE", required=true, value="Pricing type")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public BookingAncillarySupplierDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PLACE", required=true, value="Inventory type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BookingAncillarySupplierDetails price(LocalizedPriceSupplierDetails price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalizedPriceSupplierDetails getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(LocalizedPriceSupplierDetails price) {
        this.price = price;
    }

    public BookingAncillarySupplierDetails startDate(LocalDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date start time when reservation was made for.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public BookingAncillarySupplierDetails endDate(LocalDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date end time when reservation was made for.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public BookingAncillarySupplierDetails attendees(Integer attendees) {
        this.attendees = attendees;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="2", required=true, value="Number of guests that are part of this reservation.")
    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttendees(Integer attendees) {
        this.attendees = attendees;
    }

    public BookingAncillarySupplierDetails imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="cloudinary-image-1", required=true, value="Cloudinary image identifier")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public BookingAncillarySupplierDetails imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="https://path.to.image.com/this-is-me.jpg", required=true, value="Absolute URL to image of inventory")
    @JsonProperty(value="imageUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getImageUrl() {
        return this.imageUrl;
    }

    @JsonProperty(value="imageUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public BookingAncillarySupplierDetails localizedName(String localizedName) {
        this.localizedName = localizedName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Plass 1", required=true, value="Name of travel inventory in traveler language (if available). Defaults to English.")
    @JsonProperty(value="localizedName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocalizedName() {
        return this.localizedName;
    }

    @JsonProperty(value="localizedName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public BookingAncillarySupplierDetails localizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="place-1", required=true, value="Description of travel inventory in traveler language (if available). Defaults to English.")
    @JsonProperty(value="localizedDescription")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    @JsonProperty(value="localizedDescription")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    public BookingAncillarySupplierDetails contact(ContactSupplierDetails contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactSupplierDetails getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(ContactSupplierDetails contact) {
        this.contact = contact;
    }

    public BookingAncillarySupplierDetails address(AddressSupplierDetails address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressSupplierDetails getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressSupplierDetails address) {
        this.address = address;
    }

    public BookingAncillarySupplierDetails commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public BookingAncillarySupplierDetails commission(Float commission) {
        this.commission = commission;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommission(Float commission) {
        this.commission = commission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingAncillarySupplierDetails bookingAncillarySupplierDetails = (BookingAncillarySupplierDetails)o;
        return Objects.equals(this.hotelIdentifier, bookingAncillarySupplierDetails.hotelIdentifier) && Objects.equals(this.typeIdentifier, bookingAncillarySupplierDetails.typeIdentifier) && Objects.equals(this.transactionalTravelInventoryIdentifier, bookingAncillarySupplierDetails.transactionalTravelInventoryIdentifier) && Objects.equals(this.name, bookingAncillarySupplierDetails.name) && Objects.equals((Object)this.pricingType, (Object)bookingAncillarySupplierDetails.pricingType) && Objects.equals((Object)this.type, (Object)bookingAncillarySupplierDetails.type) && Objects.equals(this.price, bookingAncillarySupplierDetails.price) && Objects.equals(this.startDate, bookingAncillarySupplierDetails.startDate) && Objects.equals(this.endDate, bookingAncillarySupplierDetails.endDate) && Objects.equals(this.attendees, bookingAncillarySupplierDetails.attendees) && Objects.equals(this.imageIdentifier, bookingAncillarySupplierDetails.imageIdentifier) && Objects.equals(this.imageUrl, bookingAncillarySupplierDetails.imageUrl) && Objects.equals(this.localizedName, bookingAncillarySupplierDetails.localizedName) && Objects.equals(this.localizedDescription, bookingAncillarySupplierDetails.localizedDescription) && Objects.equals(this.contact, bookingAncillarySupplierDetails.contact) && Objects.equals(this.address, bookingAncillarySupplierDetails.address) && Objects.equals(this.commissionable, bookingAncillarySupplierDetails.commissionable) && Objects.equals(this.commission, bookingAncillarySupplierDetails.commission);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hotelIdentifier, this.typeIdentifier, this.transactionalTravelInventoryIdentifier, this.name, this.pricingType, this.type, this.price, this.startDate, this.endDate, this.attendees, this.imageIdentifier, this.imageUrl, this.localizedName, this.localizedDescription, this.contact, this.address, this.commissionable, this.commission});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingAncillarySupplierDetails {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    typeIdentifier: ").append(this.toIndentedString(this.typeIdentifier)).append("\n");
        sb.append("    transactionalTravelInventoryIdentifier: ").append(this.toIndentedString(this.transactionalTravelInventoryIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    localizedName: ").append(this.toIndentedString(this.localizedName)).append("\n");
        sb.append("    localizedDescription: ").append(this.toIndentedString(this.localizedDescription)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

