/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.EngineConfigurationThemeSupplierDetails;
import travel.wink.sdk.extranet.model.GeoNameSupplierDetails;
import travel.wink.sdk.extranet.model.RoomConfigurationSupplierDetails;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplierDetails;

@ApiModel(description="Which engine configuration record did the entity application used to facilitate in making this booking happen.")
@JsonPropertyOrder(value={"identifier", "name", "ownerIdentifier", "ownerName", "subType", "defaultCurrency", "defaultLanguage", "logos", "hostedBookingEngineUrl", "selfHosted", "themeColors", "numberOfAdvanceDays", "numberOfStayDays", "startDate", "endDate", "roomConfigurations", "useDays", "promotionalCodes", "sendBookingNotificationEmailsToProperty", "sendBookingNotificationEmailsToBooker", "sendBookingNotificationEmailsToChannelManager", "wcBookClickAction", "city", "showUnavailableCard"})
@JsonTypeName(value="EngineConfigurationBookingReport_SupplierDetails")
public class EngineConfigurationBookingReportSupplierDetails {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    private String ownerName;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
    private String defaultCurrency = "USD";
    public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
    private String defaultLanguage = "en";
    public static final String JSON_PROPERTY_LOGOS = "logos";
    private List<SimpleMultimediaSupplierDetails> logos = null;
    public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
    private String hostedBookingEngineUrl = "https://ota.wink.travel";
    public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
    private Boolean selfHosted = false;
    public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
    private EngineConfigurationThemeSupplierDetails themeColors;
    public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
    private Integer numberOfAdvanceDays;
    public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
    private Integer numberOfStayDays;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
    private List<RoomConfigurationSupplierDetails> roomConfigurations = null;
    public static final String JSON_PROPERTY_USE_DAYS = "useDays";
    private Boolean useDays;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
    private Boolean sendBookingNotificationEmailsToProperty = true;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
    private Boolean sendBookingNotificationEmailsToBooker = true;
    public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER = "sendBookingNotificationEmailsToChannelManager";
    private Boolean sendBookingNotificationEmailsToChannelManager = true;
    public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
    private WcBookClickActionEnum wcBookClickAction;
    public static final String JSON_PROPERTY_CITY = "city";
    private GeoNameSupplierDetails city;
    public static final String JSON_PROPERTY_SHOW_UNAVAILABLE_CARD = "showUnavailableCard";
    private Boolean showUnavailableCard;

    public EngineConfigurationBookingReportSupplierDetails identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique engine configuration identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public EngineConfigurationBookingReportSupplierDetails name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Engine Configuration 1", required=true, value="Engine configuration name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public EngineConfigurationBookingReportSupplierDetails ownerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Engine configuration record creator identifier")
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public EngineConfigurationBookingReportSupplierDetails ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Travel Tech 1", required=true, value="Name of company owner.")
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public EngineConfigurationBookingReportSupplierDetails subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="APPLICATION", required=true, value="Sales channel sub-type.")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public EngineConfigurationBookingReportSupplierDetails defaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Control which currency your users see prices in initially.")
    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @JsonProperty(value="defaultCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public EngineConfigurationBookingReportSupplierDetails defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="Control which language your users see text in initially.")
    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @JsonProperty(value="defaultLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public EngineConfigurationBookingReportSupplierDetails logos(List<SimpleMultimediaSupplierDetails> logos) {
        this.logos = logos;
        return this;
    }

    public EngineConfigurationBookingReportSupplierDetails addLogosItem(SimpleMultimediaSupplierDetails logosItem) {
        if (this.logos == null) {
            this.logos = new ArrayList<SimpleMultimediaSupplierDetails>();
        }
        this.logos.add(logosItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Customize booking confirmation emails by adding a custom logo to your configuration.")
    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleMultimediaSupplierDetails> getLogos() {
        return this.logos;
    }

    @JsonProperty(value="logos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogos(List<SimpleMultimediaSupplierDetails> logos) {
        this.logos = logos;
    }

    public EngineConfigurationBookingReportSupplierDetails hostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://my.customtravelsite.com/book", value="If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.")
    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostedBookingEngineUrl() {
        return this.hostedBookingEngineUrl;
    }

    @JsonProperty(value="hostedBookingEngineUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
        this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    }

    public EngineConfigurationBookingReportSupplierDetails selfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.")
    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSelfHosted() {
        return this.selfHosted;
    }

    @JsonProperty(value="selfHosted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelfHosted(Boolean selfHosted) {
        this.selfHosted = selfHosted;
    }

    public EngineConfigurationBookingReportSupplierDetails themeColors(EngineConfigurationThemeSupplierDetails themeColors) {
        this.themeColors = themeColors;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EngineConfigurationThemeSupplierDetails getThemeColors() {
        return this.themeColors;
    }

    @JsonProperty(value="themeColors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThemeColors(EngineConfigurationThemeSupplierDetails themeColors) {
        this.themeColors = themeColors;
    }

    public EngineConfigurationBookingReportSupplierDetails numberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfAdvanceDays() {
        return this.numberOfAdvanceDays;
    }

    @JsonProperty(value="numberOfAdvanceDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
        this.numberOfAdvanceDays = numberOfAdvanceDays;
    }

    public EngineConfigurationBookingReportSupplierDetails numberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfStayDays() {
        return this.numberOfStayDays;
    }

    @JsonProperty(value="numberOfStayDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfStayDays(Integer numberOfStayDays) {
        this.numberOfStayDays = numberOfStayDays;
    }

    public EngineConfigurationBookingReportSupplierDetails startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 24 07:00:00 ICT 2021", value="Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public EngineConfigurationBookingReportSupplierDetails endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Dec 31 07:00:00 ICT 2021", value="Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public EngineConfigurationBookingReportSupplierDetails roomConfigurations(List<RoomConfigurationSupplierDetails> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
        return this;
    }

    public EngineConfigurationBookingReportSupplierDetails addRoomConfigurationsItem(RoomConfigurationSupplierDetails roomConfigurationsItem) {
        if (this.roomConfigurations == null) {
            this.roomConfigurations = new ArrayList<RoomConfigurationSupplierDetails>();
        }
        this.roomConfigurations.add(roomConfigurationsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.")
    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RoomConfigurationSupplierDetails> getRoomConfigurations() {
        return this.roomConfigurations;
    }

    @JsonProperty(value="roomConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomConfigurations(List<RoomConfigurationSupplierDetails> roomConfigurations) {
        this.roomConfigurations = roomConfigurations;
    }

    public EngineConfigurationBookingReportSupplierDetails useDays(Boolean useDays) {
        this.useDays = useDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate")
    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseDays() {
        return this.useDays;
    }

    @JsonProperty(value="useDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseDays(Boolean useDays) {
        this.useDays = useDays;
    }

    public EngineConfigurationBookingReportSupplierDetails promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public EngineConfigurationBookingReportSupplierDetails addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-1\"]", value="If you've received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public EngineConfigurationBookingReportSupplierDetails sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An integrator can choose to disable outgoing emails to properties because they want to do that themselves.")
    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToProperty() {
        return this.sendBookingNotificationEmailsToProperty;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToProperty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
        this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    }

    public EngineConfigurationBookingReportSupplierDetails sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An integrator can choose to disable outgoing emails to users because they want to do that themselves.")
    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToBooker() {
        return this.sendBookingNotificationEmailsToBooker;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToBooker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
        this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    }

    public EngineConfigurationBookingReportSupplierDetails sendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
        this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="An integrator can choose to disable notifying the property's channel manager. Note: This should ONLY be done for testing.")
    @JsonProperty(value="sendBookingNotificationEmailsToChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendBookingNotificationEmailsToChannelManager() {
        return this.sendBookingNotificationEmailsToChannelManager;
    }

    @JsonProperty(value="sendBookingNotificationEmailsToChannelManager")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
        this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
    }

    public EngineConfigurationBookingReportSupplierDetails wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IBE_MODAL", value="Action to complete once a user clicks on the CTA button on inventory.")
    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WcBookClickActionEnum getWcBookClickAction() {
        return this.wcBookClickAction;
    }

    @JsonProperty(value="wcBookClickAction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
        this.wcBookClickAction = wcBookClickAction;
    }

    public EngineConfigurationBookingReportSupplierDetails city(GeoNameSupplierDetails city) {
        this.city = city;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoNameSupplierDetails getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(GeoNameSupplierDetails city) {
        this.city = city;
    }

    public EngineConfigurationBookingReportSupplierDetails showUnavailableCard(Boolean showUnavailableCard) {
        this.showUnavailableCard = showUnavailableCard;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Show unavailable inventory card when inventory not currently for sale. Otherwise, it displays a normal card but without the price.")
    @JsonProperty(value="showUnavailableCard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowUnavailableCard() {
        return this.showUnavailableCard;
    }

    @JsonProperty(value="showUnavailableCard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowUnavailableCard(Boolean showUnavailableCard) {
        this.showUnavailableCard = showUnavailableCard;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineConfigurationBookingReportSupplierDetails engineConfigurationBookingReportSupplierDetails = (EngineConfigurationBookingReportSupplierDetails)o;
        return Objects.equals(this.identifier, engineConfigurationBookingReportSupplierDetails.identifier) && Objects.equals(this.name, engineConfigurationBookingReportSupplierDetails.name) && Objects.equals(this.ownerIdentifier, engineConfigurationBookingReportSupplierDetails.ownerIdentifier) && Objects.equals(this.ownerName, engineConfigurationBookingReportSupplierDetails.ownerName) && Objects.equals((Object)this.subType, (Object)engineConfigurationBookingReportSupplierDetails.subType) && Objects.equals(this.defaultCurrency, engineConfigurationBookingReportSupplierDetails.defaultCurrency) && Objects.equals(this.defaultLanguage, engineConfigurationBookingReportSupplierDetails.defaultLanguage) && Objects.equals(this.logos, engineConfigurationBookingReportSupplierDetails.logos) && Objects.equals(this.hostedBookingEngineUrl, engineConfigurationBookingReportSupplierDetails.hostedBookingEngineUrl) && Objects.equals(this.selfHosted, engineConfigurationBookingReportSupplierDetails.selfHosted) && Objects.equals(this.themeColors, engineConfigurationBookingReportSupplierDetails.themeColors) && Objects.equals(this.numberOfAdvanceDays, engineConfigurationBookingReportSupplierDetails.numberOfAdvanceDays) && Objects.equals(this.numberOfStayDays, engineConfigurationBookingReportSupplierDetails.numberOfStayDays) && Objects.equals(this.startDate, engineConfigurationBookingReportSupplierDetails.startDate) && Objects.equals(this.endDate, engineConfigurationBookingReportSupplierDetails.endDate) && Objects.equals(this.roomConfigurations, engineConfigurationBookingReportSupplierDetails.roomConfigurations) && Objects.equals(this.useDays, engineConfigurationBookingReportSupplierDetails.useDays) && Objects.equals(this.promotionalCodes, engineConfigurationBookingReportSupplierDetails.promotionalCodes) && Objects.equals(this.sendBookingNotificationEmailsToProperty, engineConfigurationBookingReportSupplierDetails.sendBookingNotificationEmailsToProperty) && Objects.equals(this.sendBookingNotificationEmailsToBooker, engineConfigurationBookingReportSupplierDetails.sendBookingNotificationEmailsToBooker) && Objects.equals(this.sendBookingNotificationEmailsToChannelManager, engineConfigurationBookingReportSupplierDetails.sendBookingNotificationEmailsToChannelManager) && Objects.equals((Object)this.wcBookClickAction, (Object)engineConfigurationBookingReportSupplierDetails.wcBookClickAction) && Objects.equals(this.city, engineConfigurationBookingReportSupplierDetails.city) && Objects.equals(this.showUnavailableCard, engineConfigurationBookingReportSupplierDetails.showUnavailableCard);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.ownerIdentifier, this.ownerName, this.subType, this.defaultCurrency, this.defaultLanguage, this.logos, this.hostedBookingEngineUrl, this.selfHosted, this.themeColors, this.numberOfAdvanceDays, this.numberOfStayDays, this.startDate, this.endDate, this.roomConfigurations, this.useDays, this.promotionalCodes, this.sendBookingNotificationEmailsToProperty, this.sendBookingNotificationEmailsToBooker, this.sendBookingNotificationEmailsToChannelManager, this.wcBookClickAction, this.city, this.showUnavailableCard});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EngineConfigurationBookingReportSupplierDetails {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    defaultCurrency: ").append(this.toIndentedString(this.defaultCurrency)).append("\n");
        sb.append("    defaultLanguage: ").append(this.toIndentedString(this.defaultLanguage)).append("\n");
        sb.append("    logos: ").append(this.toIndentedString(this.logos)).append("\n");
        sb.append("    hostedBookingEngineUrl: ").append(this.toIndentedString(this.hostedBookingEngineUrl)).append("\n");
        sb.append("    selfHosted: ").append(this.toIndentedString(this.selfHosted)).append("\n");
        sb.append("    themeColors: ").append(this.toIndentedString(this.themeColors)).append("\n");
        sb.append("    numberOfAdvanceDays: ").append(this.toIndentedString(this.numberOfAdvanceDays)).append("\n");
        sb.append("    numberOfStayDays: ").append(this.toIndentedString(this.numberOfStayDays)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfigurations: ").append(this.toIndentedString(this.roomConfigurations)).append("\n");
        sb.append("    useDays: ").append(this.toIndentedString(this.useDays)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    sendBookingNotificationEmailsToProperty: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToProperty)).append("\n");
        sb.append("    sendBookingNotificationEmailsToBooker: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToBooker)).append("\n");
        sb.append("    sendBookingNotificationEmailsToChannelManager: ").append(this.toIndentedString(this.sendBookingNotificationEmailsToChannelManager)).append("\n");
        sb.append("    wcBookClickAction: ").append(this.toIndentedString((Object)this.wcBookClickAction)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    showUnavailableCard: ").append(this.toIndentedString(this.showUnavailableCard)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubTypeEnum {
        DIRECT("DIRECT"),
        APPLICATION("APPLICATION"),
        HOTEL("HOTEL"),
        TRAVELIKO("TRAVELIKO"),
        CORPORATE("CORPORATE"),
        TRAVEL_AGENT("TRAVEL_AGENT"),
        INFLUENCER("INFLUENCER"),
        BLOGGER("BLOGGER"),
        DESTINATION("DESTINATION"),
        CHANNEL_MANAGER("CHANNEL_MANAGER"),
        PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
        CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum WcBookClickActionEnum {
        FORWARD_TO_IBE("FORWARD_TO_IBE"),
        IBE_MODAL("IBE_MODAL");

        private String value;

        private WcBookClickActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WcBookClickActionEnum fromValue(String value) {
            for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

