/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;

@JsonPropertyOrder(value={"fullName", "imageIdentifier", "descriptions"})
@JsonTypeName(value="UpsertGeneralManagerRequest_Supplier")
public class UpsertGeneralManagerRequestSupplier {
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private String fullName;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();

    public UpsertGeneralManagerRequestSupplier fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Jane Doe", required=true, value="Name of GM currently managing the property.")
    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public UpsertGeneralManagerRequestSupplier imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cl-image-1", value="Cloudinary image identifier of GM currently managing the property.")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public UpsertGeneralManagerRequestSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public UpsertGeneralManagerRequestSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Personal welcome message from GM.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertGeneralManagerRequestSupplier upsertGeneralManagerRequestSupplier = (UpsertGeneralManagerRequestSupplier)o;
        return Objects.equals(this.fullName, upsertGeneralManagerRequestSupplier.fullName) && Objects.equals(this.imageIdentifier, upsertGeneralManagerRequestSupplier.imageIdentifier) && Objects.equals(this.descriptions, upsertGeneralManagerRequestSupplier.descriptions);
    }

    public int hashCode() {
        return Objects.hash(this.fullName, this.imageIdentifier, this.descriptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertGeneralManagerRequestSupplier {\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

