/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.1.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.Country;
import travel.wink.sdk.extranet.model.GeoJsonPoint;
import travel.wink.sdk.extranet.model.SubCountry;
import travel.wink.sdk.extranet.model.SubSubCountry;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNames have been created at [https://geonames.org](https://geonames.org) and contain geographical destinations we use as geoname data to associate travel inventory with a location.
 */
@JsonPropertyOrder({
  GeoName.JSON_PROPERTY_GEO_NAME_ID,
  GeoName.JSON_PROPERTY_TYPE,
  GeoName.JSON_PROPERTY_NAME,
  GeoName.JSON_PROPERTY_URL_NAME,
  GeoName.JSON_PROPERTY_ASCII_NAME,
  GeoName.JSON_PROPERTY_ALTERNATE_NAMES,
  GeoName.JSON_PROPERTY_LOCATION,
  GeoName.JSON_PROPERTY_FEATURE_CLASS,
  GeoName.JSON_PROPERTY_FEATURE_CODE,
  GeoName.JSON_PROPERTY_COUNTRY_CODE,
  GeoName.JSON_PROPERTY_ALTERNATE_COUNTRY_CODES,
  GeoName.JSON_PROPERTY_ADMIN1_CODE,
  GeoName.JSON_PROPERTY_ADMIN2_CODE,
  GeoName.JSON_PROPERTY_ADMIN3_CODE,
  GeoName.JSON_PROPERTY_ADMIN4_CODE,
  GeoName.JSON_PROPERTY_POPULATION,
  GeoName.JSON_PROPERTY_ELEVATION,
  GeoName.JSON_PROPERTY_DIGITAL_ELEVATION_MODEL,
  GeoName.JSON_PROPERTY_TIMEZONE,
  GeoName.JSON_PROPERTY_MODIFICATION_DATE,
  GeoName.JSON_PROPERTY_RADIUS_IN_METERS,
  GeoName.JSON_PROPERTY_COUNTRY,
  GeoName.JSON_PROPERTY_SUB_COUNTRY,
  GeoName.JSON_PROPERTY_SUB_SUB_COUNTRY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-06T14:58:42.579815638+07:00[Asia/Bangkok]")
public class GeoName {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  /**
   * GeoName type
   */
  public enum TypeEnum {
    CITY("CITY"),
    
    ISLAND("ISLAND"),
    
    OTHER("OTHER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_ASCII_NAME = "asciiName";
  private String asciiName;

  public static final String JSON_PROPERTY_ALTERNATE_NAMES = "alternateNames";
  private List<String> alternateNames = new ArrayList<>();

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPoint location;

  public static final String JSON_PROPERTY_FEATURE_CLASS = "featureClass";
  private String featureClass;

  public static final String JSON_PROPERTY_FEATURE_CODE = "featureCode";
  private String featureCode;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_ALTERNATE_COUNTRY_CODES = "alternateCountryCodes";
  private List<String> alternateCountryCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_ADMIN1_CODE = "admin1Code";
  private String admin1Code;

  public static final String JSON_PROPERTY_ADMIN2_CODE = "admin2Code";
  private String admin2Code;

  public static final String JSON_PROPERTY_ADMIN3_CODE = "admin3Code";
  private String admin3Code;

  public static final String JSON_PROPERTY_ADMIN4_CODE = "admin4Code";
  private String admin4Code;

  public static final String JSON_PROPERTY_POPULATION = "population";
  private Long population;

  public static final String JSON_PROPERTY_ELEVATION = "elevation";
  private Integer elevation;

  public static final String JSON_PROPERTY_DIGITAL_ELEVATION_MODEL = "digitalElevationModel";
  private String digitalElevationModel;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_MODIFICATION_DATE = "modificationDate";
  private LocalDate modificationDate;

  public static final String JSON_PROPERTY_RADIUS_IN_METERS = "radiusInMeters";
  private Long radiusInMeters;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private Country country;

  public static final String JSON_PROPERTY_SUB_COUNTRY = "subCountry";
  private SubCountry subCountry;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY = "subSubCountry";
  private SubSubCountry subSubCountry;

  public GeoName() {
  }

  public GeoName geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifier
   * @return geoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoName type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * GeoName type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public GeoName name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of city
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public GeoName urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url name
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public GeoName asciiName(String asciiName) {
    
    this.asciiName = asciiName;
    return this;
  }

   /**
   * Ascii name of city
   * @return asciiName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAsciiName() {
    return asciiName;
  }


  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsciiName(String asciiName) {
    this.asciiName = asciiName;
  }


  public GeoName alternateNames(List<String> alternateNames) {
    
    this.alternateNames = alternateNames;
    return this;
  }

  public GeoName addAlternateNamesItem(String alternateNamesItem) {
    if (this.alternateNames == null) {
      this.alternateNames = new ArrayList<>();
    }
    this.alternateNames.add(alternateNamesItem);
    return this;
  }

   /**
   * Array of alternate name
   * @return alternateNames
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALTERNATE_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAlternateNames() {
    return alternateNames;
  }


  @JsonProperty(JSON_PROPERTY_ALTERNATE_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlternateNames(List<String> alternateNames) {
    this.alternateNames = alternateNames;
  }


  public GeoName location(GeoJsonPoint location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPoint getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPoint location) {
    this.location = location;
  }


  public GeoName featureClass(String featureClass) {
    
    this.featureClass = featureClass;
    return this;
  }

   /**
   * Get featureClass
   * @return featureClass
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEATURE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureClass() {
    return featureClass;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureClass(String featureClass) {
    this.featureClass = featureClass;
  }


  public GeoName featureCode(String featureCode) {
    
    this.featureCode = featureCode;
    return this;
  }

   /**
   * Get featureCode
   * @return featureCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureCode() {
    return featureCode;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureCode(String featureCode) {
    this.featureCode = featureCode;
  }


  public GeoName countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Get countryCode
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public GeoName alternateCountryCodes(List<String> alternateCountryCodes) {
    
    this.alternateCountryCodes = alternateCountryCodes;
    return this;
  }

  public GeoName addAlternateCountryCodesItem(String alternateCountryCodesItem) {
    if (this.alternateCountryCodes == null) {
      this.alternateCountryCodes = new ArrayList<>();
    }
    this.alternateCountryCodes.add(alternateCountryCodesItem);
    return this;
  }

   /**
   * Get alternateCountryCodes
   * @return alternateCountryCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALTERNATE_COUNTRY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAlternateCountryCodes() {
    return alternateCountryCodes;
  }


  @JsonProperty(JSON_PROPERTY_ALTERNATE_COUNTRY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlternateCountryCodes(List<String> alternateCountryCodes) {
    this.alternateCountryCodes = alternateCountryCodes;
  }


  public GeoName admin1Code(String admin1Code) {
    
    this.admin1Code = admin1Code;
    return this;
  }

   /**
   * Get admin1Code
   * @return admin1Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin1Code() {
    return admin1Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin1Code(String admin1Code) {
    this.admin1Code = admin1Code;
  }


  public GeoName admin2Code(String admin2Code) {
    
    this.admin2Code = admin2Code;
    return this;
  }

   /**
   * Get admin2Code
   * @return admin2Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin2Code() {
    return admin2Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin2Code(String admin2Code) {
    this.admin2Code = admin2Code;
  }


  public GeoName admin3Code(String admin3Code) {
    
    this.admin3Code = admin3Code;
    return this;
  }

   /**
   * Get admin3Code
   * @return admin3Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN3_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin3Code() {
    return admin3Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN3_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin3Code(String admin3Code) {
    this.admin3Code = admin3Code;
  }


  public GeoName admin4Code(String admin4Code) {
    
    this.admin4Code = admin4Code;
    return this;
  }

   /**
   * Get admin4Code
   * @return admin4Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADMIN4_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAdmin4Code() {
    return admin4Code;
  }


  @JsonProperty(JSON_PROPERTY_ADMIN4_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdmin4Code(String admin4Code) {
    this.admin4Code = admin4Code;
  }


  public GeoName population(Long population) {
    
    this.population = population;
    return this;
  }

   /**
   * Population of the city
   * @return population
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPopulation() {
    return population;
  }


  @JsonProperty(JSON_PROPERTY_POPULATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopulation(Long population) {
    this.population = population;
  }


  public GeoName elevation(Integer elevation) {
    
    this.elevation = elevation;
    return this;
  }

   /**
   * City elevation
   * @return elevation
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ELEVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getElevation() {
    return elevation;
  }


  @JsonProperty(JSON_PROPERTY_ELEVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElevation(Integer elevation) {
    this.elevation = elevation;
  }


  public GeoName digitalElevationModel(String digitalElevationModel) {
    
    this.digitalElevationModel = digitalElevationModel;
    return this;
  }

   /**
   * Get digitalElevationModel
   * @return digitalElevationModel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DIGITAL_ELEVATION_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDigitalElevationModel() {
    return digitalElevationModel;
  }


  @JsonProperty(JSON_PROPERTY_DIGITAL_ELEVATION_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDigitalElevationModel(String digitalElevationModel) {
    this.digitalElevationModel = digitalElevationModel;
  }


  public GeoName timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoName modificationDate(LocalDate modificationDate) {
    
    this.modificationDate = modificationDate;
    return this;
  }

   /**
   * Get modificationDate
   * @return modificationDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getModificationDate() {
    return modificationDate;
  }


  @JsonProperty(JSON_PROPERTY_MODIFICATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModificationDate(LocalDate modificationDate) {
    this.modificationDate = modificationDate;
  }


  public GeoName radiusInMeters(Long radiusInMeters) {
    
    this.radiusInMeters = radiusInMeters;
    return this;
  }

   /**
   * Get radiusInMeters
   * @return radiusInMeters
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RADIUS_IN_METERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRadiusInMeters() {
    return radiusInMeters;
  }


  @JsonProperty(JSON_PROPERTY_RADIUS_IN_METERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRadiusInMeters(Long radiusInMeters) {
    this.radiusInMeters = radiusInMeters;
  }


  public GeoName country(Country country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Country getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(Country country) {
    this.country = country;
  }


  public GeoName subCountry(SubCountry subCountry) {
    
    this.subCountry = subCountry;
    return this;
  }

   /**
   * Get subCountry
   * @return subCountry
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubCountry getSubCountry() {
    return subCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountry(SubCountry subCountry) {
    this.subCountry = subCountry;
  }


  public GeoName subSubCountry(SubSubCountry subSubCountry) {
    
    this.subSubCountry = subSubCountry;
    return this;
  }

   /**
   * Get subSubCountry
   * @return subSubCountry
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubSubCountry getSubSubCountry() {
    return subSubCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountry(SubSubCountry subSubCountry) {
    this.subSubCountry = subSubCountry;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoName geoName = (GeoName) o;
    return Objects.equals(this.geoNameId, geoName.geoNameId) &&
        Objects.equals(this.type, geoName.type) &&
        Objects.equals(this.name, geoName.name) &&
        Objects.equals(this.urlName, geoName.urlName) &&
        Objects.equals(this.asciiName, geoName.asciiName) &&
        Objects.equals(this.alternateNames, geoName.alternateNames) &&
        Objects.equals(this.location, geoName.location) &&
        Objects.equals(this.featureClass, geoName.featureClass) &&
        Objects.equals(this.featureCode, geoName.featureCode) &&
        Objects.equals(this.countryCode, geoName.countryCode) &&
        Objects.equals(this.alternateCountryCodes, geoName.alternateCountryCodes) &&
        Objects.equals(this.admin1Code, geoName.admin1Code) &&
        Objects.equals(this.admin2Code, geoName.admin2Code) &&
        Objects.equals(this.admin3Code, geoName.admin3Code) &&
        Objects.equals(this.admin4Code, geoName.admin4Code) &&
        Objects.equals(this.population, geoName.population) &&
        Objects.equals(this.elevation, geoName.elevation) &&
        Objects.equals(this.digitalElevationModel, geoName.digitalElevationModel) &&
        Objects.equals(this.timezone, geoName.timezone) &&
        Objects.equals(this.modificationDate, geoName.modificationDate) &&
        Objects.equals(this.radiusInMeters, geoName.radiusInMeters) &&
        Objects.equals(this.country, geoName.country) &&
        Objects.equals(this.subCountry, geoName.subCountry) &&
        Objects.equals(this.subSubCountry, geoName.subSubCountry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, type, name, urlName, asciiName, alternateNames, location, featureClass, featureCode, countryCode, alternateCountryCodes, admin1Code, admin2Code, admin3Code, admin4Code, population, elevation, digitalElevationModel, timezone, modificationDate, radiusInMeters, country, subCountry, subSubCountry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoName {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    asciiName: ").append(toIndentedString(asciiName)).append("\n");
    sb.append("    alternateNames: ").append(toIndentedString(alternateNames)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    featureClass: ").append(toIndentedString(featureClass)).append("\n");
    sb.append("    featureCode: ").append(toIndentedString(featureCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    alternateCountryCodes: ").append(toIndentedString(alternateCountryCodes)).append("\n");
    sb.append("    admin1Code: ").append(toIndentedString(admin1Code)).append("\n");
    sb.append("    admin2Code: ").append(toIndentedString(admin2Code)).append("\n");
    sb.append("    admin3Code: ").append(toIndentedString(admin3Code)).append("\n");
    sb.append("    admin4Code: ").append(toIndentedString(admin4Code)).append("\n");
    sb.append("    population: ").append(toIndentedString(population)).append("\n");
    sb.append("    elevation: ").append(toIndentedString(elevation)).append("\n");
    sb.append("    digitalElevationModel: ").append(toIndentedString(digitalElevationModel)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    modificationDate: ").append(toIndentedString(modificationDate)).append("\n");
    sb.append("    radiusInMeters: ").append(toIndentedString(radiusInMeters)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    subCountry: ").append(toIndentedString(subCountry)).append("\n");
    sb.append("    subSubCountry: ").append(toIndentedString(subSubCountry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

