package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.RefPointViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertPlaceRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:36:59.732058641+07:00[Asia/Bangkok]")
public class PlaceApi {
    private ApiClient apiClient;

    public PlaceApi() {
        this(new ApiClient());
    }

    @Autowired
    public PlaceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Place
     * Create a new place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new place record owned by this hotel identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPlaceRequestCreation(String hotelIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertPlaceRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertPlaceRequestSupplier' is set
        if (upsertPlaceRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPlaceRequestSupplier' when calling createPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Place
     * Create a new place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new place record owned by this hotel identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointViewSupplier> createPlace(String hotelIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return createPlaceRequestCreation(hotelIdentifier, upsertPlaceRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Place
     * Create a new place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new place record owned by this hotel identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RefPointViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RefPointViewSupplier>> createPlaceWithHttpInfo(String hotelIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return createPlaceRequestCreation(hotelIdentifier, upsertPlaceRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Place
     * Create a new place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new place record owned by this hotel identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPlaceWithResponseSpec(String hotelIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createPlaceRequestCreation(hotelIdentifier, upsertPlaceRequestSupplier, winkVersion);
    }
    /**
     * Delete Place
     * Delete a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove place record owned by this hotel identifier
     * @param placeIdentifier Remove place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removePlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Place
     * Delete a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove place record owned by this hotel identifier
     * @param placeIdentifier Remove place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removePlace(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removePlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Place
     * Delete a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove place record owned by this hotel identifier
     * @param placeIdentifier Remove place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removePlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removePlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Place
     * Delete a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove place record owned by this hotel identifier
     * @param placeIdentifier Remove place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removePlaceWithResponseSpec(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        return removePlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion);
    }
    /**
     * Show Place
     * Retrieve a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single place owned by this hotel identifier
     * @param placeIdentifier Show place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPlaceRequestCreation(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Place
     * Retrieve a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single place owned by this hotel identifier
     * @param placeIdentifier Show place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointViewSupplier> showPlace(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return showPlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Place
     * Retrieve a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single place owned by this hotel identifier
     * @param placeIdentifier Show place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RefPointViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RefPointViewSupplier>> showPlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return showPlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Place
     * Retrieve a place by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single place owned by this hotel identifier
     * @param placeIdentifier Show place record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPlaceWithResponseSpec(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        return showPlaceRequestCreation(hotelIdentifier, placeIdentifier, winkVersion);
    }
    /**
     * Show Reference Pairs
     * Retrieve list of places as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show place pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPlacePairsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlacePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list/pair", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of places as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show place pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> showPlacePairs(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showPlacePairsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of places as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show place pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showPlacePairsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showPlacePairsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of places as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show place pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPlacePairsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showPlacePairsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Show Places
     * Retrieve list of places for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show places owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RefPointViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPlacesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlaces", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Places
     * Retrieve list of places for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show places owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RefPointViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RefPointViewSupplier> showPlaces(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return showPlacesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Places
     * Retrieve list of places for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show places owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RefPointViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RefPointViewSupplier>>> showPlacesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return showPlacesRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Places
     * Retrieve list of places for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show places owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPlacesWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showPlacesRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Place
     * Update a place by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing place record owned by this hotel identifier
     * @param placeIdentifier Update an existing place record identified by this identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePlaceRequestCreation(String hotelIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertPlaceRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertPlaceRequestSupplier' is set
        if (upsertPlaceRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPlaceRequestSupplier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Place
     * Update a place by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing place record owned by this hotel identifier
     * @param placeIdentifier Update an existing place record identified by this identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointViewSupplier> updatePlace(String hotelIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return updatePlaceRequestCreation(hotelIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Place
     * Update a place by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing place record owned by this hotel identifier
     * @param placeIdentifier Update an existing place record identified by this identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RefPointViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RefPointViewSupplier>> updatePlaceWithHttpInfo(String hotelIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return updatePlaceRequestCreation(hotelIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Place
     * Update a place by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing place record owned by this hotel identifier
     * @param placeIdentifier Update an existing place record identified by this identifier
     * @param upsertPlaceRequestSupplier The upsertPlaceRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updatePlaceWithResponseSpec(String hotelIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updatePlaceRequestCreation(hotelIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing place owned by this hotel identifier
     * @param placeIdentifier Upload multipart files and associate them with an existing place with this identifier
     * @param files The files parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadPlaceMediaRequestCreation(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/place/{placeIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing place owned by this hotel identifier
     * @param placeIdentifier Upload multipart files and associate them with an existing place with this identifier
     * @param files The files parameter
     * @return RefPointViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RefPointViewSupplier> uploadPlaceMedia(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).bodyToMono(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing place owned by this hotel identifier
     * @param placeIdentifier Upload multipart files and associate them with an existing place with this identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;RefPointViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RefPointViewSupplier>> uploadPlaceMediaWithHttpInfo(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>() {};
        return uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files).toEntity(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing place owned by this hotel identifier
     * @param placeIdentifier Upload multipart files and associate them with an existing place with this identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadPlaceMediaWithResponseSpec(String hotelIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        return uploadPlaceMediaRequestCreation(hotelIdentifier, placeIdentifier, files);
    }
}
