/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.2.7
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AdvanceBookingRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.ArrivalDaysOfWeekRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.AvailableDaysOfWeekRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.BlackoutDateSupplierDetails;
import travel.wink.sdk.extranet.model.CityRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.ContinentRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.CountryRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.DepartureDaysOfWeekRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.IPRangeRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.LengthOfStayRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.MinutesBeforeBookingStartDateRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.PrepayRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.PromotionRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.RefundableRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.RequiredDaysOfWeekRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.RoomRangeRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.SellDateRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplierDetails;
import travel.wink.sdk.extranet.model.StayDateRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.TimezoneRateQualifierSupplierDetails;
import travel.wink.sdk.extranet.model.VariableChargeSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Promotions that go together to make up this ancillary.
 */
@JsonPropertyOrder({
  RateModifierSupplierDetails.JSON_PROPERTY_IDENTIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_NAME,
  RateModifierSupplierDetails.JSON_PROPERTY_TYPE,
  RateModifierSupplierDetails.JSON_PROPERTY_MODIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_ENABLED,
  RateModifierSupplierDetails.JSON_PROPERTY_PRICING_TYPE,
  RateModifierSupplierDetails.JSON_PROPERTY_DESCRIPTIONS,
  RateModifierSupplierDetails.JSON_PROPERTY_CITY_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_PREPAY_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierSupplierDetails.JSON_PROPERTY_MASTER_RATE_IDENTIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_ADD_ON_IDENTIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_RATE_PLAN_IDENTIFIERS,
  RateModifierSupplierDetails.JSON_PROPERTY_BLACKOUT_DATES
})
@JsonTypeName("RateModifier_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-26T14:36:45.544169528+07:00[Asia/Bangkok]")
public class RateModifierSupplierDetails {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_MODIFIER = "modifier";
  private VariableChargeSupplierDetails modifier;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionSupplierDetails> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_CITY_RATE_QUALIFIERS = "cityRateQualifiers";
  private List<CityRateQualifierSupplierDetails> cityRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS = "continentRateQualifiers";
  private List<ContinentRateQualifierSupplierDetails> continentRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS = "countryRateQualifiers";
  private List<CountryRateQualifierSupplierDetails> countryRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS = "promotionRateQualifiers";
  private List<PromotionRateQualifierSupplierDetails> promotionRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS = "ipRangeRateQualifiers";
  private List<IPRangeRateQualifierSupplierDetails> ipRangeRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER = "roomRangeRateQualifier";
  private RoomRangeRateQualifierSupplierDetails roomRangeRateQualifier;

  public static final String JSON_PROPERTY_PREPAY_RATE_QUALIFIER = "prepayRateQualifier";
  private PrepayRateQualifierSupplierDetails prepayRateQualifier;

  public static final String JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER = "refundableRateQualifier";
  private RefundableRateQualifierSupplierDetails refundableRateQualifier;

  public static final String JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS = "timezoneRateQualifiers";
  private List<TimezoneRateQualifierSupplierDetails> timezoneRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER = "lastMinuteRateQualifier";
  private MinutesBeforeBookingStartDateRateQualifierSupplierDetails lastMinuteRateQualifier;

  public static final String JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER = "lengthOfStayRateQualifier";
  private LengthOfStayRateQualifierSupplierDetails lengthOfStayRateQualifier;

  public static final String JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER = "advanceBookingRateQualifier";
  private AdvanceBookingRateQualifierSupplierDetails advanceBookingRateQualifier;

  public static final String JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS = "stayDateRateQualifiers";
  private List<StayDateRateQualifierSupplierDetails> stayDateRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS = "sellDateRateQualifiers";
  private List<SellDateRateQualifierSupplierDetails> sellDateRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER = "availableDaysOfWeekRateQualifier";
  private AvailableDaysOfWeekRateQualifierSupplierDetails availableDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER = "arrivalDaysOfWeekRateQualifier";
  private ArrivalDaysOfWeekRateQualifierSupplierDetails arrivalDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER = "departureDaysOfWeekRateQualifier";
  private DepartureDaysOfWeekRateQualifierSupplierDetails departureDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER = "requiredDaysOfWeekRateQualifier";
  private RequiredDaysOfWeekRateQualifierSupplierDetails requiredDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIERS = "masterRateIdentifiers";
  private List<String> masterRateIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ADD_ON_IDENTIFIERS = "addOnIdentifiers";
  private List<String> addOnIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIERS = "ratePlanIdentifiers";
  private List<String> ratePlanIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_BLACKOUT_DATES = "blackoutDates";
  private List<BlackoutDateSupplierDetails> blackoutDates = new ArrayList<>();

  public RateModifierSupplierDetails() {
  }

  public RateModifierSupplierDetails identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RateModifierSupplierDetails hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateModifierSupplierDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RateModifierSupplierDetails type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RateModifierSupplierDetails modifier(VariableChargeSupplierDetails modifier) {
    
    this.modifier = modifier;
    return this;
  }

   /**
   * Get modifier
   * @return modifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableChargeSupplierDetails getModifier() {
    return modifier;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifier(VariableChargeSupplierDetails modifier) {
    this.modifier = modifier;
  }


  public RateModifierSupplierDetails enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion is enabled or not.
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public RateModifierSupplierDetails pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RateModifierSupplierDetails descriptions(List<SimpleDescriptionSupplierDetails> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public RateModifierSupplierDetails addDescriptionsItem(SimpleDescriptionSupplierDetails descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing promotion. At least one English entry is required.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionSupplierDetails> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionSupplierDetails> descriptions) {
    this.descriptions = descriptions;
  }


  public RateModifierSupplierDetails cityRateQualifiers(List<CityRateQualifierSupplierDetails> cityRateQualifiers) {
    
    this.cityRateQualifiers = cityRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addCityRateQualifiersItem(CityRateQualifierSupplierDetails cityRateQualifiersItem) {
    if (this.cityRateQualifiers == null) {
      this.cityRateQualifiers = new ArrayList<>();
    }
    this.cityRateQualifiers.add(cityRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific cities. See [Geo-IP city geoname data](#operation/searchForCity)
   * @return cityRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CityRateQualifierSupplierDetails> getCityRateQualifiers() {
    return cityRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityRateQualifiers(List<CityRateQualifierSupplierDetails> cityRateQualifiers) {
    this.cityRateQualifiers = cityRateQualifiers;
  }


  public RateModifierSupplierDetails continentRateQualifiers(List<ContinentRateQualifierSupplierDetails> continentRateQualifiers) {
    
    this.continentRateQualifiers = continentRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addContinentRateQualifiersItem(ContinentRateQualifierSupplierDetails continentRateQualifiersItem) {
    if (this.continentRateQualifiers == null) {
      this.continentRateQualifiers = new ArrayList<>();
    }
    this.continentRateQualifiers.add(continentRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific continents. See [Geo-IP continent geoname data](#operation/showContinents)
   * @return continentRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ContinentRateQualifierSupplierDetails> getContinentRateQualifiers() {
    return continentRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentRateQualifiers(List<ContinentRateQualifierSupplierDetails> continentRateQualifiers) {
    this.continentRateQualifiers = continentRateQualifiers;
  }


  public RateModifierSupplierDetails countryRateQualifiers(List<CountryRateQualifierSupplierDetails> countryRateQualifiers) {
    
    this.countryRateQualifiers = countryRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addCountryRateQualifiersItem(CountryRateQualifierSupplierDetails countryRateQualifiersItem) {
    if (this.countryRateQualifiers == null) {
      this.countryRateQualifiers = new ArrayList<>();
    }
    this.countryRateQualifiers.add(countryRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific countries. See [Geo-IP country geoname data](#operation/showCountries)
   * @return countryRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CountryRateQualifierSupplierDetails> getCountryRateQualifiers() {
    return countryRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryRateQualifiers(List<CountryRateQualifierSupplierDetails> countryRateQualifiers) {
    this.countryRateQualifiers = countryRateQualifiers;
  }


  public RateModifierSupplierDetails promotionRateQualifiers(List<PromotionRateQualifierSupplierDetails> promotionRateQualifiers) {
    
    this.promotionRateQualifiers = promotionRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addPromotionRateQualifiersItem(PromotionRateQualifierSupplierDetails promotionRateQualifiersItem) {
    if (this.promotionRateQualifiers == null) {
      this.promotionRateQualifiers = new ArrayList<>();
    }
    this.promotionRateQualifiers.add(promotionRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion by requiring users to enter a promo code.
   * @return promotionRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PromotionRateQualifierSupplierDetails> getPromotionRateQualifiers() {
    return promotionRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionRateQualifiers(List<PromotionRateQualifierSupplierDetails> promotionRateQualifiers) {
    this.promotionRateQualifiers = promotionRateQualifiers;
  }


  public RateModifierSupplierDetails ipRangeRateQualifiers(List<IPRangeRateQualifierSupplierDetails> ipRangeRateQualifiers) {
    
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addIpRangeRateQualifiersItem(IPRangeRateQualifierSupplierDetails ipRangeRateQualifiersItem) {
    if (this.ipRangeRateQualifiers == null) {
      this.ipRangeRateQualifiers = new ArrayList<>();
    }
    this.ipRangeRateQualifiers.add(ipRangeRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific IP ranges.
   * @return ipRangeRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IPRangeRateQualifierSupplierDetails> getIpRangeRateQualifiers() {
    return ipRangeRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpRangeRateQualifiers(List<IPRangeRateQualifierSupplierDetails> ipRangeRateQualifiers) {
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
  }


  public RateModifierSupplierDetails roomRangeRateQualifier(RoomRangeRateQualifierSupplierDetails roomRangeRateQualifier) {
    
    this.roomRangeRateQualifier = roomRangeRateQualifier;
    return this;
  }

   /**
   * Get roomRangeRateQualifier
   * @return roomRangeRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomRangeRateQualifierSupplierDetails getRoomRangeRateQualifier() {
    return roomRangeRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRangeRateQualifier(RoomRangeRateQualifierSupplierDetails roomRangeRateQualifier) {
    this.roomRangeRateQualifier = roomRangeRateQualifier;
  }


  public RateModifierSupplierDetails prepayRateQualifier(PrepayRateQualifierSupplierDetails prepayRateQualifier) {
    
    this.prepayRateQualifier = prepayRateQualifier;
    return this;
  }

   /**
   * Get prepayRateQualifier
   * @return prepayRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrepayRateQualifierSupplierDetails getPrepayRateQualifier() {
    return prepayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrepayRateQualifier(PrepayRateQualifierSupplierDetails prepayRateQualifier) {
    this.prepayRateQualifier = prepayRateQualifier;
  }


  public RateModifierSupplierDetails refundableRateQualifier(RefundableRateQualifierSupplierDetails refundableRateQualifier) {
    
    this.refundableRateQualifier = refundableRateQualifier;
    return this;
  }

   /**
   * Get refundableRateQualifier
   * @return refundableRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableRateQualifierSupplierDetails getRefundableRateQualifier() {
    return refundableRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableRateQualifier(RefundableRateQualifierSupplierDetails refundableRateQualifier) {
    this.refundableRateQualifier = refundableRateQualifier;
  }


  public RateModifierSupplierDetails timezoneRateQualifiers(List<TimezoneRateQualifierSupplierDetails> timezoneRateQualifiers) {
    
    this.timezoneRateQualifiers = timezoneRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addTimezoneRateQualifiersItem(TimezoneRateQualifierSupplierDetails timezoneRateQualifiersItem) {
    if (this.timezoneRateQualifiers == null) {
      this.timezoneRateQualifiers = new ArrayList<>();
    }
    this.timezoneRateQualifiers.add(timezoneRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific time zones. See [Geo-IP timezone geoname data](#operation/showTimezones)
   * @return timezoneRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TimezoneRateQualifierSupplierDetails> getTimezoneRateQualifiers() {
    return timezoneRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezoneRateQualifiers(List<TimezoneRateQualifierSupplierDetails> timezoneRateQualifiers) {
    this.timezoneRateQualifiers = timezoneRateQualifiers;
  }


  public RateModifierSupplierDetails lastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifierSupplierDetails lastMinuteRateQualifier) {
    
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
    return this;
  }

   /**
   * Get lastMinuteRateQualifier
   * @return lastMinuteRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MinutesBeforeBookingStartDateRateQualifierSupplierDetails getLastMinuteRateQualifier() {
    return lastMinuteRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifierSupplierDetails lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
  }


  public RateModifierSupplierDetails lengthOfStayRateQualifier(LengthOfStayRateQualifierSupplierDetails lengthOfStayRateQualifier) {
    
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
    return this;
  }

   /**
   * Get lengthOfStayRateQualifier
   * @return lengthOfStayRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LengthOfStayRateQualifierSupplierDetails getLengthOfStayRateQualifier() {
    return lengthOfStayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLengthOfStayRateQualifier(LengthOfStayRateQualifierSupplierDetails lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
  }


  public RateModifierSupplierDetails advanceBookingRateQualifier(AdvanceBookingRateQualifierSupplierDetails advanceBookingRateQualifier) {
    
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
    return this;
  }

   /**
   * Get advanceBookingRateQualifier
   * @return advanceBookingRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceBookingRateQualifierSupplierDetails getAdvanceBookingRateQualifier() {
    return advanceBookingRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceBookingRateQualifier(AdvanceBookingRateQualifierSupplierDetails advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
  }


  public RateModifierSupplierDetails stayDateRateQualifiers(List<StayDateRateQualifierSupplierDetails> stayDateRateQualifiers) {
    
    this.stayDateRateQualifiers = stayDateRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addStayDateRateQualifiersItem(StayDateRateQualifierSupplierDetails stayDateRateQualifiersItem) {
    if (this.stayDateRateQualifiers == null) {
      this.stayDateRateQualifiers = new ArrayList<>();
    }
    this.stayDateRateQualifiers.add(stayDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific stay dates the user wants to arrive.
   * @return stayDateRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<StayDateRateQualifierSupplierDetails> getStayDateRateQualifiers() {
    return stayDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayDateRateQualifiers(List<StayDateRateQualifierSupplierDetails> stayDateRateQualifiers) {
    this.stayDateRateQualifiers = stayDateRateQualifiers;
  }


  public RateModifierSupplierDetails sellDateRateQualifiers(List<SellDateRateQualifierSupplierDetails> sellDateRateQualifiers) {
    
    this.sellDateRateQualifiers = sellDateRateQualifiers;
    return this;
  }

  public RateModifierSupplierDetails addSellDateRateQualifiersItem(SellDateRateQualifierSupplierDetails sellDateRateQualifiersItem) {
    if (this.sellDateRateQualifiers == null) {
      this.sellDateRateQualifiers = new ArrayList<>();
    }
    this.sellDateRateQualifiers.add(sellDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific dates the booking is made.
   * @return sellDateRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SellDateRateQualifierSupplierDetails> getSellDateRateQualifiers() {
    return sellDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellDateRateQualifiers(List<SellDateRateQualifierSupplierDetails> sellDateRateQualifiers) {
    this.sellDateRateQualifiers = sellDateRateQualifiers;
  }


  public RateModifierSupplierDetails availableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifierSupplierDetails availableDaysOfWeekRateQualifier) {
    
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get availableDaysOfWeekRateQualifier
   * @return availableDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AvailableDaysOfWeekRateQualifierSupplierDetails getAvailableDaysOfWeekRateQualifier() {
    return availableDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifierSupplierDetails availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
  }


  public RateModifierSupplierDetails arrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifierSupplierDetails arrivalDaysOfWeekRateQualifier) {
    
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get arrivalDaysOfWeekRateQualifier
   * @return arrivalDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ArrivalDaysOfWeekRateQualifierSupplierDetails getArrivalDaysOfWeekRateQualifier() {
    return arrivalDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifierSupplierDetails arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
  }


  public RateModifierSupplierDetails departureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifierSupplierDetails departureDaysOfWeekRateQualifier) {
    
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get departureDaysOfWeekRateQualifier
   * @return departureDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DepartureDaysOfWeekRateQualifierSupplierDetails getDepartureDaysOfWeekRateQualifier() {
    return departureDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifierSupplierDetails departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
  }


  public RateModifierSupplierDetails requiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifierSupplierDetails requiredDaysOfWeekRateQualifier) {
    
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get requiredDaysOfWeekRateQualifier
   * @return requiredDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RequiredDaysOfWeekRateQualifierSupplierDetails getRequiredDaysOfWeekRateQualifier() {
    return requiredDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifierSupplierDetails requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
  }


  public RateModifierSupplierDetails masterRateIdentifiers(List<String> masterRateIdentifiers) {
    
    this.masterRateIdentifiers = masterRateIdentifiers;
    return this;
  }

  public RateModifierSupplierDetails addMasterRateIdentifiersItem(String masterRateIdentifiersItem) {
    if (this.masterRateIdentifiers == null) {
      this.masterRateIdentifiers = new ArrayList<>();
    }
    this.masterRateIdentifiers.add(masterRateIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific master rates.
   * @return masterRateIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMasterRateIdentifiers() {
    return masterRateIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateIdentifiers(List<String> masterRateIdentifiers) {
    this.masterRateIdentifiers = masterRateIdentifiers;
  }


  public RateModifierSupplierDetails addOnIdentifiers(List<String> addOnIdentifiers) {
    
    this.addOnIdentifiers = addOnIdentifiers;
    return this;
  }

  public RateModifierSupplierDetails addAddOnIdentifiersItem(String addOnIdentifiersItem) {
    if (this.addOnIdentifiers == null) {
      this.addOnIdentifiers = new ArrayList<>();
    }
    this.addOnIdentifiers.add(addOnIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific add-ons.
   * @return addOnIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAddOnIdentifiers() {
    return addOnIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnIdentifiers(List<String> addOnIdentifiers) {
    this.addOnIdentifiers = addOnIdentifiers;
  }


  public RateModifierSupplierDetails ratePlanIdentifiers(List<String> ratePlanIdentifiers) {
    
    this.ratePlanIdentifiers = ratePlanIdentifiers;
    return this;
  }

  public RateModifierSupplierDetails addRatePlanIdentifiersItem(String ratePlanIdentifiersItem) {
    if (this.ratePlanIdentifiers == null) {
      this.ratePlanIdentifiers = new ArrayList<>();
    }
    this.ratePlanIdentifiers.add(ratePlanIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific rate plans.
   * @return ratePlanIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRatePlanIdentifiers() {
    return ratePlanIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifiers(List<String> ratePlanIdentifiers) {
    this.ratePlanIdentifiers = ratePlanIdentifiers;
  }


  public RateModifierSupplierDetails blackoutDates(List<BlackoutDateSupplierDetails> blackoutDates) {
    
    this.blackoutDates = blackoutDates;
    return this;
  }

  public RateModifierSupplierDetails addBlackoutDatesItem(BlackoutDateSupplierDetails blackoutDatesItem) {
    if (this.blackoutDates == null) {
      this.blackoutDates = new ArrayList<>();
    }
    this.blackoutDates.add(blackoutDatesItem);
    return this;
  }

   /**
   * Exclude this promotion from specific date ranges.
   * @return blackoutDates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BlackoutDateSupplierDetails> getBlackoutDates() {
    return blackoutDates;
  }


  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlackoutDates(List<BlackoutDateSupplierDetails> blackoutDates) {
    this.blackoutDates = blackoutDates;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateModifierSupplierDetails rateModifierSupplierDetails = (RateModifierSupplierDetails) o;
    return Objects.equals(this.identifier, rateModifierSupplierDetails.identifier) &&
        Objects.equals(this.hotelIdentifier, rateModifierSupplierDetails.hotelIdentifier) &&
        Objects.equals(this.name, rateModifierSupplierDetails.name) &&
        Objects.equals(this.type, rateModifierSupplierDetails.type) &&
        Objects.equals(this.modifier, rateModifierSupplierDetails.modifier) &&
        Objects.equals(this.enabled, rateModifierSupplierDetails.enabled) &&
        Objects.equals(this.pricingType, rateModifierSupplierDetails.pricingType) &&
        Objects.equals(this.descriptions, rateModifierSupplierDetails.descriptions) &&
        Objects.equals(this.cityRateQualifiers, rateModifierSupplierDetails.cityRateQualifiers) &&
        Objects.equals(this.continentRateQualifiers, rateModifierSupplierDetails.continentRateQualifiers) &&
        Objects.equals(this.countryRateQualifiers, rateModifierSupplierDetails.countryRateQualifiers) &&
        Objects.equals(this.promotionRateQualifiers, rateModifierSupplierDetails.promotionRateQualifiers) &&
        Objects.equals(this.ipRangeRateQualifiers, rateModifierSupplierDetails.ipRangeRateQualifiers) &&
        Objects.equals(this.roomRangeRateQualifier, rateModifierSupplierDetails.roomRangeRateQualifier) &&
        Objects.equals(this.prepayRateQualifier, rateModifierSupplierDetails.prepayRateQualifier) &&
        Objects.equals(this.refundableRateQualifier, rateModifierSupplierDetails.refundableRateQualifier) &&
        Objects.equals(this.timezoneRateQualifiers, rateModifierSupplierDetails.timezoneRateQualifiers) &&
        Objects.equals(this.lastMinuteRateQualifier, rateModifierSupplierDetails.lastMinuteRateQualifier) &&
        Objects.equals(this.lengthOfStayRateQualifier, rateModifierSupplierDetails.lengthOfStayRateQualifier) &&
        Objects.equals(this.advanceBookingRateQualifier, rateModifierSupplierDetails.advanceBookingRateQualifier) &&
        Objects.equals(this.stayDateRateQualifiers, rateModifierSupplierDetails.stayDateRateQualifiers) &&
        Objects.equals(this.sellDateRateQualifiers, rateModifierSupplierDetails.sellDateRateQualifiers) &&
        Objects.equals(this.availableDaysOfWeekRateQualifier, rateModifierSupplierDetails.availableDaysOfWeekRateQualifier) &&
        Objects.equals(this.arrivalDaysOfWeekRateQualifier, rateModifierSupplierDetails.arrivalDaysOfWeekRateQualifier) &&
        Objects.equals(this.departureDaysOfWeekRateQualifier, rateModifierSupplierDetails.departureDaysOfWeekRateQualifier) &&
        Objects.equals(this.requiredDaysOfWeekRateQualifier, rateModifierSupplierDetails.requiredDaysOfWeekRateQualifier) &&
        Objects.equals(this.masterRateIdentifiers, rateModifierSupplierDetails.masterRateIdentifiers) &&
        Objects.equals(this.addOnIdentifiers, rateModifierSupplierDetails.addOnIdentifiers) &&
        Objects.equals(this.ratePlanIdentifiers, rateModifierSupplierDetails.ratePlanIdentifiers) &&
        Objects.equals(this.blackoutDates, rateModifierSupplierDetails.blackoutDates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, type, modifier, enabled, pricingType, descriptions, cityRateQualifiers, continentRateQualifiers, countryRateQualifiers, promotionRateQualifiers, ipRangeRateQualifiers, roomRangeRateQualifier, prepayRateQualifier, refundableRateQualifier, timezoneRateQualifiers, lastMinuteRateQualifier, lengthOfStayRateQualifier, advanceBookingRateQualifier, stayDateRateQualifiers, sellDateRateQualifiers, availableDaysOfWeekRateQualifier, arrivalDaysOfWeekRateQualifier, departureDaysOfWeekRateQualifier, requiredDaysOfWeekRateQualifier, masterRateIdentifiers, addOnIdentifiers, ratePlanIdentifiers, blackoutDates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateModifierSupplierDetails {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    modifier: ").append(toIndentedString(modifier)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    cityRateQualifiers: ").append(toIndentedString(cityRateQualifiers)).append("\n");
    sb.append("    continentRateQualifiers: ").append(toIndentedString(continentRateQualifiers)).append("\n");
    sb.append("    countryRateQualifiers: ").append(toIndentedString(countryRateQualifiers)).append("\n");
    sb.append("    promotionRateQualifiers: ").append(toIndentedString(promotionRateQualifiers)).append("\n");
    sb.append("    ipRangeRateQualifiers: ").append(toIndentedString(ipRangeRateQualifiers)).append("\n");
    sb.append("    roomRangeRateQualifier: ").append(toIndentedString(roomRangeRateQualifier)).append("\n");
    sb.append("    prepayRateQualifier: ").append(toIndentedString(prepayRateQualifier)).append("\n");
    sb.append("    refundableRateQualifier: ").append(toIndentedString(refundableRateQualifier)).append("\n");
    sb.append("    timezoneRateQualifiers: ").append(toIndentedString(timezoneRateQualifiers)).append("\n");
    sb.append("    lastMinuteRateQualifier: ").append(toIndentedString(lastMinuteRateQualifier)).append("\n");
    sb.append("    lengthOfStayRateQualifier: ").append(toIndentedString(lengthOfStayRateQualifier)).append("\n");
    sb.append("    advanceBookingRateQualifier: ").append(toIndentedString(advanceBookingRateQualifier)).append("\n");
    sb.append("    stayDateRateQualifiers: ").append(toIndentedString(stayDateRateQualifiers)).append("\n");
    sb.append("    sellDateRateQualifiers: ").append(toIndentedString(sellDateRateQualifiers)).append("\n");
    sb.append("    availableDaysOfWeekRateQualifier: ").append(toIndentedString(availableDaysOfWeekRateQualifier)).append("\n");
    sb.append("    arrivalDaysOfWeekRateQualifier: ").append(toIndentedString(arrivalDaysOfWeekRateQualifier)).append("\n");
    sb.append("    departureDaysOfWeekRateQualifier: ").append(toIndentedString(departureDaysOfWeekRateQualifier)).append("\n");
    sb.append("    requiredDaysOfWeekRateQualifier: ").append(toIndentedString(requiredDaysOfWeekRateQualifier)).append("\n");
    sb.append("    masterRateIdentifiers: ").append(toIndentedString(masterRateIdentifiers)).append("\n");
    sb.append("    addOnIdentifiers: ").append(toIndentedString(addOnIdentifiers)).append("\n");
    sb.append("    ratePlanIdentifiers: ").append(toIndentedString(ratePlanIdentifiers)).append("\n");
    sb.append("    blackoutDates: ").append(toIndentedString(blackoutDates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

