/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.2.7
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Recognition for the ancillary inventory.
 */
@JsonPropertyOrder({
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_IDENTIFIER,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_CATEGORY,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_TYPE,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_PROVIDER,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_RATING,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_MAX_RATING,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_DATE,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND,
  TravelInventoryRecognitionSupplierDetails.JSON_PROPERTY_RATING_SYMBOL
})
@JsonTypeName("TravelInventoryRecognition_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-26T14:36:45.544169528+07:00[Asia/Bangkok]")
public class TravelInventoryRecognitionSupplierDetails {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  /**
   * Recognition category.
   */
  public enum CategoryEnum {
    THIRD_PARTY_REVIEW("THIRD_PARTY_REVIEW"),
    
    PUBLICATION("PUBLICATION"),
    
    AWARD("AWARD");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private CategoryEnum category;

  /**
   * Type of rating system the recognition operated on. This allows us to display the score properly.
   */
  public enum TypeEnum {
    STAR_RATING("STAR_RATING"),
    
    NUMERIC_RATING("NUMERIC_RATING"),
    
    PERCENT_RATING("PERCENT_RATING");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private String provider;

  public static final String JSON_PROPERTY_RATING = "rating";
  private Float rating;

  public static final String JSON_PROPERTY_MAX_RATING = "maxRating";
  private Float maxRating;

  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND = "officialAppointmentInd";
  private Boolean officialAppointmentInd;

  public static final String JSON_PROPERTY_RATING_SYMBOL = "ratingSymbol";
  private String ratingSymbol;

  public TravelInventoryRecognitionSupplierDetails() {
  }

  public TravelInventoryRecognitionSupplierDetails identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Recognition identifier.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public TravelInventoryRecognitionSupplierDetails category(CategoryEnum category) {
    
    this.category = category;
    return this;
  }

   /**
   * Recognition category.
   * @return category
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CategoryEnum getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCategory(CategoryEnum category) {
    this.category = category;
  }


  public TravelInventoryRecognitionSupplierDetails type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of rating system the recognition operated on. This allows us to display the score properly.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public TravelInventoryRecognitionSupplierDetails provider(String provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * The name of the entity that administers this recognition.
   * @return provider
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProvider(String provider) {
    this.provider = provider;
  }


  public TravelInventoryRecognitionSupplierDetails rating(Float rating) {
    
    this.rating = rating;
    return this;
  }

   /**
   * The actual award or rating received by the hotel facility.
   * minimum: 0.0
   * @return rating
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0")
  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getRating() {
    return rating;
  }


  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRating(Float rating) {
    this.rating = rating;
  }


  public TravelInventoryRecognitionSupplierDetails maxRating(Float maxRating) {
    
    this.maxRating = maxRating;
    return this;
  }

   /**
   * Use this to let hotels indicate what the total score for this award is.
   * @return maxRating
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAX_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getMaxRating() {
    return maxRating;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxRating(Float maxRating) {
    this.maxRating = maxRating;
  }


  public TravelInventoryRecognitionSupplierDetails date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * The date the award was received
   * @return date
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  public TravelInventoryRecognitionSupplierDetails officialAppointmentInd(Boolean officialAppointmentInd) {
    
    this.officialAppointmentInd = officialAppointmentInd;
    return this;
  }

   /**
   * When true, this indicates the property has received official permission from the award provider to use the rating in publications and marketing materials; when false this permission has not been granted.
   * @return officialAppointmentInd
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOfficialAppointmentInd() {
    return officialAppointmentInd;
  }


  @JsonProperty(JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfficialAppointmentInd(Boolean officialAppointmentInd) {
    this.officialAppointmentInd = officialAppointmentInd;
  }


  public TravelInventoryRecognitionSupplierDetails ratingSymbol(String ratingSymbol) {
    
    this.ratingSymbol = ratingSymbol;
    return this;
  }

   /**
   * Provides the symbol used in the rating. Used in conjunction with the Rating.
   * @return ratingSymbol
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATING_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRatingSymbol() {
    return ratingSymbol;
  }


  @JsonProperty(JSON_PROPERTY_RATING_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatingSymbol(String ratingSymbol) {
    this.ratingSymbol = ratingSymbol;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TravelInventoryRecognitionSupplierDetails travelInventoryRecognitionSupplierDetails = (TravelInventoryRecognitionSupplierDetails) o;
    return Objects.equals(this.identifier, travelInventoryRecognitionSupplierDetails.identifier) &&
        Objects.equals(this.category, travelInventoryRecognitionSupplierDetails.category) &&
        Objects.equals(this.type, travelInventoryRecognitionSupplierDetails.type) &&
        Objects.equals(this.provider, travelInventoryRecognitionSupplierDetails.provider) &&
        Objects.equals(this.rating, travelInventoryRecognitionSupplierDetails.rating) &&
        Objects.equals(this.maxRating, travelInventoryRecognitionSupplierDetails.maxRating) &&
        Objects.equals(this.date, travelInventoryRecognitionSupplierDetails.date) &&
        Objects.equals(this.officialAppointmentInd, travelInventoryRecognitionSupplierDetails.officialAppointmentInd) &&
        Objects.equals(this.ratingSymbol, travelInventoryRecognitionSupplierDetails.ratingSymbol);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, category, type, provider, rating, maxRating, date, officialAppointmentInd, ratingSymbol);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TravelInventoryRecognitionSupplierDetails {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    rating: ").append(toIndentedString(rating)).append("\n");
    sb.append("    maxRating: ").append(toIndentedString(maxRating)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    officialAppointmentInd: ").append(toIndentedString(officialAppointmentInd)).append("\n");
    sb.append("    ratingSymbol: ").append(toIndentedString(ratingSymbol)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

