/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.BookingContractItemSupplier;
import travel.wink.sdk.extranet.model.BookingContractPaymentDetailsSupplier;
import travel.wink.sdk.extranet.model.MoneysSupplier;
import travel.wink.sdk.extranet.model.QuoteSupplier;
import travel.wink.sdk.extranet.model.RefundSupplier;

@JsonPropertyOrder(value={"bookingContractIdentifier", "createdDate", "lastUpdate", "ipAddress", "traceId", "sourceUrl", "identifier", "supplierIdentifier", "supplierName", "displayPriceQuote", "supplierPriceQuote", "internalPriceQuote", "capturePriceQuote", "itemList", "externalSupplierIdentifier", "externalSupplierBookingCode", "payment", "cancelled", "cancelledOn", "canceller", "cancellationType", "cancellerUserIdentifier", "cancelReason", "fundsProcessed", "refunds", "sourceCurrency", "displayCurrency", "supplierCurrency", "internalCurrency", "captureCurrency", "sourceAmount", "displayAmount", "supplierAmount", "internalAmount", "captureAmount", "sourceAmountRefundModifier", "displayAmountRefundModifier", "supplierAmountRefundModifier", "internalAmountRefundModifier", "captureAmountRefundModifier", "netSourceAmount", "netDisplayAmount", "netSupplierAmount", "netInternalAmount", "netCaptureAmount", "totalTokensEarned", "cancellableBySupplier", "cancellableByTraveler", "cancellableWithNoCharges", "isCancellableWithPotentialCharges", "commissionableTotalSourceAmount", "commissionableTotalCaptureAmount", "commissionableTotalDisplayAmount", "commissionableTotalSupplierAmount", "commissionableTotalInternalAmount"})
@JsonTypeName(value="BookingContract_Supplier")
public class BookingContractSupplier {
    public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
    private UUID bookingContractIdentifier;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
    private String ipAddress;
    public static final String JSON_PROPERTY_TRACE_ID = "traceId";
    private String traceId;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    private String supplierName;
    public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
    private QuoteSupplier displayPriceQuote;
    public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
    private QuoteSupplier supplierPriceQuote;
    public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
    private QuoteSupplier internalPriceQuote;
    public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
    private QuoteSupplier capturePriceQuote;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<BookingContractItemSupplier> itemList = new ArrayList<BookingContractItemSupplier>();
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
    private String externalSupplierIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_PAYMENT = "payment";
    private BookingContractPaymentDetailsSupplier payment;
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    private Boolean cancelled = false;
    public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
    private LocalDateTime cancelledOn;
    public static final String JSON_PROPERTY_CANCELLER = "canceller";
    private CancellerEnum canceller;
    public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
    private CancellationTypeEnum cancellationType;
    public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
    private String cancellerUserIdentifier;
    public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
    private String cancelReason;
    public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
    private Boolean fundsProcessed;
    public static final String JSON_PROPERTY_REFUNDS = "refunds";
    private List<RefundSupplier> refunds = new ArrayList<RefundSupplier>();
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private String sourceCurrency;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency;
    public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
    private String supplierCurrency;
    public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
    private String internalCurrency;
    public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
    private String captureCurrency;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    private Double sourceAmount;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
    private Double displayAmount;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
    private Double supplierAmount;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
    private Double internalAmount;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
    private Double captureAmount;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
    private Double sourceAmountRefundModifier;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
    private Double displayAmountRefundModifier;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
    private Double supplierAmountRefundModifier;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
    private Double internalAmountRefundModifier;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
    private Double captureAmountRefundModifier;
    public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
    private Double netSourceAmount;
    public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
    private Double netDisplayAmount;
    public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
    private Double netSupplierAmount;
    public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
    private Double netInternalAmount;
    public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
    private Double netCaptureAmount;
    public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
    private Long totalTokensEarned;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
    private Boolean cancellableBySupplier;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
    private Boolean isCancellableWithPotentialCharges;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
    private MoneysSupplier commissionableTotalSourceAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
    private MoneysSupplier commissionableTotalCaptureAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
    private MoneysSupplier commissionableTotalDisplayAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
    private MoneysSupplier commissionableTotalSupplierAmount;
    public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
    private MoneysSupplier commissionableTotalInternalAmount;

    public BookingContractSupplier bookingContractIdentifier(UUID bookingContractIdentifier) {
        this.bookingContractIdentifier = bookingContractIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="bookingContractIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getBookingContractIdentifier() {
        return this.bookingContractIdentifier;
    }

    @JsonProperty(value="bookingContractIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingContractIdentifier(UUID bookingContractIdentifier) {
        this.bookingContractIdentifier = bookingContractIdentifier;
    }

    public BookingContractSupplier createdDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public BookingContractSupplier lastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public BookingContractSupplier ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="ipAddress")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public BookingContractSupplier traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTraceId() {
        return this.traceId;
    }

    @JsonProperty(value="traceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public BookingContractSupplier sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public BookingContractSupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public BookingContractSupplier supplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public BookingContractSupplier supplierName(String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BookingContractSupplier displayPriceQuote(QuoteSupplier displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteSupplier getDisplayPriceQuote() {
        return this.displayPriceQuote;
    }

    @JsonProperty(value="displayPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayPriceQuote(QuoteSupplier displayPriceQuote) {
        this.displayPriceQuote = displayPriceQuote;
    }

    public BookingContractSupplier supplierPriceQuote(QuoteSupplier supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteSupplier getSupplierPriceQuote() {
        return this.supplierPriceQuote;
    }

    @JsonProperty(value="supplierPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierPriceQuote(QuoteSupplier supplierPriceQuote) {
        this.supplierPriceQuote = supplierPriceQuote;
    }

    public BookingContractSupplier internalPriceQuote(QuoteSupplier internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteSupplier getInternalPriceQuote() {
        return this.internalPriceQuote;
    }

    @JsonProperty(value="internalPriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalPriceQuote(QuoteSupplier internalPriceQuote) {
        this.internalPriceQuote = internalPriceQuote;
    }

    public BookingContractSupplier capturePriceQuote(QuoteSupplier capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteSupplier getCapturePriceQuote() {
        return this.capturePriceQuote;
    }

    @JsonProperty(value="capturePriceQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCapturePriceQuote(QuoteSupplier capturePriceQuote) {
        this.capturePriceQuote = capturePriceQuote;
    }

    public BookingContractSupplier itemList(List<BookingContractItemSupplier> itemList) {
        this.itemList = itemList;
        return this;
    }

    public BookingContractSupplier addItemListItem(BookingContractItemSupplier itemListItem) {
        this.itemList.add(itemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<BookingContractItemSupplier> getItemList() {
        return this.itemList;
    }

    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemList(List<BookingContractItemSupplier> itemList) {
        this.itemList = itemList;
    }

    public BookingContractSupplier externalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierIdentifier() {
        return this.externalSupplierIdentifier;
    }

    @JsonProperty(value="externalSupplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
        this.externalSupplierIdentifier = externalSupplierIdentifier;
    }

    public BookingContractSupplier externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public BookingContractSupplier payment(BookingContractPaymentDetailsSupplier payment) {
        this.payment = payment;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BookingContractPaymentDetailsSupplier getPayment() {
        return this.payment;
    }

    @JsonProperty(value="payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayment(BookingContractPaymentDetailsSupplier payment) {
        this.payment = payment;
    }

    public BookingContractSupplier cancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractSupplier cancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCancelledOn() {
        return this.cancelledOn;
    }

    @JsonProperty(value="cancelledOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelledOn(LocalDateTime cancelledOn) {
        this.cancelledOn = cancelledOn;
    }

    public BookingContractSupplier canceller(CancellerEnum canceller) {
        this.canceller = canceller;
        return this;
    }

    @Nullable
    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellerEnum getCanceller() {
        return this.canceller;
    }

    @JsonProperty(value="canceller")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanceller(CancellerEnum canceller) {
        this.canceller = canceller;
    }

    public BookingContractSupplier cancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CancellationTypeEnum getCancellationType() {
        return this.cancellationType;
    }

    @JsonProperty(value="cancellationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellationType(CancellationTypeEnum cancellationType) {
        this.cancellationType = cancellationType;
    }

    public BookingContractSupplier cancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancellerUserIdentifier() {
        return this.cancellerUserIdentifier;
    }

    @JsonProperty(value="cancellerUserIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
        this.cancellerUserIdentifier = cancellerUserIdentifier;
    }

    public BookingContractSupplier cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonProperty(value="cancelReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public BookingContractSupplier fundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
        return this;
    }

    @Nullable
    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFundsProcessed() {
        return this.fundsProcessed;
    }

    @JsonProperty(value="fundsProcessed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundsProcessed(Boolean fundsProcessed) {
        this.fundsProcessed = fundsProcessed;
    }

    public BookingContractSupplier refunds(List<RefundSupplier> refunds) {
        this.refunds = refunds;
        return this;
    }

    public BookingContractSupplier addRefundsItem(RefundSupplier refundsItem) {
        if (this.refunds == null) {
            this.refunds = new ArrayList<RefundSupplier>();
        }
        this.refunds.add(refundsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RefundSupplier> getRefunds() {
        return this.refunds;
    }

    @JsonProperty(value="refunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefunds(List<RefundSupplier> refunds) {
        this.refunds = refunds;
    }

    public BookingContractSupplier sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public BookingContractSupplier displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public BookingContractSupplier supplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSupplierCurrency() {
        return this.supplierCurrency;
    }

    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierCurrency(String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
    }

    public BookingContractSupplier internalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInternalCurrency() {
        return this.internalCurrency;
    }

    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalCurrency(String internalCurrency) {
        this.internalCurrency = internalCurrency;
    }

    public BookingContractSupplier captureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCaptureCurrency() {
        return this.captureCurrency;
    }

    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureCurrency(String captureCurrency) {
        this.captureCurrency = captureCurrency;
    }

    public BookingContractSupplier sourceAmount(Double sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getSourceAmount() {
        return this.sourceAmount;
    }

    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAmount(Double sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public BookingContractSupplier displayAmount(Double displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getDisplayAmount() {
        return this.displayAmount;
    }

    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayAmount(Double displayAmount) {
        this.displayAmount = displayAmount;
    }

    public BookingContractSupplier supplierAmount(Double supplierAmount) {
        this.supplierAmount = supplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getSupplierAmount() {
        return this.supplierAmount;
    }

    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmount(Double supplierAmount) {
        this.supplierAmount = supplierAmount;
    }

    public BookingContractSupplier internalAmount(Double internalAmount) {
        this.internalAmount = internalAmount;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getInternalAmount() {
        return this.internalAmount;
    }

    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAmount(Double internalAmount) {
        this.internalAmount = internalAmount;
    }

    public BookingContractSupplier captureAmount(Double captureAmount) {
        this.captureAmount = captureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getCaptureAmount() {
        return this.captureAmount;
    }

    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureAmount(Double captureAmount) {
        this.captureAmount = captureAmount;
    }

    public BookingContractSupplier sourceAmountRefundModifier(Double sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getSourceAmountRefundModifier() {
        return this.sourceAmountRefundModifier;
    }

    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAmountRefundModifier(Double sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    }

    public BookingContractSupplier displayAmountRefundModifier(Double displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getDisplayAmountRefundModifier() {
        return this.displayAmountRefundModifier;
    }

    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayAmountRefundModifier(Double displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
    }

    public BookingContractSupplier supplierAmountRefundModifier(Double supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getSupplierAmountRefundModifier() {
        return this.supplierAmountRefundModifier;
    }

    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierAmountRefundModifier(Double supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    }

    public BookingContractSupplier internalAmountRefundModifier(Double internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getInternalAmountRefundModifier() {
        return this.internalAmountRefundModifier;
    }

    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAmountRefundModifier(Double internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
    }

    public BookingContractSupplier captureAmountRefundModifier(Double captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getCaptureAmountRefundModifier() {
        return this.captureAmountRefundModifier;
    }

    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureAmountRefundModifier(Double captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
    }

    public BookingContractSupplier netSourceAmount(Double netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getNetSourceAmount() {
        return this.netSourceAmount;
    }

    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetSourceAmount(Double netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
    }

    public BookingContractSupplier netDisplayAmount(Double netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getNetDisplayAmount() {
        return this.netDisplayAmount;
    }

    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetDisplayAmount(Double netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
    }

    public BookingContractSupplier netSupplierAmount(Double netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getNetSupplierAmount() {
        return this.netSupplierAmount;
    }

    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetSupplierAmount(Double netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
    }

    public BookingContractSupplier netInternalAmount(Double netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") Double getNetInternalAmount() {
        return this.netInternalAmount;
    }

    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetInternalAmount(Double netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
    }

    public BookingContractSupplier netCaptureAmount(Double netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0")
    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0") Double getNetCaptureAmount() {
        return this.netCaptureAmount;
    }

    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetCaptureAmount(Double netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
    }

    public BookingContractSupplier totalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalTokensEarned() {
        return this.totalTokensEarned;
    }

    @JsonProperty(value="totalTokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalTokensEarned(Long totalTokensEarned) {
        this.totalTokensEarned = totalTokensEarned;
    }

    public BookingContractSupplier cancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplier() {
        return this.cancellableBySupplier;
    }

    @JsonProperty(value="cancellableBySupplier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplier(Boolean cancellableBySupplier) {
        this.cancellableBySupplier = cancellableBySupplier;
    }

    public BookingContractSupplier cancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractSupplier cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContractSupplier isCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
        this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="isCancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCancellableWithPotentialCharges() {
        return this.isCancellableWithPotentialCharges;
    }

    @JsonProperty(value="isCancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
        this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    }

    public BookingContractSupplier commissionableTotalSourceAmount(MoneysSupplier commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getCommissionableTotalSourceAmount() {
        return this.commissionableTotalSourceAmount;
    }

    @JsonProperty(value="commissionableTotalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSourceAmount(MoneysSupplier commissionableTotalSourceAmount) {
        this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    }

    public BookingContractSupplier commissionableTotalCaptureAmount(MoneysSupplier commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getCommissionableTotalCaptureAmount() {
        return this.commissionableTotalCaptureAmount;
    }

    @JsonProperty(value="commissionableTotalCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalCaptureAmount(MoneysSupplier commissionableTotalCaptureAmount) {
        this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    }

    public BookingContractSupplier commissionableTotalDisplayAmount(MoneysSupplier commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getCommissionableTotalDisplayAmount() {
        return this.commissionableTotalDisplayAmount;
    }

    @JsonProperty(value="commissionableTotalDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalDisplayAmount(MoneysSupplier commissionableTotalDisplayAmount) {
        this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    }

    public BookingContractSupplier commissionableTotalSupplierAmount(MoneysSupplier commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getCommissionableTotalSupplierAmount() {
        return this.commissionableTotalSupplierAmount;
    }

    @JsonProperty(value="commissionableTotalSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalSupplierAmount(MoneysSupplier commissionableTotalSupplierAmount) {
        this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    }

    public BookingContractSupplier commissionableTotalInternalAmount(MoneysSupplier commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysSupplier getCommissionableTotalInternalAmount() {
        return this.commissionableTotalInternalAmount;
    }

    @JsonProperty(value="commissionableTotalInternalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionableTotalInternalAmount(MoneysSupplier commissionableTotalInternalAmount) {
        this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractSupplier bookingContractSupplier = (BookingContractSupplier)o;
        return Objects.equals(this.bookingContractIdentifier, bookingContractSupplier.bookingContractIdentifier) && Objects.equals(this.createdDate, bookingContractSupplier.createdDate) && Objects.equals(this.lastUpdate, bookingContractSupplier.lastUpdate) && Objects.equals(this.ipAddress, bookingContractSupplier.ipAddress) && Objects.equals(this.traceId, bookingContractSupplier.traceId) && Objects.equals(this.sourceUrl, bookingContractSupplier.sourceUrl) && Objects.equals(this.identifier, bookingContractSupplier.identifier) && Objects.equals(this.supplierIdentifier, bookingContractSupplier.supplierIdentifier) && Objects.equals(this.supplierName, bookingContractSupplier.supplierName) && Objects.equals(this.displayPriceQuote, bookingContractSupplier.displayPriceQuote) && Objects.equals(this.supplierPriceQuote, bookingContractSupplier.supplierPriceQuote) && Objects.equals(this.internalPriceQuote, bookingContractSupplier.internalPriceQuote) && Objects.equals(this.capturePriceQuote, bookingContractSupplier.capturePriceQuote) && Objects.equals(this.itemList, bookingContractSupplier.itemList) && Objects.equals(this.externalSupplierIdentifier, bookingContractSupplier.externalSupplierIdentifier) && Objects.equals(this.externalSupplierBookingCode, bookingContractSupplier.externalSupplierBookingCode) && Objects.equals(this.payment, bookingContractSupplier.payment) && Objects.equals(this.cancelled, bookingContractSupplier.cancelled) && Objects.equals(this.cancelledOn, bookingContractSupplier.cancelledOn) && Objects.equals((Object)this.canceller, (Object)bookingContractSupplier.canceller) && Objects.equals((Object)this.cancellationType, (Object)bookingContractSupplier.cancellationType) && Objects.equals(this.cancellerUserIdentifier, bookingContractSupplier.cancellerUserIdentifier) && Objects.equals(this.cancelReason, bookingContractSupplier.cancelReason) && Objects.equals(this.fundsProcessed, bookingContractSupplier.fundsProcessed) && Objects.equals(this.refunds, bookingContractSupplier.refunds) && Objects.equals(this.sourceCurrency, bookingContractSupplier.sourceCurrency) && Objects.equals(this.displayCurrency, bookingContractSupplier.displayCurrency) && Objects.equals(this.supplierCurrency, bookingContractSupplier.supplierCurrency) && Objects.equals(this.internalCurrency, bookingContractSupplier.internalCurrency) && Objects.equals(this.captureCurrency, bookingContractSupplier.captureCurrency) && Objects.equals(this.sourceAmount, bookingContractSupplier.sourceAmount) && Objects.equals(this.displayAmount, bookingContractSupplier.displayAmount) && Objects.equals(this.supplierAmount, bookingContractSupplier.supplierAmount) && Objects.equals(this.internalAmount, bookingContractSupplier.internalAmount) && Objects.equals(this.captureAmount, bookingContractSupplier.captureAmount) && Objects.equals(this.sourceAmountRefundModifier, bookingContractSupplier.sourceAmountRefundModifier) && Objects.equals(this.displayAmountRefundModifier, bookingContractSupplier.displayAmountRefundModifier) && Objects.equals(this.supplierAmountRefundModifier, bookingContractSupplier.supplierAmountRefundModifier) && Objects.equals(this.internalAmountRefundModifier, bookingContractSupplier.internalAmountRefundModifier) && Objects.equals(this.captureAmountRefundModifier, bookingContractSupplier.captureAmountRefundModifier) && Objects.equals(this.netSourceAmount, bookingContractSupplier.netSourceAmount) && Objects.equals(this.netDisplayAmount, bookingContractSupplier.netDisplayAmount) && Objects.equals(this.netSupplierAmount, bookingContractSupplier.netSupplierAmount) && Objects.equals(this.netInternalAmount, bookingContractSupplier.netInternalAmount) && Objects.equals(this.netCaptureAmount, bookingContractSupplier.netCaptureAmount) && Objects.equals(this.totalTokensEarned, bookingContractSupplier.totalTokensEarned) && Objects.equals(this.cancellableBySupplier, bookingContractSupplier.cancellableBySupplier) && Objects.equals(this.cancellableByTraveler, bookingContractSupplier.cancellableByTraveler) && Objects.equals(this.cancellableWithNoCharges, bookingContractSupplier.cancellableWithNoCharges) && Objects.equals(this.isCancellableWithPotentialCharges, bookingContractSupplier.isCancellableWithPotentialCharges) && Objects.equals(this.commissionableTotalSourceAmount, bookingContractSupplier.commissionableTotalSourceAmount) && Objects.equals(this.commissionableTotalCaptureAmount, bookingContractSupplier.commissionableTotalCaptureAmount) && Objects.equals(this.commissionableTotalDisplayAmount, bookingContractSupplier.commissionableTotalDisplayAmount) && Objects.equals(this.commissionableTotalSupplierAmount, bookingContractSupplier.commissionableTotalSupplierAmount) && Objects.equals(this.commissionableTotalInternalAmount, bookingContractSupplier.commissionableTotalInternalAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bookingContractIdentifier, this.createdDate, this.lastUpdate, this.ipAddress, this.traceId, this.sourceUrl, this.identifier, this.supplierIdentifier, this.supplierName, this.displayPriceQuote, this.supplierPriceQuote, this.internalPriceQuote, this.capturePriceQuote, this.itemList, this.externalSupplierIdentifier, this.externalSupplierBookingCode, this.payment, this.cancelled, this.cancelledOn, this.canceller, this.cancellationType, this.cancellerUserIdentifier, this.cancelReason, this.fundsProcessed, this.refunds, this.sourceCurrency, this.displayCurrency, this.supplierCurrency, this.internalCurrency, this.captureCurrency, this.sourceAmount, this.displayAmount, this.supplierAmount, this.internalAmount, this.captureAmount, this.sourceAmountRefundModifier, this.displayAmountRefundModifier, this.supplierAmountRefundModifier, this.internalAmountRefundModifier, this.captureAmountRefundModifier, this.netSourceAmount, this.netDisplayAmount, this.netSupplierAmount, this.netInternalAmount, this.netCaptureAmount, this.totalTokensEarned, this.cancellableBySupplier, this.cancellableByTraveler, this.cancellableWithNoCharges, this.isCancellableWithPotentialCharges, this.commissionableTotalSourceAmount, this.commissionableTotalCaptureAmount, this.commissionableTotalDisplayAmount, this.commissionableTotalSupplierAmount, this.commissionableTotalInternalAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractSupplier {\n");
        sb.append("    bookingContractIdentifier: ").append(this.toIndentedString(this.bookingContractIdentifier)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    displayPriceQuote: ").append(this.toIndentedString(this.displayPriceQuote)).append("\n");
        sb.append("    supplierPriceQuote: ").append(this.toIndentedString(this.supplierPriceQuote)).append("\n");
        sb.append("    internalPriceQuote: ").append(this.toIndentedString(this.internalPriceQuote)).append("\n");
        sb.append("    capturePriceQuote: ").append(this.toIndentedString(this.capturePriceQuote)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    externalSupplierIdentifier: ").append(this.toIndentedString(this.externalSupplierIdentifier)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    cancelledOn: ").append(this.toIndentedString(this.cancelledOn)).append("\n");
        sb.append("    canceller: ").append(this.toIndentedString((Object)this.canceller)).append("\n");
        sb.append("    cancellationType: ").append(this.toIndentedString((Object)this.cancellationType)).append("\n");
        sb.append("    cancellerUserIdentifier: ").append(this.toIndentedString(this.cancellerUserIdentifier)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    fundsProcessed: ").append(this.toIndentedString(this.fundsProcessed)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    supplierCurrency: ").append(this.toIndentedString(this.supplierCurrency)).append("\n");
        sb.append("    internalCurrency: ").append(this.toIndentedString(this.internalCurrency)).append("\n");
        sb.append("    captureCurrency: ").append(this.toIndentedString(this.captureCurrency)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    displayAmount: ").append(this.toIndentedString(this.displayAmount)).append("\n");
        sb.append("    supplierAmount: ").append(this.toIndentedString(this.supplierAmount)).append("\n");
        sb.append("    internalAmount: ").append(this.toIndentedString(this.internalAmount)).append("\n");
        sb.append("    captureAmount: ").append(this.toIndentedString(this.captureAmount)).append("\n");
        sb.append("    sourceAmountRefundModifier: ").append(this.toIndentedString(this.sourceAmountRefundModifier)).append("\n");
        sb.append("    displayAmountRefundModifier: ").append(this.toIndentedString(this.displayAmountRefundModifier)).append("\n");
        sb.append("    supplierAmountRefundModifier: ").append(this.toIndentedString(this.supplierAmountRefundModifier)).append("\n");
        sb.append("    internalAmountRefundModifier: ").append(this.toIndentedString(this.internalAmountRefundModifier)).append("\n");
        sb.append("    captureAmountRefundModifier: ").append(this.toIndentedString(this.captureAmountRefundModifier)).append("\n");
        sb.append("    netSourceAmount: ").append(this.toIndentedString(this.netSourceAmount)).append("\n");
        sb.append("    netDisplayAmount: ").append(this.toIndentedString(this.netDisplayAmount)).append("\n");
        sb.append("    netSupplierAmount: ").append(this.toIndentedString(this.netSupplierAmount)).append("\n");
        sb.append("    netInternalAmount: ").append(this.toIndentedString(this.netInternalAmount)).append("\n");
        sb.append("    netCaptureAmount: ").append(this.toIndentedString(this.netCaptureAmount)).append("\n");
        sb.append("    totalTokensEarned: ").append(this.toIndentedString(this.totalTokensEarned)).append("\n");
        sb.append("    cancellableBySupplier: ").append(this.toIndentedString(this.cancellableBySupplier)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    isCancellableWithPotentialCharges: ").append(this.toIndentedString(this.isCancellableWithPotentialCharges)).append("\n");
        sb.append("    commissionableTotalSourceAmount: ").append(this.toIndentedString(this.commissionableTotalSourceAmount)).append("\n");
        sb.append("    commissionableTotalCaptureAmount: ").append(this.toIndentedString(this.commissionableTotalCaptureAmount)).append("\n");
        sb.append("    commissionableTotalDisplayAmount: ").append(this.toIndentedString(this.commissionableTotalDisplayAmount)).append("\n");
        sb.append("    commissionableTotalSupplierAmount: ").append(this.toIndentedString(this.commissionableTotalSupplierAmount)).append("\n");
        sb.append("    commissionableTotalInternalAmount: ").append(this.toIndentedString(this.commissionableTotalInternalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CancellerEnum {
        SALES_CHANNEL("SALES_CHANNEL"),
        SUPPLIER("SUPPLIER"),
        TRAVELER("TRAVELER"),
        ACQUIRER("ACQUIRER"),
        ADMINISTRATOR("ADMINISTRATOR");

        private String value;

        private CancellerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellerEnum fromValue(String value) {
            for (CancellerEnum b : CancellerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancellationTypeEnum {
        DUPLICATE("DUPLICATE"),
        CANCELLATION("CANCELLATION"),
        NO_SHOW("NO_SHOW"),
        CC_INVALID("CC_INVALID"),
        CC_INSUFFICIENT("CC_INSUFFICIENT"),
        DISCRETIONARY("DISCRETIONARY");

        private String value;

        private CancellationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancellationTypeEnum fromValue(String value) {
            for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

