package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.AgreementSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.HotelViewSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-05T11:16:56.266186763+07:00[Asia/Bangkok]")
public class AgreementApi {
    private ApiClient apiClient;

    public AgreementApi() {
        this(new ApiClient());
    }

    @Autowired
    public AgreementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show hotel agreement
     * Retrieve hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return AgreementSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelAgreementRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelAgreement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AgreementSupplier> localVarReturnType = new ParameterizedTypeReference<AgreementSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/agreement", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show hotel agreement
     * Retrieve hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return AgreementSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AgreementSupplier> showHotelAgreement(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AgreementSupplier> localVarReturnType = new ParameterizedTypeReference<AgreementSupplier>() {};
        return showHotelAgreementRequestCreation(hotelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show hotel agreement
     * Retrieve hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AgreementSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AgreementSupplier>> showHotelAgreementWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AgreementSupplier> localVarReturnType = new ParameterizedTypeReference<AgreementSupplier>() {};
        return showHotelAgreementRequestCreation(hotelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show hotel agreement
     * Retrieve hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelAgreementWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showHotelAgreementRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update agreement
     * Update hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param agreementSupplier The agreementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateHotelAgreementRequestCreation(String hotelIdentifier, AgreementSupplier agreementSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = agreementSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateHotelAgreement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'agreementSupplier' is set
        if (agreementSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'agreementSupplier' when calling updateHotelAgreement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/agreement", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update agreement
     * Update hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param agreementSupplier The agreementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateHotelAgreement(String hotelIdentifier, AgreementSupplier agreementSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateHotelAgreementRequestCreation(hotelIdentifier, agreementSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update agreement
     * Update hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param agreementSupplier The agreementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateHotelAgreementWithHttpInfo(String hotelIdentifier, AgreementSupplier agreementSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateHotelAgreementRequestCreation(hotelIdentifier, agreementSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update agreement
     * Update hotel&#39;s current agreement
     * <p><b>503</b> - Service Unavailable
     * <p><b>405</b> - Method Not Allowed
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param agreementSupplier The agreementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateHotelAgreementWithResponseSpec(String hotelIdentifier, AgreementSupplier agreementSupplier, String winkVersion) throws WebClientResponseException {
        return updateHotelAgreementRequestCreation(hotelIdentifier, agreementSupplier, winkVersion);
    }
}
