/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.3.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.BookingContractItemSupplierDetails;
import travel.wink.sdk.extranet.model.BookingContractPaymentDetailsSupplierDetails;
import travel.wink.sdk.extranet.model.MoneysSupplierDetails;
import travel.wink.sdk.extranet.model.QuoteSupplierDetails;
import travel.wink.sdk.extranet.model.RefundSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Booking contract created by TripPay
 */
@JsonPropertyOrder({
  BookingContractSupplierDetails.JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CREATED_DATE,
  BookingContractSupplierDetails.JSON_PROPERTY_LAST_UPDATE,
  BookingContractSupplierDetails.JSON_PROPERTY_IP_ADDRESS,
  BookingContractSupplierDetails.JSON_PROPERTY_TRACE_ID,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_URL,
  BookingContractSupplierDetails.JSON_PROPERTY_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_ITEM_LIST,
  BookingContractSupplierDetails.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContractSupplierDetails.JSON_PROPERTY_PAYMENT,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLED,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLED_ON,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLER,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCEL_REASON,
  BookingContractSupplierDetails.JSON_PROPERTY_FUNDS_PROCESSED,
  BookingContractSupplierDetails.JSON_PROPERTY_REFUNDS,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractSupplierDetails.JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER
})
@JsonTypeName("BookingContract_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-05T11:16:56.266186763+07:00[Asia/Bangkok]")
public class BookingContractSupplierDetails {
  public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
  private UUID bookingContractIdentifier;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  private QuoteSupplierDetails displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  private QuoteSupplierDetails supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  private QuoteSupplierDetails internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  private QuoteSupplierDetails capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  private List<BookingContractItemSupplierDetails> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  private BookingContractPaymentDetailsSupplierDetails payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled = false;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  private java.time.LocalDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL("SALES_CHANNEL"),
    
    SUPPLIER("SUPPLIER"),
    
    TRAVELER("TRAVELER"),
    
    ACQUIRER("ACQUIRER"),
    
    ADMINISTRATOR("ADMINISTRATOR");

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    CANCELLATION("CANCELLATION"),
    
    NO_SHOW("NO_SHOW"),
    
    CC_INVALID("CC_INVALID"),
    
    CC_INSUFFICIENT("CC_INSUFFICIENT"),
    
    DISCRETIONARY("DISCRETIONARY");

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  private String cancelReason;

  public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
  private Boolean fundsProcessed;

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  private List<RefundSupplierDetails> refunds = new ArrayList<>();

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private Double sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  private Double displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private Double supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private Double internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  private Double captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  private Double sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  private Double displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  private Double supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  private Double internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  private Double captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  private Double netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  private Double netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  private Double netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  private Double netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  private Double netCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
  private Boolean isCancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
  private MoneysSupplierDetails commissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
  private MoneysSupplierDetails commissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
  private MoneysSupplierDetails commissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
  private MoneysSupplierDetails commissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
  private MoneysSupplierDetails commissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public BookingContractSupplierDetails() {
  }

  public BookingContractSupplierDetails bookingContractIdentifier(UUID bookingContractIdentifier) {
    
    this.bookingContractIdentifier = bookingContractIdentifier;
    return this;
  }

   /**
   * Document UUID
   * @return bookingContractIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingContractIdentifier() {
    return bookingContractIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContractIdentifier(UUID bookingContractIdentifier) {
    this.bookingContractIdentifier = bookingContractIdentifier;
  }


  public BookingContractSupplierDetails createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public BookingContractSupplierDetails lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public BookingContractSupplierDetails ipAddress(String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * Caller&#39;s IP address
   * @return ipAddress
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public BookingContractSupplierDetails traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Way to track which booking contracts were made together
   * @return traceId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public BookingContractSupplierDetails sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public BookingContractSupplierDetails identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier used to track the contract. Create a UUID for this purpose.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public BookingContractSupplierDetails supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public BookingContractSupplierDetails supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Supplier name
   * @return supplierName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public BookingContractSupplierDetails displayPriceQuote(QuoteSupplierDetails displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

   /**
   * Get displayPriceQuote
   * @return displayPriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplierDetails getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(QuoteSupplierDetails displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }


  public BookingContractSupplierDetails supplierPriceQuote(QuoteSupplierDetails supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

   /**
   * Get supplierPriceQuote
   * @return supplierPriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplierDetails getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(QuoteSupplierDetails supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }


  public BookingContractSupplierDetails internalPriceQuote(QuoteSupplierDetails internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

   /**
   * Get internalPriceQuote
   * @return internalPriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplierDetails getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(QuoteSupplierDetails internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }


  public BookingContractSupplierDetails capturePriceQuote(QuoteSupplierDetails capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

   /**
   * Get capturePriceQuote
   * @return capturePriceQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplierDetails getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(QuoteSupplierDetails capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }


  public BookingContractSupplierDetails itemList(List<BookingContractItemSupplierDetails> itemList) {
    
    this.itemList = itemList;
    return this;
  }

  public BookingContractSupplierDetails addItemListItem(BookingContractItemSupplierDetails itemListItem) {
    this.itemList.add(itemListItem);
    return this;
  }

   /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BookingContractItemSupplierDetails> getItemList() {
    return itemList;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemList(List<BookingContractItemSupplierDetails> itemList) {
    this.itemList = itemList;
  }


  public BookingContractSupplierDetails externalSupplierIdentifier(String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

   /**
   * Contract creator can choose to geoname this record with her own identifier
   * @return externalSupplierIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }


  public BookingContractSupplierDetails externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public BookingContractSupplierDetails payment(BookingContractPaymentDetailsSupplierDetails payment) {
    
    this.payment = payment;
    return this;
  }

   /**
   * Get payment
   * @return payment
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractPaymentDetailsSupplierDetails getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayment(BookingContractPaymentDetailsSupplierDetails payment) {
    this.payment = payment;
  }


  public BookingContractSupplierDetails cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractSupplierDetails cancelledOn(java.time.LocalDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

   /**
   * When the booking was cancelled.
   * @return cancelledOn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(java.time.LocalDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }


  public BookingContractSupplierDetails canceller(CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

   /**
   * Type of entity that cancelled the booking.
   * @return canceller
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(CancellerEnum canceller) {
    this.canceller = canceller;
  }


  public BookingContractSupplierDetails cancellationType(CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

   /**
   * Reason type.
   * @return cancellationType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }


  public BookingContractSupplierDetails cancellerUserIdentifier(String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

   /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }


  public BookingContractSupplierDetails cancelReason(String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

   /**
   * Reason for cancellation.
   * @return cancelReason
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(String cancelReason) {
    this.cancelReason = cancelReason;
  }


  public BookingContractSupplierDetails fundsProcessed(Boolean fundsProcessed) {
    
    this.fundsProcessed = fundsProcessed;
    return this;
  }

   /**
   * Whether a funds transfer request has been created for this booking.
   * @return fundsProcessed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsProcessed() {
    return fundsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsProcessed(Boolean fundsProcessed) {
    this.fundsProcessed = fundsProcessed;
  }


  public BookingContractSupplierDetails refunds(List<RefundSupplierDetails> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public BookingContractSupplierDetails addRefundsItem(RefundSupplierDetails refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

   /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return refunds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RefundSupplierDetails> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(List<RefundSupplierDetails> refunds) {
    this.refunds = refunds;
  }


  public BookingContractSupplierDetails sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * The source currency
   * @return sourceCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public BookingContractSupplierDetails displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The display currency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public BookingContractSupplierDetails supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * The supplier currency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public BookingContractSupplierDetails internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * The internal currency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public BookingContractSupplierDetails captureCurrency(String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

   /**
   * The capture currency
   * @return captureCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureCurrency(String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }


  public BookingContractSupplierDetails sourceAmount(Double sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return sourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceAmount(Double sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public BookingContractSupplierDetails displayAmount(Double displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

   /**
   * The total display price.
   * minimum: 0
   * @return displayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayAmount(Double displayAmount) {
    this.displayAmount = displayAmount;
  }


  public BookingContractSupplierDetails supplierAmount(Double supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * minimum: 0
   * @return supplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(Double supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public BookingContractSupplierDetails internalAmount(Double internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * Get internalAmount
   * minimum: 0
   * @return internalAmount
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmount(Double internalAmount) {
    this.internalAmount = internalAmount;
  }


  public BookingContractSupplierDetails captureAmount(Double captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

   /**
   * The total capture price.
   * minimum: 0
   * @return captureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureAmount(Double captureAmount) {
    this.captureAmount = captureAmount;
  }


  public BookingContractSupplierDetails sourceAmountRefundModifier(Double sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

   /**
   * The source amount still due after a partial refund occurs.
   * minimum: 0
   * @return sourceAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(Double sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }


  public BookingContractSupplierDetails displayAmountRefundModifier(Double displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

   /**
   * The display amount still due after a partial refund occurs.
   * minimum: 0
   * @return displayAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(Double displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }


  public BookingContractSupplierDetails supplierAmountRefundModifier(Double supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

   /**
   * The supplier amount still due after a partial refund occurs.
   * minimum: 0
   * @return supplierAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(Double supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }


  public BookingContractSupplierDetails internalAmountRefundModifier(Double internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

   /**
   * The internal amount still due after a partial refund occurs.
   * minimum: 0
   * @return internalAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(Double internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }


  public BookingContractSupplierDetails captureAmountRefundModifier(Double captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

   /**
   * The capture amount still due after a partial refund occurs.
   * minimum: 0
   * @return captureAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(Double captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }


  public BookingContractSupplierDetails netSourceAmount(Double netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return netSourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSourceAmount(Double netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }


  public BookingContractSupplierDetails netDisplayAmount(Double netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

   /**
   * The total display price.
   * minimum: 0
   * @return netDisplayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetDisplayAmount(Double netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }


  public BookingContractSupplierDetails netSupplierAmount(Double netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * minimum: 0
   * @return netSupplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSupplierAmount(Double netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }


  public BookingContractSupplierDetails netInternalAmount(Double netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

   /**
   * Get netInternalAmount
   * minimum: 0
   * @return netInternalAmount
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetInternalAmount(Double netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }


  public BookingContractSupplierDetails netCaptureAmount(Double netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

   /**
   * The total capture price.
   * minimum: 0
   * @return netCaptureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetCaptureAmount(Double netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }


  public BookingContractSupplierDetails totalTokensEarned(Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

   /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }


  public BookingContractSupplierDetails cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractSupplierDetails isCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return isCancellableWithPotentialCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableWithPotentialCharges() {
    return isCancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
  }


  public BookingContractSupplierDetails commissionableTotalSourceAmount(MoneysSupplierDetails commissionableTotalSourceAmount) {
    
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    return this;
  }

   /**
   * Get commissionableTotalSourceAmount
   * @return commissionableTotalSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getCommissionableTotalSourceAmount() {
    return commissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSourceAmount(MoneysSupplierDetails commissionableTotalSourceAmount) {
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
  }


  public BookingContractSupplierDetails commissionableTotalCaptureAmount(MoneysSupplierDetails commissionableTotalCaptureAmount) {
    
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    return this;
  }

   /**
   * Get commissionableTotalCaptureAmount
   * @return commissionableTotalCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getCommissionableTotalCaptureAmount() {
    return commissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalCaptureAmount(MoneysSupplierDetails commissionableTotalCaptureAmount) {
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
  }


  public BookingContractSupplierDetails commissionableTotalDisplayAmount(MoneysSupplierDetails commissionableTotalDisplayAmount) {
    
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    return this;
  }

   /**
   * Get commissionableTotalDisplayAmount
   * @return commissionableTotalDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getCommissionableTotalDisplayAmount() {
    return commissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalDisplayAmount(MoneysSupplierDetails commissionableTotalDisplayAmount) {
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
  }


  public BookingContractSupplierDetails commissionableTotalSupplierAmount(MoneysSupplierDetails commissionableTotalSupplierAmount) {
    
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    return this;
  }

   /**
   * Get commissionableTotalSupplierAmount
   * @return commissionableTotalSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getCommissionableTotalSupplierAmount() {
    return commissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSupplierAmount(MoneysSupplierDetails commissionableTotalSupplierAmount) {
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
  }


  public BookingContractSupplierDetails commissionableTotalInternalAmount(MoneysSupplierDetails commissionableTotalInternalAmount) {
    
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    return this;
  }

   /**
   * Get commissionableTotalInternalAmount
   * @return commissionableTotalInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MoneysSupplierDetails getCommissionableTotalInternalAmount() {
    return commissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalInternalAmount(MoneysSupplierDetails commissionableTotalInternalAmount) {
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
  }


  public BookingContractSupplierDetails cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractSupplierDetails cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractSupplierDetails bookingContractSupplierDetails = (BookingContractSupplierDetails) o;
    return Objects.equals(this.bookingContractIdentifier, bookingContractSupplierDetails.bookingContractIdentifier) &&
        Objects.equals(this.createdDate, bookingContractSupplierDetails.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContractSupplierDetails.lastUpdate) &&
        Objects.equals(this.ipAddress, bookingContractSupplierDetails.ipAddress) &&
        Objects.equals(this.traceId, bookingContractSupplierDetails.traceId) &&
        Objects.equals(this.sourceUrl, bookingContractSupplierDetails.sourceUrl) &&
        Objects.equals(this.identifier, bookingContractSupplierDetails.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContractSupplierDetails.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContractSupplierDetails.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContractSupplierDetails.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContractSupplierDetails.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContractSupplierDetails.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContractSupplierDetails.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContractSupplierDetails.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContractSupplierDetails.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContractSupplierDetails.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContractSupplierDetails.payment) &&
        Objects.equals(this.cancelled, bookingContractSupplierDetails.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContractSupplierDetails.cancelledOn) &&
        Objects.equals(this.canceller, bookingContractSupplierDetails.canceller) &&
        Objects.equals(this.cancellationType, bookingContractSupplierDetails.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContractSupplierDetails.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContractSupplierDetails.cancelReason) &&
        Objects.equals(this.fundsProcessed, bookingContractSupplierDetails.fundsProcessed) &&
        Objects.equals(this.refunds, bookingContractSupplierDetails.refunds) &&
        Objects.equals(this.sourceCurrency, bookingContractSupplierDetails.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractSupplierDetails.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractSupplierDetails.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractSupplierDetails.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractSupplierDetails.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractSupplierDetails.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractSupplierDetails.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractSupplierDetails.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractSupplierDetails.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractSupplierDetails.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractSupplierDetails.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractSupplierDetails.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractSupplierDetails.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractSupplierDetails.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractSupplierDetails.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractSupplierDetails.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractSupplierDetails.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractSupplierDetails.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractSupplierDetails.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractSupplierDetails.netCaptureAmount) &&
        Objects.equals(this.totalTokensEarned, bookingContractSupplierDetails.totalTokensEarned) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractSupplierDetails.cancellableWithNoCharges) &&
        Objects.equals(this.isCancellableWithPotentialCharges, bookingContractSupplierDetails.isCancellableWithPotentialCharges) &&
        Objects.equals(this.commissionableTotalSourceAmount, bookingContractSupplierDetails.commissionableTotalSourceAmount) &&
        Objects.equals(this.commissionableTotalCaptureAmount, bookingContractSupplierDetails.commissionableTotalCaptureAmount) &&
        Objects.equals(this.commissionableTotalDisplayAmount, bookingContractSupplierDetails.commissionableTotalDisplayAmount) &&
        Objects.equals(this.commissionableTotalSupplierAmount, bookingContractSupplierDetails.commissionableTotalSupplierAmount) &&
        Objects.equals(this.commissionableTotalInternalAmount, bookingContractSupplierDetails.commissionableTotalInternalAmount) &&
        Objects.equals(this.cancellableBySupplier, bookingContractSupplierDetails.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingContractSupplierDetails.cancellableByTraveler);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingContractIdentifier, createdDate, lastUpdate, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, fundsProcessed, refunds, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, totalTokensEarned, cancellableWithNoCharges, isCancellableWithPotentialCharges, commissionableTotalSourceAmount, commissionableTotalCaptureAmount, commissionableTotalDisplayAmount, commissionableTotalSupplierAmount, commissionableTotalInternalAmount, cancellableBySupplier, cancellableByTraveler);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractSupplierDetails {\n");
    sb.append("    bookingContractIdentifier: ").append(toIndentedString(bookingContractIdentifier)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    fundsProcessed: ").append(toIndentedString(fundsProcessed)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    isCancellableWithPotentialCharges: ").append(toIndentedString(isCancellableWithPotentialCharges)).append("\n");
    sb.append("    commissionableTotalSourceAmount: ").append(toIndentedString(commissionableTotalSourceAmount)).append("\n");
    sb.append("    commissionableTotalCaptureAmount: ").append(toIndentedString(commissionableTotalCaptureAmount)).append("\n");
    sb.append("    commissionableTotalDisplayAmount: ").append(toIndentedString(commissionableTotalDisplayAmount)).append("\n");
    sb.append("    commissionableTotalSupplierAmount: ").append(toIndentedString(commissionableTotalSupplierAmount)).append("\n");
    sb.append("    commissionableTotalInternalAmount: ").append(toIndentedString(commissionableTotalInternalAmount)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

