/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.3.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CompanyBookingSalesMetricsSupplier
 */
@JsonPropertyOrder({
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_OWNER_IDENTIFIER,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_SUB_TYPE,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_OWNER_NAME,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_CONTINENT,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_COUNTRY,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_COUNTRY_GEO_NAME_ID,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_CITY,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_CITY_GEO_NAME_ID,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_BOOKINGS,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_TOTAL_PRICE_AMOUNT,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT,
  CompanyBookingSalesMetricsSupplier.JSON_PROPERTY_CURRENCY_CODE
})
@JsonTypeName("CompanyBookingSalesMetrics_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-05T11:16:56.266186763+07:00[Asia/Bangkok]")
public class CompanyBookingSalesMetricsSupplier {
  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private String ownerIdentifier;

  /**
   * Gets or Sets subType
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  private String continent;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_COUNTRY_GEO_NAME_ID = "countryGeoNameId";
  private String countryGeoNameId;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_CITY_GEO_NAME_ID = "cityGeoNameId";
  private String cityGeoNameId;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings;

  public static final String JSON_PROPERTY_TOTAL_PRICE_AMOUNT = "totalPriceAmount";
  private Double totalPriceAmount;

  public static final String JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT = "averageBookingAmount";
  private Double averageBookingAmount;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public CompanyBookingSalesMetricsSupplier() {
  }

  public CompanyBookingSalesMetricsSupplier ownerIdentifier(String ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Get ownerIdentifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(String ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public CompanyBookingSalesMetricsSupplier subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * Get subType
   * @return subType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public CompanyBookingSalesMetricsSupplier ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Get ownerName
   * @return ownerName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public CompanyBookingSalesMetricsSupplier continent(String continent) {
    
    this.continent = continent;
    return this;
  }

   /**
   * Get continent
   * @return continent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(String continent) {
    this.continent = continent;
  }


  public CompanyBookingSalesMetricsSupplier country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public CompanyBookingSalesMetricsSupplier countryGeoNameId(String countryGeoNameId) {
    
    this.countryGeoNameId = countryGeoNameId;
    return this;
  }

   /**
   * Get countryGeoNameId
   * @return countryGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryGeoNameId() {
    return countryGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryGeoNameId(String countryGeoNameId) {
    this.countryGeoNameId = countryGeoNameId;
  }


  public CompanyBookingSalesMetricsSupplier city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public CompanyBookingSalesMetricsSupplier cityGeoNameId(String cityGeoNameId) {
    
    this.cityGeoNameId = cityGeoNameId;
    return this;
  }

   /**
   * Get cityGeoNameId
   * @return cityGeoNameId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityGeoNameId() {
    return cityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityGeoNameId(String cityGeoNameId) {
    this.cityGeoNameId = cityGeoNameId;
  }


  public CompanyBookingSalesMetricsSupplier bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Get bookings
   * @return bookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public CompanyBookingSalesMetricsSupplier totalPriceAmount(Double totalPriceAmount) {
    
    this.totalPriceAmount = totalPriceAmount;
    return this;
  }

   /**
   * Get totalPriceAmount
   * @return totalPriceAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getTotalPriceAmount() {
    return totalPriceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalPriceAmount(Double totalPriceAmount) {
    this.totalPriceAmount = totalPriceAmount;
  }


  public CompanyBookingSalesMetricsSupplier averageBookingAmount(Double averageBookingAmount) {
    
    this.averageBookingAmount = averageBookingAmount;
    return this;
  }

   /**
   * Get averageBookingAmount
   * @return averageBookingAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getAverageBookingAmount() {
    return averageBookingAmount;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_BOOKING_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageBookingAmount(Double averageBookingAmount) {
    this.averageBookingAmount = averageBookingAmount;
  }


  public CompanyBookingSalesMetricsSupplier currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyBookingSalesMetricsSupplier companyBookingSalesMetricsSupplier = (CompanyBookingSalesMetricsSupplier) o;
    return Objects.equals(this.ownerIdentifier, companyBookingSalesMetricsSupplier.ownerIdentifier) &&
        Objects.equals(this.subType, companyBookingSalesMetricsSupplier.subType) &&
        Objects.equals(this.ownerName, companyBookingSalesMetricsSupplier.ownerName) &&
        Objects.equals(this.continent, companyBookingSalesMetricsSupplier.continent) &&
        Objects.equals(this.country, companyBookingSalesMetricsSupplier.country) &&
        Objects.equals(this.countryGeoNameId, companyBookingSalesMetricsSupplier.countryGeoNameId) &&
        Objects.equals(this.city, companyBookingSalesMetricsSupplier.city) &&
        Objects.equals(this.cityGeoNameId, companyBookingSalesMetricsSupplier.cityGeoNameId) &&
        Objects.equals(this.bookings, companyBookingSalesMetricsSupplier.bookings) &&
        Objects.equals(this.totalPriceAmount, companyBookingSalesMetricsSupplier.totalPriceAmount) &&
        Objects.equals(this.averageBookingAmount, companyBookingSalesMetricsSupplier.averageBookingAmount) &&
        Objects.equals(this.currencyCode, companyBookingSalesMetricsSupplier.currencyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ownerIdentifier, subType, ownerName, continent, country, countryGeoNameId, city, cityGeoNameId, bookings, totalPriceAmount, averageBookingAmount, currencyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyBookingSalesMetricsSupplier {\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    countryGeoNameId: ").append(toIndentedString(countryGeoNameId)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    cityGeoNameId: ").append(toIndentedString(cityGeoNameId)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    totalPriceAmount: ").append(toIndentedString(totalPriceAmount)).append("\n");
    sb.append("    averageBookingAmount: ").append(toIndentedString(averageBookingAmount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

