/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.3.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import travel.wink.sdk.extranet.model.MoneysSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Refund objects allow you to refund a charge that has previously been created but not yet refunded. Funds will be refunded to the credit or debit card that was originally charged.
 */
@JsonPropertyOrder({
  RefundSupplierDetails.JSON_PROPERTY_IDENTIFIER,
  RefundSupplierDetails.JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER,
  RefundSupplierDetails.JSON_PROPERTY_REQUESTED_BY_IDENTIFIER,
  RefundSupplierDetails.JSON_PROPERTY_REFUND,
  RefundSupplierDetails.JSON_PROPERTY_CREATED,
  RefundSupplierDetails.JSON_PROPERTY_DESCRIPTION,
  RefundSupplierDetails.JSON_PROPERTY_REASON_TYPE,
  RefundSupplierDetails.JSON_PROPERTY_STATUS_TYPE,
  RefundSupplierDetails.JSON_PROPERTY_REQUEST_TYPE,
  RefundSupplierDetails.JSON_PROPERTY_REQUEST_STATUS,
  RefundSupplierDetails.JSON_PROPERTY_REQUEST_RESPONSE,
  RefundSupplierDetails.JSON_PROPERTY_RECEIPT_URL,
  RefundSupplierDetails.JSON_PROPERTY_RETRIES
})
@JsonTypeName("Refund_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-05T11:16:56.266186763+07:00[Asia/Bangkok]")
public class RefundSupplierDetails {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER = "acquirerRefundIdentifier";
  private String acquirerRefundIdentifier;

  public static final String JSON_PROPERTY_REQUESTED_BY_IDENTIFIER = "requestedByIdentifier";
  private String requestedByIdentifier;

  public static final String JSON_PROPERTY_REFUND = "refund";
  private MoneysSupplierDetails refund;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * A description of the refund that can be displayed to booker
   */
  public enum ReasonTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    FRAUDULENT("FRAUDULENT"),
    
    REQUESTED_BY_CUSTOMER("REQUESTED_BY_CUSTOMER"),
    
    GUEST_COMPLAINT("GUEST_COMPLAINT"),
    
    GUEST_BOOKED_INCORRECT_DATE("GUEST_BOOKED_INCORRECT_DATE"),
    
    GUEST_SICK("GUEST_SICK"),
    
    OVERBOOKING("OVERBOOKING"),
    
    EMERGENCY("EMERGENCY"),
    
    FLIGHT_CANCELLED("FLIGHT_CANCELLED"),
    
    DEATH_IN_FAMILY("DEATH_IN_FAMILY"),
    
    OTHER("OTHER"),
    
    EXPIRED_UNCAPTURED_CHARGE("EXPIRED_UNCAPTURED_CHARGE");

    private String value;

    ReasonTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReasonTypeEnum fromValue(String value) {
      for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
  private ReasonTypeEnum reasonType;

  /**
   * Status of the refund
   */
  public enum StatusTypeEnum {
    PENDING("PENDING"),
    
    SUCCEEDED("SUCCEEDED"),
    
    CANCELED("CANCELED"),
    
    REQUIRES_ACTION("REQUIRES_ACTION"),
    
    FAILED("FAILED");

    private String value;

    StatusTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusTypeEnum fromValue(String value) {
      for (StatusTypeEnum b : StatusTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS_TYPE = "statusType";
  private StatusTypeEnum statusType;

  /**
   * The entity making the refund request
   */
  public enum RequestTypeEnum {
    SUPPLIER("BY_SUPPLIER"),
    
    ADMIN("BY_ADMIN"),
    
    STRIPE("BY_STRIPE"),
    
    SYSTEM("BY_SYSTEM");

    private String value;

    RequestTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestTypeEnum fromValue(String value) {
      for (RequestTypeEnum b : RequestTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
  private RequestTypeEnum requestType;

  /**
   * Status of the refund request
   */
  public enum RequestStatusEnum {
    PENDING("PENDING"),
    
    APPROVED("APPROVED"),
    
    REJECTED("REJECTED");

    private String value;

    RequestStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestStatusEnum fromValue(String value) {
      for (RequestStatusEnum b : RequestStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_STATUS = "requestStatus";
  private RequestStatusEnum requestStatus;

  public static final String JSON_PROPERTY_REQUEST_RESPONSE = "requestResponse";
  private String requestResponse;

  public static final String JSON_PROPERTY_RECEIPT_URL = "receiptUrl";
  private String receiptUrl;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private Integer retries = 0;

  public RefundSupplierDetails() {
  }

  public RefundSupplierDetails identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * A unique identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public RefundSupplierDetails acquirerRefundIdentifier(String acquirerRefundIdentifier) {
    
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
    return this;
  }

   /**
   * The acquirer refund identifier. Will get attached once it comes in on the webhook.
   * @return acquirerRefundIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAcquirerRefundIdentifier() {
    return acquirerRefundIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerRefundIdentifier(String acquirerRefundIdentifier) {
    this.acquirerRefundIdentifier = acquirerRefundIdentifier;
  }


  public RefundSupplierDetails requestedByIdentifier(String requestedByIdentifier) {
    
    this.requestedByIdentifier = requestedByIdentifier;
    return this;
  }

   /**
   * The SSO person / entity that requested the refund.
   * @return requestedByIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REQUESTED_BY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRequestedByIdentifier() {
    return requestedByIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUESTED_BY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestedByIdentifier(String requestedByIdentifier) {
    this.requestedByIdentifier = requestedByIdentifier;
  }


  public RefundSupplierDetails refund(MoneysSupplierDetails refund) {
    
    this.refund = refund;
    return this;
  }

   /**
   * Get refund
   * @return refund
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MoneysSupplierDetails getRefund() {
    return refund;
  }


  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefund(MoneysSupplierDetails refund) {
    this.refund = refund;
  }


  public RefundSupplierDetails created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * When the amount was refunded
   * @return created
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public RefundSupplierDetails description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public RefundSupplierDetails reasonType(ReasonTypeEnum reasonType) {
    
    this.reasonType = reasonType;
    return this;
  }

   /**
   * A description of the refund that can be displayed to booker
   * @return reasonType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ReasonTypeEnum getReasonType() {
    return reasonType;
  }


  @JsonProperty(JSON_PROPERTY_REASON_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReasonType(ReasonTypeEnum reasonType) {
    this.reasonType = reasonType;
  }


  public RefundSupplierDetails statusType(StatusTypeEnum statusType) {
    
    this.statusType = statusType;
    return this;
  }

   /**
   * Status of the refund
   * @return statusType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusTypeEnum getStatusType() {
    return statusType;
  }


  @JsonProperty(JSON_PROPERTY_STATUS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatusType(StatusTypeEnum statusType) {
    this.statusType = statusType;
  }


  public RefundSupplierDetails requestType(RequestTypeEnum requestType) {
    
    this.requestType = requestType;
    return this;
  }

   /**
   * The entity making the refund request
   * @return requestType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestTypeEnum getRequestType() {
    return requestType;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestType(RequestTypeEnum requestType) {
    this.requestType = requestType;
  }


  public RefundSupplierDetails requestStatus(RequestStatusEnum requestStatus) {
    
    this.requestStatus = requestStatus;
    return this;
  }

   /**
   * Status of the refund request
   * @return requestStatus
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestStatusEnum getRequestStatus() {
    return requestStatus;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestStatus(RequestStatusEnum requestStatus) {
    this.requestStatus = requestStatus;
  }


  public RefundSupplierDetails requestResponse(String requestResponse) {
    
    this.requestResponse = requestResponse;
    return this;
  }

   /**
   * Admin may choose to respond to the refund request made by the hotel
   * @return requestResponse
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRequestResponse() {
    return requestResponse;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestResponse(String requestResponse) {
    this.requestResponse = requestResponse;
  }


  public RefundSupplierDetails receiptUrl(String receiptUrl) {
    
    this.receiptUrl = receiptUrl;
    return this;
  }

   /**
   * This is the receipt url that contains a friendly web confirmation page. Comes in on the webhook.
   * @return receiptUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReceiptUrl() {
    return receiptUrl;
  }


  @JsonProperty(JSON_PROPERTY_RECEIPT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceiptUrl(String receiptUrl) {
    this.receiptUrl = receiptUrl;
  }


  public RefundSupplierDetails retries(Integer retries) {
    
    this.retries = retries;
    return this;
  }

   /**
   * In case a TripPay admin has to go in and re-send the refund request to Stripe, we want to not to the same calculations again when a retry is executed so we keep track of retries here.
   * @return retries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRetries() {
    return retries;
  }


  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(Integer retries) {
    this.retries = retries;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundSupplierDetails refundSupplierDetails = (RefundSupplierDetails) o;
    return Objects.equals(this.identifier, refundSupplierDetails.identifier) &&
        Objects.equals(this.acquirerRefundIdentifier, refundSupplierDetails.acquirerRefundIdentifier) &&
        Objects.equals(this.requestedByIdentifier, refundSupplierDetails.requestedByIdentifier) &&
        Objects.equals(this.refund, refundSupplierDetails.refund) &&
        Objects.equals(this.created, refundSupplierDetails.created) &&
        Objects.equals(this.description, refundSupplierDetails.description) &&
        Objects.equals(this.reasonType, refundSupplierDetails.reasonType) &&
        Objects.equals(this.statusType, refundSupplierDetails.statusType) &&
        Objects.equals(this.requestType, refundSupplierDetails.requestType) &&
        Objects.equals(this.requestStatus, refundSupplierDetails.requestStatus) &&
        Objects.equals(this.requestResponse, refundSupplierDetails.requestResponse) &&
        Objects.equals(this.receiptUrl, refundSupplierDetails.receiptUrl) &&
        Objects.equals(this.retries, refundSupplierDetails.retries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, acquirerRefundIdentifier, requestedByIdentifier, refund, created, description, reasonType, statusType, requestType, requestStatus, requestResponse, receiptUrl, retries);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundSupplierDetails {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    acquirerRefundIdentifier: ").append(toIndentedString(acquirerRefundIdentifier)).append("\n");
    sb.append("    requestedByIdentifier: ").append(toIndentedString(requestedByIdentifier)).append("\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    reasonType: ").append(toIndentedString(reasonType)).append("\n");
    sb.append("    statusType: ").append(toIndentedString(statusType)).append("\n");
    sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
    sb.append("    requestStatus: ").append(toIndentedString(requestStatus)).append("\n");
    sb.append("    requestResponse: ").append(toIndentedString(requestResponse)).append("\n");
    sb.append("    receiptUrl: ").append(toIndentedString(receiptUrl)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

