package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.AnnouncementSupplier;
import travel.wink.sdk.extranet.model.AnnouncementViewSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-12T18:09:34.535756714+07:00[Asia/Bangkok]")
public class AnnouncementApi {
    private ApiClient apiClient;

    public AnnouncementApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnnouncementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create announcement for this hotel identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAnnouncementRequestCreation(String hotelIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = announcementSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementSupplier' is set
        if (announcementSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementSupplier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create announcement for this hotel identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementViewSupplier> createAnnouncement(String hotelIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return createAnnouncementRequestCreation(hotelIdentifier, announcementSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create announcement for this hotel identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AnnouncementViewSupplier>> createAnnouncementWithHttpInfo(String hotelIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return createAnnouncementRequestCreation(hotelIdentifier, announcementSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create announcement for this hotel identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAnnouncementWithResponseSpec(String hotelIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        return createAnnouncementRequestCreation(hotelIdentifier, announcementSupplier, winkVersion);
    }
    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove announcement for this hotel identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove announcement for this hotel identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove announcement for this hotel identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove announcement for this hotel identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAnnouncementWithResponseSpec(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        return removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion);
    }
    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcement for this hotel identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcement for this hotel identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementViewSupplier> showAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcement for this hotel identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AnnouncementViewSupplier>> showAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcement for this hotel identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnnouncementWithResponseSpec(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        return showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion);
    }
    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcements for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnnouncementsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncements", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcements for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AnnouncementViewSupplier> showAnnouncements(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcements for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;AnnouncementViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<AnnouncementViewSupplier>>> showAnnouncementsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show announcements for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnnouncementsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showAnnouncementsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update announcement for this hotel identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = announcementSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementSupplier' is set
        if (announcementSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementSupplier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update announcement for this hotel identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementViewSupplier> updateAnnouncement(String hotelIdentifier, String announcementIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, announcementSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update announcement for this hotel identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AnnouncementViewSupplier>> updateAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, announcementSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update announcement for this hotel identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param announcementSupplier The announcementSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAnnouncementWithResponseSpec(String hotelIdentifier, String announcementIdentifier, AnnouncementSupplier announcementSupplier, String winkVersion) throws WebClientResponseException {
        return updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, announcementSupplier, winkVersion);
    }
}
