/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.4.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AddressSupplierDetails;
import travel.wink.sdk.extranet.model.ContactSupplierDetails;
import travel.wink.sdk.extranet.model.LocalizedPriceSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Add-on records.
 */
@JsonPropertyOrder({
  BookingAncillarySupplierDetails.JSON_PROPERTY_HOTEL_IDENTIFIER,
  BookingAncillarySupplierDetails.JSON_PROPERTY_TYPE_IDENTIFIER,
  BookingAncillarySupplierDetails.JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER,
  BookingAncillarySupplierDetails.JSON_PROPERTY_NAME,
  BookingAncillarySupplierDetails.JSON_PROPERTY_PRICING_TYPE,
  BookingAncillarySupplierDetails.JSON_PROPERTY_TYPE,
  BookingAncillarySupplierDetails.JSON_PROPERTY_PRICE,
  BookingAncillarySupplierDetails.JSON_PROPERTY_START_DATE,
  BookingAncillarySupplierDetails.JSON_PROPERTY_END_DATE,
  BookingAncillarySupplierDetails.JSON_PROPERTY_ATTENDEES,
  BookingAncillarySupplierDetails.JSON_PROPERTY_IMAGE_IDENTIFIER,
  BookingAncillarySupplierDetails.JSON_PROPERTY_IMAGE_URL,
  BookingAncillarySupplierDetails.JSON_PROPERTY_LOCALIZED_NAME,
  BookingAncillarySupplierDetails.JSON_PROPERTY_LOCALIZED_DESCRIPTION,
  BookingAncillarySupplierDetails.JSON_PROPERTY_CONTACT,
  BookingAncillarySupplierDetails.JSON_PROPERTY_ADDRESS,
  BookingAncillarySupplierDetails.JSON_PROPERTY_COMMISSIONABLE,
  BookingAncillarySupplierDetails.JSON_PROPERTY_COMMISSION
})
@JsonTypeName("BookingAncillary_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-05-12T18:09:34.535756714+07:00[Asia/Bangkok]")
public class BookingAncillarySupplierDetails {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private UUID typeIdentifier;

  public static final String JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER = "transactionalTravelInventoryIdentifier";
  private UUID transactionalTravelInventoryIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Pricing type
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  /**
   * Inventory type
   */
  public enum TypeEnum {
    ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    SPA("SPA"),
    
    RESTAURANT("RESTAURANT"),
    
    ACTIVITY("ACTIVITY"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPriceSupplierDetails price;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private java.time.LocalDateTime startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private java.time.LocalDateTime endDate;

  public static final String JSON_PROPERTY_ATTENDEES = "attendees";
  private Integer attendees = 1;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_IMAGE_URL = "imageUrl";
  private String imageUrl;

  public static final String JSON_PROPERTY_LOCALIZED_NAME = "localizedName";
  private String localizedName;

  public static final String JSON_PROPERTY_LOCALIZED_DESCRIPTION = "localizedDescription";
  private String localizedDescription;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactSupplierDetails contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplierDetails address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public BookingAncillarySupplierDetails() {
  }

  public BookingAncillarySupplierDetails hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public BookingAncillarySupplierDetails typeIdentifier(UUID typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Travel inventory identifier
   * @return typeIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTypeIdentifier(UUID typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public BookingAncillarySupplierDetails transactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
    
    this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
    return this;
  }

   /**
   * Travel inventory identifier
   * @return transactionalTravelInventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getTransactionalTravelInventoryIdentifier() {
    return transactionalTravelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTransactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
    this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
  }


  public BookingAncillarySupplierDetails name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of inventory
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public BookingAncillarySupplierDetails pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * Pricing type
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public BookingAncillarySupplierDetails type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Inventory type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingAncillarySupplierDetails price(LocalizedPriceSupplierDetails price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalizedPriceSupplierDetails getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(LocalizedPriceSupplierDetails price) {
    this.price = price;
  }


  public BookingAncillarySupplierDetails startDate(java.time.LocalDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Date start time when reservation was made for.
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(java.time.LocalDateTime startDate) {
    this.startDate = startDate;
  }


  public BookingAncillarySupplierDetails endDate(java.time.LocalDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Date end time when reservation was made for.
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(java.time.LocalDateTime endDate) {
    this.endDate = endDate;
  }


  public BookingAncillarySupplierDetails attendees(Integer attendees) {
    
    this.attendees = attendees;
    return this;
  }

   /**
   * Number of guests that are part of this reservation.
   * @return attendees
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAttendees() {
    return attendees;
  }


  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAttendees(Integer attendees) {
    this.attendees = attendees;
  }


  public BookingAncillarySupplierDetails imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Cloudinary image identifier
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public BookingAncillarySupplierDetails imageUrl(String imageUrl) {
    
    this.imageUrl = imageUrl;
    return this;
  }

   /**
   * Absolute URL to image of inventory
   * @return imageUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getImageUrl() {
    return imageUrl;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }


  public BookingAncillarySupplierDetails localizedName(String localizedName) {
    
    this.localizedName = localizedName;
    return this;
  }

   /**
   * Name of travel inventory in traveler language (if available). Defaults to English.
   * @return localizedName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOCALIZED_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocalizedName() {
    return localizedName;
  }


  @JsonProperty(JSON_PROPERTY_LOCALIZED_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocalizedName(String localizedName) {
    this.localizedName = localizedName;
  }


  public BookingAncillarySupplierDetails localizedDescription(String localizedDescription) {
    
    this.localizedDescription = localizedDescription;
    return this;
  }

   /**
   * Description of travel inventory in traveler language (if available). Defaults to English.
   * @return localizedDescription
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOCALIZED_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocalizedDescription() {
    return localizedDescription;
  }


  @JsonProperty(JSON_PROPERTY_LOCALIZED_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocalizedDescription(String localizedDescription) {
    this.localizedDescription = localizedDescription;
  }


  public BookingAncillarySupplierDetails contact(ContactSupplierDetails contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactSupplierDetails getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactSupplierDetails contact) {
    this.contact = contact;
  }


  public BookingAncillarySupplierDetails address(AddressSupplierDetails address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressSupplierDetails getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressSupplierDetails address) {
    this.address = address;
  }


  public BookingAncillarySupplierDetails commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Get commissionable
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public BookingAncillarySupplierDetails commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Get commission
   * @return commission
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingAncillarySupplierDetails bookingAncillarySupplierDetails = (BookingAncillarySupplierDetails) o;
    return Objects.equals(this.hotelIdentifier, bookingAncillarySupplierDetails.hotelIdentifier) &&
        Objects.equals(this.typeIdentifier, bookingAncillarySupplierDetails.typeIdentifier) &&
        Objects.equals(this.transactionalTravelInventoryIdentifier, bookingAncillarySupplierDetails.transactionalTravelInventoryIdentifier) &&
        Objects.equals(this.name, bookingAncillarySupplierDetails.name) &&
        Objects.equals(this.pricingType, bookingAncillarySupplierDetails.pricingType) &&
        Objects.equals(this.type, bookingAncillarySupplierDetails.type) &&
        Objects.equals(this.price, bookingAncillarySupplierDetails.price) &&
        Objects.equals(this.startDate, bookingAncillarySupplierDetails.startDate) &&
        Objects.equals(this.endDate, bookingAncillarySupplierDetails.endDate) &&
        Objects.equals(this.attendees, bookingAncillarySupplierDetails.attendees) &&
        Objects.equals(this.imageIdentifier, bookingAncillarySupplierDetails.imageIdentifier) &&
        Objects.equals(this.imageUrl, bookingAncillarySupplierDetails.imageUrl) &&
        Objects.equals(this.localizedName, bookingAncillarySupplierDetails.localizedName) &&
        Objects.equals(this.localizedDescription, bookingAncillarySupplierDetails.localizedDescription) &&
        Objects.equals(this.contact, bookingAncillarySupplierDetails.contact) &&
        Objects.equals(this.address, bookingAncillarySupplierDetails.address) &&
        Objects.equals(this.commissionable, bookingAncillarySupplierDetails.commissionable) &&
        Objects.equals(this.commission, bookingAncillarySupplierDetails.commission);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, typeIdentifier, transactionalTravelInventoryIdentifier, name, pricingType, type, price, startDate, endDate, attendees, imageIdentifier, imageUrl, localizedName, localizedDescription, contact, address, commissionable, commission);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingAncillarySupplierDetails {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    transactionalTravelInventoryIdentifier: ").append(toIndentedString(transactionalTravelInventoryIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    attendees: ").append(toIndentedString(attendees)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    imageUrl: ").append(toIndentedString(imageUrl)).append("\n");
    sb.append("    localizedName: ").append(toIndentedString(localizedName)).append("\n");
    sb.append("    localizedDescription: ").append(toIndentedString(localizedDescription)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

