/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.RecreationView;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.UpsertActivityRequest;

public class ActivityApi {
    private ApiClient apiClient;

    public ActivityApi() {
        this(new ApiClient());
    }

    @Autowired
    public ActivityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createActivityRequestCreation(String hotelIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        UpsertActivityRequest postBody = upsertActivityRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityRequest' when calling createActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RecreationView> createActivity(String hotelIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.createActivityRequestCreation(hotelIdentifier, upsertActivityRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> createActivityWithHttpInfo(String hotelIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.createActivityRequestCreation(hotelIdentifier, upsertActivityRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createActivityWithResponseSpec(String hotelIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        return this.createActivityRequestCreation(hotelIdentifier, upsertActivityRequest, winkVersion);
    }

    private WebClient.ResponseSpec removeActivityRequestCreation(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling removeActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeActivity(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeActivityRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeActivityWithHttpInfo(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(){};
        return this.removeActivityRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeActivityWithResponseSpec(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeActivityRequestCreation(hotelIdentifier, activityIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showActivitiesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RecreationView> showActivities(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.showActivitiesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RecreationView>>> showActivitiesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.showActivitiesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivitiesWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showActivitiesRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showActivityRequestCreation(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling showActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RecreationView> showActivity(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.showActivityRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> showActivityWithHttpInfo(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.showActivityRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivityWithResponseSpec(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showActivityRequestCreation(hotelIdentifier, activityIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showActivityPairsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivityPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showActivityPairs(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showActivityPairsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showActivityPairsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(){};
        return this.showActivityPairsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivityPairsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showActivityPairsRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateActivityRequestCreation(String hotelIdentifier, String activityIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        UpsertActivityRequest postBody = upsertActivityRequest;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityRequest' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RecreationView> updateActivity(String hotelIdentifier, String activityIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.updateActivityRequestCreation(hotelIdentifier, activityIdentifier, upsertActivityRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> updateActivityWithHttpInfo(String hotelIdentifier, String activityIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.updateActivityRequestCreation(hotelIdentifier, activityIdentifier, upsertActivityRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateActivityWithResponseSpec(String hotelIdentifier, String activityIdentifier, UpsertActivityRequest upsertActivityRequest, String winkVersion) throws WebClientResponseException {
        return this.updateActivityRequestCreation(hotelIdentifier, activityIdentifier, upsertActivityRequest, winkVersion);
    }

    private WebClient.ResponseSpec uploadActivityMediaRequestCreation(String hotelIdentifier, String activityIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/activity/{activityIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RecreationView> uploadActivityMedia(String hotelIdentifier, String activityIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.uploadActivityMediaRequestCreation(hotelIdentifier, activityIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RecreationView>> uploadActivityMediaWithHttpInfo(String hotelIdentifier, String activityIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RecreationView> localVarReturnType = new ParameterizedTypeReference<RecreationView>(){};
        return this.uploadActivityMediaRequestCreation(hotelIdentifier, activityIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadActivityMediaWithResponseSpec(String hotelIdentifier, String activityIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadActivityMediaRequestCreation(hotelIdentifier, activityIdentifier, files);
    }
}

