/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 25.6.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AddressSupplier;
import travel.wink.sdk.extranet.model.AggregateGreendexAnswersSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.LocalizedDescriptionSupplier;
import travel.wink.sdk.extranet.model.PropertyPolicySupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.model.SocialSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Hotel data
 */
@JsonPropertyOrder({
  HotelSupplier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelSupplier.JSON_PROPERTY_NAME,
  HotelSupplier.JSON_PROPERTY_HOTEL_CODE,
  HotelSupplier.JSON_PROPERTY_HOTEL_CODE_CONTEXT,
  HotelSupplier.JSON_PROPERTY_LOCAL_NAME,
  HotelSupplier.JSON_PROPERTY_LEGAL_NAME,
  HotelSupplier.JSON_PROPERTY_URL_NAME,
  HotelSupplier.JSON_PROPERTY_CURRENCY_CODE,
  HotelSupplier.JSON_PROPERTY_STATUS,
  HotelSupplier.JSON_PROPERTY_EXTERNAL_STATUS,
  HotelSupplier.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  HotelSupplier.JSON_PROPERTY_IMAGE_IDENTIFIER,
  HotelSupplier.JSON_PROPERTY_IMAGE_ANGLE,
  HotelSupplier.JSON_PROPERTY_REMOTE_IP,
  HotelSupplier.JSON_PROPERTY_LOCATION_CATEGORY,
  HotelSupplier.JSON_PROPERTY_SEGMENT_CATEGORY,
  HotelSupplier.JSON_PROPERTY_HOTEL_CATEGORY,
  HotelSupplier.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  HotelSupplier.JSON_PROPERTY_WHEN_BUILT,
  HotelSupplier.JSON_PROPERTY_HOTEL_CHAIN,
  HotelSupplier.JSON_PROPERTY_HOTEL_BRAND,
  HotelSupplier.JSON_PROPERTY_CHANNEL_MANAGER_IDENTIFIER,
  HotelSupplier.JSON_PROPERTY_CHANNEL_MANAGER,
  HotelSupplier.JSON_PROPERTY_OTHER_CHANNEL_MANAGER,
  HotelSupplier.JSON_PROPERTY_LICENSE_NUMBER,
  HotelSupplier.JSON_PROPERTY_STARS,
  HotelSupplier.JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER,
  HotelSupplier.JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER,
  HotelSupplier.JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER,
  HotelSupplier.JSON_PROPERTY_SHORT_DESCRIPTIONS,
  HotelSupplier.JSON_PROPERTY_LONG_DESCRIPTIONS,
  HotelSupplier.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  HotelSupplier.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  HotelSupplier.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  HotelSupplier.JSON_PROPERTY_LOCATION_POINT,
  HotelSupplier.JSON_PROPERTY_POLICY,
  HotelSupplier.JSON_PROPERTY_SOCIALS,
  HotelSupplier.JSON_PROPERTY_OWNER_CONTACT,
  HotelSupplier.JSON_PROPERTY_RESERVATIONS_CONTACT,
  HotelSupplier.JSON_PROPERTY_ACCOUNTING_CONTACT,
  HotelSupplier.JSON_PROPERTY_ACCOUNTING_ADDRESS,
  HotelSupplier.JSON_PROPERTY_LIFESTYLE_TYPES,
  HotelSupplier.JSON_PROPERTY_GREEN_INDEX_SCORES,
  HotelSupplier.JSON_PROPERTY_AGREEMENT_ACCEPTED,
  HotelSupplier.JSON_PROPERTY_MARKETING_OPTIN_ALLOWED,
  HotelSupplier.JSON_PROPERTY_LOGOS,
  HotelSupplier.JSON_PROPERTY_NUMBER_OF_ROOMS,
  HotelSupplier.JSON_PROPERTY_ADDRESS,
  HotelSupplier.JSON_PROPERTY_RESERVATION_DESK_START_TIME,
  HotelSupplier.JSON_PROPERTY_RESERVATION_DESK_END_TIME,
  HotelSupplier.JSON_PROPERTY_ACTIVE,
  HotelSupplier.JSON_PROPERTY_FULL_ADDRESS,
  HotelSupplier.JSON_PROPERTY_SOCIAL_NETWORKS,
  HotelSupplier.JSON_PROPERTY_LIFESTYLES,
  HotelSupplier.JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME,
  HotelSupplier.JSON_PROPERTY_PROPERTY_ACTIVE,
  HotelSupplier.JSON_PROPERTY_PLATFORM_ACTIVE
})
@JsonTypeName("Hotel_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-06-06T15:46:48.127304372+07:00[Asia/Bangkok]")
public class HotelSupplier {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_HOTEL_CODE = "hotelCode";
  private String hotelCode;

  public static final String JSON_PROPERTY_HOTEL_CODE_CONTEXT = "hotelCodeContext";
  private String hotelCodeContext;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  /**
   * wink.travel sets this status as the hotel moves through the payment workflow and manually for approval.
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    DISABLED("DISABLED"),
    
    SUSPENDED("SUSPENDED"),
    
    REMOVED("REMOVED"),
    
    WAITING_ON_CONTRACT("WAITING_ON_CONTRACT"),
    
    CONTRACT_SIGNED("CONTRACT_SIGNED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status = StatusEnum.WAITING_ON_CONTRACT;

  public static final String JSON_PROPERTY_EXTERNAL_STATUS = "externalStatus";
  private String externalStatus = "6";

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private String multimediaIdentifier;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_IMAGE_ANGLE = "imageAngle";
  private String imageAngle;

  public static final String JSON_PROPERTY_REMOTE_IP = "remoteIp";
  private String remoteIp;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
  private String hotelChain;

  public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
  private String hotelBrand;

  public static final String JSON_PROPERTY_CHANNEL_MANAGER_IDENTIFIER = "channelManagerIdentifier";
  private UUID channelManagerIdentifier;

  /**
   * Property&#39;s channel manager. Rate ownership is decided based on the channel manager selected. Defaults to &#x60;TRAVELIKO&#x60; which is the same as no channel manager and rate ownership goes to the payment.
   */
  public enum ChannelManagerEnum {
    TRAVELIKO("TRAVELIKO"),
    
    SITEMINDER("SITEMINDER"),
    
    FASTBOOKING("FASTBOOKING"),
    
    RATEGAIN("RATEGAIN"),
    
    CLOUD_BEDS("CLOUD_BEDS"),
    
    YIELD_PLANET("YIELD_PLANET"),
    
    TRAVELCLICK("TRAVELCLICK"),
    
    HOTEL_GURU("HOTEL_GURU"),
    
    OTHER_CHANNEL_MANAGER("OTHER_CHANNEL_MANAGER"),
    
    BOOKING_JINI("BOOKING_JINI"),
    
    HOTEL_LINK_SOLUTIONS("HOTEL_LINK_SOLUTIONS"),
    
    ALLOTZ("ALLOTZ"),
    
    DEDGE("DEDGE"),
    
    RATE_TIGER("RATE_TIGER"),
    
    RESAVENUE("RESAVENUE"),
    
    COMANCHE("COMANCHE"),
    
    OMNIBEES("OMNIBEES"),
    
    EZEE("EZEE"),
    
    SYNXIS("SYNXIS");

    private String value;

    ChannelManagerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelManagerEnum fromValue(String value) {
      for (ChannelManagerEnum b : ChannelManagerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_MANAGER = "channelManager";
  private ChannelManagerEnum channelManager = ChannelManagerEnum.TRAVELIKO;

  public static final String JSON_PROPERTY_OTHER_CHANNEL_MANAGER = "otherChannelManager";
  private String otherChannelManager;

  public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
  private String licenseNumber;

  public static final String JSON_PROPERTY_STARS = "stars";
  private Integer stars;

  public static final String JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER = "fullNameOfGeneralManager";
  private String fullNameOfGeneralManager;

  public static final String JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER = "profilePictureIdentifierGeneralManager";
  private String profilePictureIdentifierGeneralManager;

  public static final String JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER = "messagesOfGeneralManager";
  private List<SimpleDescriptionSupplier> messagesOfGeneralManager = new ArrayList<>();

  public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
  private List<LocalizedDescriptionSupplier> shortDescriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
  private List<LocalizedDescriptionSupplier> longDescriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  private List<String> hotelAmenityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  private List<String> propertyAccessibilityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  private List<String> propertySecurityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_LOCATION_POINT = "locationPoint";
  private GeoJsonPointSupplier locationPoint;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicySupplier policy;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialSupplier> socials = new ArrayList<>();

  public static final String JSON_PROPERTY_OWNER_CONTACT = "ownerContact";
  private ContactSupplier ownerContact;

  public static final String JSON_PROPERTY_RESERVATIONS_CONTACT = "reservationsContact";
  private ContactSupplier reservationsContact;

  public static final String JSON_PROPERTY_ACCOUNTING_CONTACT = "accountingContact";
  private ContactSupplier accountingContact;

  public static final String JSON_PROPERTY_ACCOUNTING_ADDRESS = "accountingAddress";
  private AddressSupplier accountingAddress;

  /**
   * List of all lifestyles property has associated with. See [Lifestyle geoname data](#operation/showLifestyles)
   */
  public enum LifestyleTypesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypesEnum fromValue(String value) {
      for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  private List<LifestyleTypesEnum> lifestyleTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_GREEN_INDEX_SCORES = "greenIndexScores";
  private AggregateGreendexAnswersSupplier greenIndexScores;

  public static final String JSON_PROPERTY_AGREEMENT_ACCEPTED = "agreementAccepted";
  private Boolean agreementAccepted;

  public static final String JSON_PROPERTY_MARKETING_OPTIN_ALLOWED = "marketingOptinAllowed";
  private Boolean marketingOptinAllowed;

  public static final String JSON_PROPERTY_LOGOS = "logos";
  private List<SimpleMultimediaSupplier> logos = new ArrayList<>();

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplier address;

  public static final String JSON_PROPERTY_RESERVATION_DESK_START_TIME = "reservationDeskStartTime";
  private String reservationDeskStartTime;

  public static final String JSON_PROPERTY_RESERVATION_DESK_END_TIME = "reservationDeskEndTime";
  private String reservationDeskEndTime;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
  private String fullAddress;

  public static final String JSON_PROPERTY_SOCIAL_NETWORKS = "socialNetworks";
  private Boolean socialNetworks;

  public static final String JSON_PROPERTY_LIFESTYLES = "lifestyles";
  private Boolean lifestyles;

  public static final String JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME = "contractSignerFullName";
  private String contractSignerFullName;

  public static final String JSON_PROPERTY_PROPERTY_ACTIVE = "propertyActive";
  private Boolean propertyActive;

  public static final String JSON_PROPERTY_PLATFORM_ACTIVE = "platformActive";
  private Boolean platformActive;

  public HotelSupplier() {
  }

  public HotelSupplier hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel identifier
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public HotelSupplier hotelCode(String hotelCode) {
    
    this.hotelCode = hotelCode;
    return this;
  }

   /**
   * A shorter unique code to refer to the hotel. Country Code + 5 digit number
   * @return hotelCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HOTEL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelCode() {
    return hotelCode;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelCode(String hotelCode) {
    this.hotelCode = hotelCode;
  }


  public HotelSupplier hotelCodeContext(String hotelCodeContext) {
    
    this.hotelCodeContext = hotelCodeContext;
    return this;
  }

   /**
   * Origin of hotel data
   * @return hotelCodeContext
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HOTEL_CODE_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelCodeContext() {
    return hotelCodeContext;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CODE_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelCodeContext(String hotelCodeContext) {
    this.hotelCodeContext = hotelCodeContext;
  }


  public HotelSupplier localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Name of the hotel in its local language if you use it for domestic guests.
   * @return localName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public HotelSupplier legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of your hotel as it is registered.
   * @return legalName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public HotelSupplier urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique url-friendly slug to identify property
   * @return urlName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelSupplier currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code
   * @return currencyCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public HotelSupplier status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * wink.travel sets this status as the hotel moves through the payment workflow and manually for approval.
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public HotelSupplier externalStatus(String externalStatus) {
    
    this.externalStatus = externalStatus;
    return this;
  }

   /**
   * Property goes active by changing externalStatus from 6 (Inactive) to 1 (Active) according to OTA property status.
   * @return externalStatus
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EXTERNAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalStatus() {
    return externalStatus;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalStatus(String externalStatus) {
    this.externalStatus = externalStatus;
  }


  public HotelSupplier multimediaIdentifier(String multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Featured property image document identifier. This is the image that is ordered first in the list of property images.
   * @return multimediaIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaIdentifier(String multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public HotelSupplier imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary identifier that can be used directly to retrieve media from Cloudinary.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public HotelSupplier imageAngle(String imageAngle) {
    
    this.imageAngle = imageAngle;
    return this;
  }

   /**
   * Featured image angle (if available).
   * @return imageAngle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageAngle() {
    return imageAngle;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageAngle(String imageAngle) {
    this.imageAngle = imageAngle;
  }


  public HotelSupplier remoteIp(String remoteIp) {
    
    this.remoteIp = remoteIp;
    return this;
  }

   /**
   * Get remoteIp
   * @return remoteIp
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REMOTE_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRemoteIp() {
    return remoteIp;
  }


  @JsonProperty(JSON_PROPERTY_REMOTE_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemoteIp(String remoteIp) {
    this.remoteIp = remoteIp;
  }


  public HotelSupplier locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public HotelSupplier segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public HotelSupplier hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public HotelSupplier architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public HotelSupplier whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public HotelSupplier hotelChain(String hotelChain) {
    
    this.hotelChain = hotelChain;
    return this;
  }

   /**
   * Hotel chain name if property is part of that chain.
   * @return hotelChain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChain() {
    return hotelChain;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChain(String hotelChain) {
    this.hotelChain = hotelChain;
  }


  public HotelSupplier hotelBrand(String hotelBrand) {
    
    this.hotelBrand = hotelBrand;
    return this;
  }

   /**
   * Hotel brand name if property is part of that brand.
   * @return hotelBrand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelBrand() {
    return hotelBrand;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelBrand(String hotelBrand) {
    this.hotelBrand = hotelBrand;
  }


  public HotelSupplier channelManagerIdentifier(UUID channelManagerIdentifier) {
    
    this.channelManagerIdentifier = channelManagerIdentifier;
    return this;
  }

   /**
   * Property&#39;s channel manager. Rate ownership is decided based on the channel manager selected.
   * @return channelManagerIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getChannelManagerIdentifier() {
    return channelManagerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelManagerIdentifier(UUID channelManagerIdentifier) {
    this.channelManagerIdentifier = channelManagerIdentifier;
  }


  public HotelSupplier channelManager(ChannelManagerEnum channelManager) {
    
    this.channelManager = channelManager;
    return this;
  }

   /**
   * Property&#39;s channel manager. Rate ownership is decided based on the channel manager selected. Defaults to &#x60;TRAVELIKO&#x60; which is the same as no channel manager and rate ownership goes to the payment.
   * @return channelManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChannelManagerEnum getChannelManager() {
    return channelManager;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelManager(ChannelManagerEnum channelManager) {
    this.channelManager = channelManager;
  }


  public HotelSupplier otherChannelManager(String otherChannelManager) {
    
    this.otherChannelManager = otherChannelManager;
    return this;
  }

   /**
   * If the property is currently using a channel manager but it isn&#39;t yet part of our list, chose &#39;OTHER_CHANNEL_MANAGER&#39; as channelManager and fill in the name of the channel manager here
   * @return otherChannelManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OTHER_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOtherChannelManager() {
    return otherChannelManager;
  }


  @JsonProperty(JSON_PROPERTY_OTHER_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOtherChannelManager(String otherChannelManager) {
    this.otherChannelManager = otherChannelManager;
  }


  public HotelSupplier licenseNumber(String licenseNumber) {
    
    this.licenseNumber = licenseNumber;
    return this;
  }

   /**
   * If the property has a valid license number to run a hotel in their country, add it here.
   * @return licenseNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLicenseNumber() {
    return licenseNumber;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseNumber(String licenseNumber) {
    this.licenseNumber = licenseNumber;
  }


  public HotelSupplier stars(Integer stars) {
    
    this.stars = stars;
    return this;
  }

   /**
   * Hotel star rating.
   * minimum: 0
   * maximum: 6
   * @return stars
  **/
  @jakarta.annotation.Nullable
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStars() {
    return stars;
  }


  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStars(Integer stars) {
    this.stars = stars;
  }


  public HotelSupplier fullNameOfGeneralManager(String fullNameOfGeneralManager) {
    
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
    return this;
  }

   /**
   * Name of GM currently managing the property.
   * @return fullNameOfGeneralManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullNameOfGeneralManager() {
    return fullNameOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullNameOfGeneralManager(String fullNameOfGeneralManager) {
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
  }


  public HotelSupplier profilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
    return this;
  }

   /**
   * Cloudinary image identifier of GM currently managing the property.
   * @return profilePictureIdentifierGeneralManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProfilePictureIdentifierGeneralManager() {
    return profilePictureIdentifierGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
  }


  public HotelSupplier messagesOfGeneralManager(List<SimpleDescriptionSupplier> messagesOfGeneralManager) {
    
    this.messagesOfGeneralManager = messagesOfGeneralManager;
    return this;
  }

  public HotelSupplier addMessagesOfGeneralManagerItem(SimpleDescriptionSupplier messagesOfGeneralManagerItem) {
    if (this.messagesOfGeneralManager == null) {
      this.messagesOfGeneralManager = new ArrayList<>();
    }
    this.messagesOfGeneralManager.add(messagesOfGeneralManagerItem);
    return this;
  }

   /**
   * Personal welcome message from GM.
   * @return messagesOfGeneralManager
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescriptionSupplier> getMessagesOfGeneralManager() {
    return messagesOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessagesOfGeneralManager(List<SimpleDescriptionSupplier> messagesOfGeneralManager) {
    this.messagesOfGeneralManager = messagesOfGeneralManager;
  }


  public HotelSupplier shortDescriptions(List<LocalizedDescriptionSupplier> shortDescriptions) {
    
    this.shortDescriptions = shortDescriptions;
    return this;
  }

  public HotelSupplier addShortDescriptionsItem(LocalizedDescriptionSupplier shortDescriptionsItem) {
    if (this.shortDescriptions == null) {
      this.shortDescriptions = new ArrayList<>();
    }
    this.shortDescriptions.add(shortDescriptionsItem);
    return this;
  }

   /**
   * Localized short descriptions of property.
   * @return shortDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionSupplier> getShortDescriptions() {
    return shortDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortDescriptions(List<LocalizedDescriptionSupplier> shortDescriptions) {
    this.shortDescriptions = shortDescriptions;
  }


  public HotelSupplier longDescriptions(List<LocalizedDescriptionSupplier> longDescriptions) {
    
    this.longDescriptions = longDescriptions;
    return this;
  }

  public HotelSupplier addLongDescriptionsItem(LocalizedDescriptionSupplier longDescriptionsItem) {
    if (this.longDescriptions == null) {
      this.longDescriptions = new ArrayList<>();
    }
    this.longDescriptions.add(longDescriptionsItem);
    return this;
  }

   /**
   * Localized long descriptions of property.
   * @return longDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionSupplier> getLongDescriptions() {
    return longDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongDescriptions(List<LocalizedDescriptionSupplier> longDescriptions) {
    this.longDescriptions = longDescriptions;
  }


  public HotelSupplier hotelAmenityCodes(List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public HotelSupplier addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return hotelAmenityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }


  public HotelSupplier propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public HotelSupplier addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return propertyAccessibilityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }


  public HotelSupplier propertySecurityCodes(List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public HotelSupplier addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return propertySecurityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }


  public HotelSupplier locationPoint(GeoJsonPointSupplier locationPoint) {
    
    this.locationPoint = locationPoint;
    return this;
  }

   /**
   * Get locationPoint
   * @return locationPoint
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointSupplier getLocationPoint() {
    return locationPoint;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationPoint(GeoJsonPointSupplier locationPoint) {
    this.locationPoint = locationPoint;
  }


  public HotelSupplier policy(PropertyPolicySupplier policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicySupplier getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicySupplier policy) {
    this.policy = policy;
  }


  public HotelSupplier socials(List<SocialSupplier> socials) {
    
    this.socials = socials;
    return this;
  }

  public HotelSupplier addSocialsItem(SocialSupplier socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * List of all social network account property has.
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialSupplier> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialSupplier> socials) {
    this.socials = socials;
  }


  public HotelSupplier ownerContact(ContactSupplier ownerContact) {
    
    this.ownerContact = ownerContact;
    return this;
  }

   /**
   * Get ownerContact
   * @return ownerContact
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactSupplier getOwnerContact() {
    return ownerContact;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerContact(ContactSupplier ownerContact) {
    this.ownerContact = ownerContact;
  }


  public HotelSupplier reservationsContact(ContactSupplier reservationsContact) {
    
    this.reservationsContact = reservationsContact;
    return this;
  }

   /**
   * Get reservationsContact
   * @return reservationsContact
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESERVATIONS_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactSupplier getReservationsContact() {
    return reservationsContact;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATIONS_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationsContact(ContactSupplier reservationsContact) {
    this.reservationsContact = reservationsContact;
  }


  public HotelSupplier accountingContact(ContactSupplier accountingContact) {
    
    this.accountingContact = accountingContact;
    return this;
  }

   /**
   * Get accountingContact
   * @return accountingContact
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCOUNTING_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactSupplier getAccountingContact() {
    return accountingContact;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNTING_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountingContact(ContactSupplier accountingContact) {
    this.accountingContact = accountingContact;
  }


  public HotelSupplier accountingAddress(AddressSupplier accountingAddress) {
    
    this.accountingAddress = accountingAddress;
    return this;
  }

   /**
   * Get accountingAddress
   * @return accountingAddress
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCOUNTING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressSupplier getAccountingAddress() {
    return accountingAddress;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNTING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountingAddress(AddressSupplier accountingAddress) {
    this.accountingAddress = accountingAddress;
  }


  public HotelSupplier lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public HotelSupplier addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

   /**
   * List of all lifestyles property has associated with. See [Lifestyle geoname data](#operation/showLifestyles)
   * @return lifestyleTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestyleTypesEnum> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }


  public HotelSupplier greenIndexScores(AggregateGreendexAnswersSupplier greenIndexScores) {
    
    this.greenIndexScores = greenIndexScores;
    return this;
  }

   /**
   * Get greenIndexScores
   * @return greenIndexScores
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AggregateGreendexAnswersSupplier getGreenIndexScores() {
    return greenIndexScores;
  }


  @JsonProperty(JSON_PROPERTY_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGreenIndexScores(AggregateGreendexAnswersSupplier greenIndexScores) {
    this.greenIndexScores = greenIndexScores;
  }


  public HotelSupplier agreementAccepted(Boolean agreementAccepted) {
    
    this.agreementAccepted = agreementAccepted;
    return this;
  }

   /**
   * Property has accepted our terms and conditions.
   * @return agreementAccepted
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_AGREEMENT_ACCEPTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAgreementAccepted() {
    return agreementAccepted;
  }


  @JsonProperty(JSON_PROPERTY_AGREEMENT_ACCEPTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAgreementAccepted(Boolean agreementAccepted) {
    this.agreementAccepted = agreementAccepted;
  }


  public HotelSupplier marketingOptinAllowed(Boolean marketingOptinAllowed) {
    
    this.marketingOptinAllowed = marketingOptinAllowed;
    return this;
  }

   /**
   * Property agreed to let the payment use its logo and images for marketing purposes (with proper credits).
   * @return marketingOptinAllowed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MARKETING_OPTIN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMarketingOptinAllowed() {
    return marketingOptinAllowed;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_OPTIN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarketingOptinAllowed(Boolean marketingOptinAllowed) {
    this.marketingOptinAllowed = marketingOptinAllowed;
  }


  public HotelSupplier logos(List<SimpleMultimediaSupplier> logos) {
    
    this.logos = logos;
    return this;
  }

  public HotelSupplier addLogosItem(SimpleMultimediaSupplier logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

   /**
   * List of logo images of property
   * @return logos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaSupplier> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(List<SimpleMultimediaSupplier> logos) {
    this.logos = logos;
  }


  public HotelSupplier numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for property
   * minimum: 1
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public HotelSupplier address(AddressSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(AddressSupplier address) {
    this.address = address;
  }


  public HotelSupplier reservationDeskStartTime(String reservationDeskStartTime) {
    
    this.reservationDeskStartTime = reservationDeskStartTime;
    return this;
  }

   /**
   * If the reservation desk does not operate 24 hours, enter a start time.
   * @return reservationDeskStartTime
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_START_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReservationDeskStartTime() {
    return reservationDeskStartTime;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_START_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationDeskStartTime(String reservationDeskStartTime) {
    this.reservationDeskStartTime = reservationDeskStartTime;
  }


  public HotelSupplier reservationDeskEndTime(String reservationDeskEndTime) {
    
    this.reservationDeskEndTime = reservationDeskEndTime;
    return this;
  }

   /**
   * If the reservation desk does not operate 24 hours, enter an end time.
   * @return reservationDeskEndTime
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReservationDeskEndTime() {
    return reservationDeskEndTime;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationDeskEndTime(String reservationDeskEndTime) {
    this.reservationDeskEndTime = reservationDeskEndTime;
  }


  public HotelSupplier active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Property is both approved and activated.
   * @return active
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public HotelSupplier fullAddress(String fullAddress) {
    
    this.fullAddress = fullAddress;
    return this;
  }

   /**
   * Concatenated address into a single string
   * @return fullAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullAddress() {
    return fullAddress;
  }


  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullAddress(String fullAddress) {
    this.fullAddress = fullAddress;
  }


  public HotelSupplier socialNetworks(Boolean socialNetworks) {
    
    this.socialNetworks = socialNetworks;
    return this;
  }

   /**
   * Whether property has any social networks associated with her profile.
   * @return socialNetworks
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOCIAL_NETWORKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSocialNetworks() {
    return socialNetworks;
  }


  @JsonProperty(JSON_PROPERTY_SOCIAL_NETWORKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocialNetworks(Boolean socialNetworks) {
    this.socialNetworks = socialNetworks;
  }


  public HotelSupplier lifestyles(Boolean lifestyles) {
    
    this.lifestyles = lifestyles;
    return this;
  }

   /**
   * Whether property has any lifestyles associated with her profile.
   * @return lifestyles
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLifestyles() {
    return lifestyles;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyles(Boolean lifestyles) {
    this.lifestyles = lifestyles;
  }


  public HotelSupplier contractSignerFullName(String contractSignerFullName) {
    
    this.contractSignerFullName = contractSignerFullName;
    return this;
  }

   /**
   * Concatenated name of contract signer into one string.
   * @return contractSignerFullName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContractSignerFullName() {
    return contractSignerFullName;
  }


  @JsonProperty(JSON_PROPERTY_CONTRACT_SIGNER_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContractSignerFullName(String contractSignerFullName) {
    this.contractSignerFullName = contractSignerFullName;
  }


  public HotelSupplier propertyActive(Boolean propertyActive) {
    
    this.propertyActive = propertyActive;
    return this;
  }

   /**
   * Property activated itself and went live.
   * @return propertyActive
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPropertyActive() {
    return propertyActive;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyActive(Boolean propertyActive) {
    this.propertyActive = propertyActive;
  }


  public HotelSupplier platformActive(Boolean platformActive) {
    
    this.platformActive = platformActive;
    return this;
  }

   /**
   * Platform approved property.
   * @return platformActive
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PLATFORM_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPlatformActive() {
    return platformActive;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORM_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformActive(Boolean platformActive) {
    this.platformActive = platformActive;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelSupplier hotelSupplier = (HotelSupplier) o;
    return Objects.equals(this.hotelIdentifier, hotelSupplier.hotelIdentifier) &&
        Objects.equals(this.name, hotelSupplier.name) &&
        Objects.equals(this.hotelCode, hotelSupplier.hotelCode) &&
        Objects.equals(this.hotelCodeContext, hotelSupplier.hotelCodeContext) &&
        Objects.equals(this.localName, hotelSupplier.localName) &&
        Objects.equals(this.legalName, hotelSupplier.legalName) &&
        Objects.equals(this.urlName, hotelSupplier.urlName) &&
        Objects.equals(this.currencyCode, hotelSupplier.currencyCode) &&
        Objects.equals(this.status, hotelSupplier.status) &&
        Objects.equals(this.externalStatus, hotelSupplier.externalStatus) &&
        Objects.equals(this.multimediaIdentifier, hotelSupplier.multimediaIdentifier) &&
        Objects.equals(this.imageIdentifier, hotelSupplier.imageIdentifier) &&
        Objects.equals(this.imageAngle, hotelSupplier.imageAngle) &&
        Objects.equals(this.remoteIp, hotelSupplier.remoteIp) &&
        Objects.equals(this.locationCategory, hotelSupplier.locationCategory) &&
        Objects.equals(this.segmentCategory, hotelSupplier.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotelSupplier.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotelSupplier.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotelSupplier.whenBuilt) &&
        Objects.equals(this.hotelChain, hotelSupplier.hotelChain) &&
        Objects.equals(this.hotelBrand, hotelSupplier.hotelBrand) &&
        Objects.equals(this.channelManagerIdentifier, hotelSupplier.channelManagerIdentifier) &&
        Objects.equals(this.channelManager, hotelSupplier.channelManager) &&
        Objects.equals(this.otherChannelManager, hotelSupplier.otherChannelManager) &&
        Objects.equals(this.licenseNumber, hotelSupplier.licenseNumber) &&
        Objects.equals(this.stars, hotelSupplier.stars) &&
        Objects.equals(this.fullNameOfGeneralManager, hotelSupplier.fullNameOfGeneralManager) &&
        Objects.equals(this.profilePictureIdentifierGeneralManager, hotelSupplier.profilePictureIdentifierGeneralManager) &&
        Objects.equals(this.messagesOfGeneralManager, hotelSupplier.messagesOfGeneralManager) &&
        Objects.equals(this.shortDescriptions, hotelSupplier.shortDescriptions) &&
        Objects.equals(this.longDescriptions, hotelSupplier.longDescriptions) &&
        Objects.equals(this.hotelAmenityCodes, hotelSupplier.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, hotelSupplier.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, hotelSupplier.propertySecurityCodes) &&
        Objects.equals(this.locationPoint, hotelSupplier.locationPoint) &&
        Objects.equals(this.policy, hotelSupplier.policy) &&
        Objects.equals(this.socials, hotelSupplier.socials) &&
        Objects.equals(this.ownerContact, hotelSupplier.ownerContact) &&
        Objects.equals(this.reservationsContact, hotelSupplier.reservationsContact) &&
        Objects.equals(this.accountingContact, hotelSupplier.accountingContact) &&
        Objects.equals(this.accountingAddress, hotelSupplier.accountingAddress) &&
        Objects.equals(this.lifestyleTypes, hotelSupplier.lifestyleTypes) &&
        Objects.equals(this.greenIndexScores, hotelSupplier.greenIndexScores) &&
        Objects.equals(this.agreementAccepted, hotelSupplier.agreementAccepted) &&
        Objects.equals(this.marketingOptinAllowed, hotelSupplier.marketingOptinAllowed) &&
        Objects.equals(this.logos, hotelSupplier.logos) &&
        Objects.equals(this.numberOfRooms, hotelSupplier.numberOfRooms) &&
        Objects.equals(this.address, hotelSupplier.address) &&
        Objects.equals(this.reservationDeskStartTime, hotelSupplier.reservationDeskStartTime) &&
        Objects.equals(this.reservationDeskEndTime, hotelSupplier.reservationDeskEndTime) &&
        Objects.equals(this.active, hotelSupplier.active) &&
        Objects.equals(this.fullAddress, hotelSupplier.fullAddress) &&
        Objects.equals(this.socialNetworks, hotelSupplier.socialNetworks) &&
        Objects.equals(this.lifestyles, hotelSupplier.lifestyles) &&
        Objects.equals(this.contractSignerFullName, hotelSupplier.contractSignerFullName) &&
        Objects.equals(this.propertyActive, hotelSupplier.propertyActive) &&
        Objects.equals(this.platformActive, hotelSupplier.platformActive);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, name, hotelCode, hotelCodeContext, localName, legalName, urlName, currencyCode, status, externalStatus, multimediaIdentifier, imageIdentifier, imageAngle, remoteIp, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, hotelChain, hotelBrand, channelManagerIdentifier, channelManager, otherChannelManager, licenseNumber, stars, fullNameOfGeneralManager, profilePictureIdentifierGeneralManager, messagesOfGeneralManager, shortDescriptions, longDescriptions, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, locationPoint, policy, socials, ownerContact, reservationsContact, accountingContact, accountingAddress, lifestyleTypes, greenIndexScores, agreementAccepted, marketingOptinAllowed, logos, numberOfRooms, address, reservationDeskStartTime, reservationDeskEndTime, active, fullAddress, socialNetworks, lifestyles, contractSignerFullName, propertyActive, platformActive);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelSupplier {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    hotelCode: ").append(toIndentedString(hotelCode)).append("\n");
    sb.append("    hotelCodeContext: ").append(toIndentedString(hotelCodeContext)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    externalStatus: ").append(toIndentedString(externalStatus)).append("\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    imageAngle: ").append(toIndentedString(imageAngle)).append("\n");
    sb.append("    remoteIp: ").append(toIndentedString(remoteIp)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    hotelChain: ").append(toIndentedString(hotelChain)).append("\n");
    sb.append("    hotelBrand: ").append(toIndentedString(hotelBrand)).append("\n");
    sb.append("    channelManagerIdentifier: ").append(toIndentedString(channelManagerIdentifier)).append("\n");
    sb.append("    channelManager: ").append(toIndentedString(channelManager)).append("\n");
    sb.append("    otherChannelManager: ").append(toIndentedString(otherChannelManager)).append("\n");
    sb.append("    licenseNumber: ").append(toIndentedString(licenseNumber)).append("\n");
    sb.append("    stars: ").append(toIndentedString(stars)).append("\n");
    sb.append("    fullNameOfGeneralManager: ").append(toIndentedString(fullNameOfGeneralManager)).append("\n");
    sb.append("    profilePictureIdentifierGeneralManager: ").append(toIndentedString(profilePictureIdentifierGeneralManager)).append("\n");
    sb.append("    messagesOfGeneralManager: ").append(toIndentedString(messagesOfGeneralManager)).append("\n");
    sb.append("    shortDescriptions: ").append(toIndentedString(shortDescriptions)).append("\n");
    sb.append("    longDescriptions: ").append(toIndentedString(longDescriptions)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    locationPoint: ").append(toIndentedString(locationPoint)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    ownerContact: ").append(toIndentedString(ownerContact)).append("\n");
    sb.append("    reservationsContact: ").append(toIndentedString(reservationsContact)).append("\n");
    sb.append("    accountingContact: ").append(toIndentedString(accountingContact)).append("\n");
    sb.append("    accountingAddress: ").append(toIndentedString(accountingAddress)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    greenIndexScores: ").append(toIndentedString(greenIndexScores)).append("\n");
    sb.append("    agreementAccepted: ").append(toIndentedString(agreementAccepted)).append("\n");
    sb.append("    marketingOptinAllowed: ").append(toIndentedString(marketingOptinAllowed)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    reservationDeskStartTime: ").append(toIndentedString(reservationDeskStartTime)).append("\n");
    sb.append("    reservationDeskEndTime: ").append(toIndentedString(reservationDeskEndTime)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    fullAddress: ").append(toIndentedString(fullAddress)).append("\n");
    sb.append("    socialNetworks: ").append(toIndentedString(socialNetworks)).append("\n");
    sb.append("    lifestyles: ").append(toIndentedString(lifestyles)).append("\n");
    sb.append("    contractSignerFullName: ").append(toIndentedString(contractSignerFullName)).append("\n");
    sb.append("    propertyActive: ").append(toIndentedString(propertyActive)).append("\n");
    sb.append("    platformActive: ").append(toIndentedString(platformActive)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

