/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.BookingTestRequestSupplierDetails;
import travel.wink.sdk.extranet.model.BookingViewSupplierDetails;
import travel.wink.sdk.extranet.model.ChannelNameSupplier;
import travel.wink.sdk.extranet.model.DailyRateListUpdateSupplier;
import travel.wink.sdk.extranet.model.DailyRateUpdateSupplier;
import travel.wink.sdk.extranet.model.DateRangeSupplier;
import travel.wink.sdk.extranet.model.DescriptiveRoomSupplierDetails;
import travel.wink.sdk.extranet.model.PageRateSupplier;
import travel.wink.sdk.extranet.model.RateSupplier;
import travel.wink.sdk.extranet.model.RateTesterSupplierDetails;
import travel.wink.sdk.extranet.model.StateSupplier;

public class DailyRateApi {
    private ApiClient apiClient;

    public DailyRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public DailyRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec bulkUpdateRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdateSupplier dailyRateUpdateSupplier, String winkVersion) throws WebClientResponseException {
        DailyRateUpdateSupplier postBody = dailyRateUpdateSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dailyRateUpdateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dailyRateUpdateSupplier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/update", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> bulkUpdateRate(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdateSupplier dailyRateUpdateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateUpdateSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> bulkUpdateRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdateSupplier dailyRateUpdateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateUpdateSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bulkUpdateRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, DailyRateUpdateSupplier dailyRateUpdateSupplier, String winkVersion) throws WebClientResponseException {
        return this.bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateUpdateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec bulkUpdateRate1RequestCreation(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdateSupplier dailyRateListUpdateSupplier, String winkVersion) throws WebClientResponseException {
        DailyRateListUpdateSupplier postBody = dailyRateListUpdateSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dailyRateListUpdateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dailyRateListUpdateSupplier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/list/update", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> bulkUpdateRate1(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdateSupplier dailyRateListUpdateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateListUpdateSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> bulkUpdateRate1WithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdateSupplier dailyRateListUpdateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateListUpdateSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bulkUpdateRate1WithResponseSpec(String hotelIdentifier, String masterRateIdentifier, DailyRateListUpdateSupplier dailyRateListUpdateSupplier, String winkVersion) throws WebClientResponseException {
        return this.bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, dailyRateListUpdateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec createTestBookingRequestCreation(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        BookingTestRequestSupplierDetails postBody = bookingTestRequestSupplierDetails;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingTestRequestSupplierDetails == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingTestRequestSupplierDetails' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/booking", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplierDetails> createTestBooking(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(){};
        return this.createTestBookingRequestCreation(hotelIdentifier, bookingTestRequestSupplierDetails, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplierDetails>> createTestBookingWithHttpInfo(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(){};
        return this.createTestBookingRequestCreation(hotelIdentifier, bookingTestRequestSupplierDetails, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createTestBookingWithResponseSpec(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        return this.createTestBookingRequestCreation(hotelIdentifier, bookingTestRequestSupplierDetails, winkVersion);
    }

    private WebClient.ResponseSpec showAllHotelRatesRequestCreation(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        DateRangeSupplier postBody = dateRangeSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dateRangeSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRangeSupplier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/rates/dates", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> showAllHotelRates(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.showAllHotelRatesRequestCreation(hotelIdentifier, dateRangeSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> showAllHotelRatesWithHttpInfo(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.showAllHotelRatesRequestCreation(hotelIdentifier, dateRangeSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAllHotelRatesWithResponseSpec(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        return this.showAllHotelRatesRequestCreation(hotelIdentifier, dateRangeSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showAllMasterRatesRatesRequestCreation(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        DateRangeSupplier postBody = dateRangeSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dateRangeSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRangeSupplier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rates/dates", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> showAllMasterRatesRates(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> showAllMasterRatesRatesWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(){};
        return this.showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAllMasterRatesRatesWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        return this.showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showChannelsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/channel/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ChannelNameSupplier> showChannels(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>(){};
        return this.showChannelsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChannelNameSupplier>>> showChannelsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>(){};
        return this.showChannelsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChannelsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showChannelsRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showDailyRatesPageRequestCreation(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageRateSupplier> showDailyRatesPage(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>(){};
        return this.showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageRateSupplier>> showDailyRatesPageWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>(){};
        return this.showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDailyRatesPageWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return this.showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showDescriptiveInventoryRequestCreation(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        RateTesterSupplierDetails postBody = rateTesterSupplierDetails;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateTesterSupplierDetails == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateTesterSupplierDetails' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/room/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<DescriptiveRoomSupplierDetails> showDescriptiveInventory(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>(){};
        return this.showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterSupplierDetails, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<DescriptiveRoomSupplierDetails>>> showDescriptiveInventoryWithHttpInfo(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>(){};
        return this.showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterSupplierDetails, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDescriptiveInventoryWithResponseSpec(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        return this.showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterSupplierDetails, winkVersion);
    }
}

