/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;

@JsonPropertyOrder(value={"identifier", "name", "descriptions", "pricingType", "basePrice", "discountedPrice", "multimedias", "minPax", "maxPax", "percentPremium", "percentDiscount"})
@JsonTypeName(value="TransactionalTravelInventory_Supplier")
public class TransactionalTravelInventorySupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
    private CustomMonetaryAmount basePrice;
    public static final String JSON_PROPERTY_DISCOUNTED_PRICE = "discountedPrice";
    private CustomMonetaryAmount discountedPrice;
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaSupplier> multimedias = new ArrayList<SimpleMultimediaSupplier>();
    public static final String JSON_PROPERTY_MIN_PAX = "minPax";
    private Integer minPax;
    public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
    private Integer maxPax;
    public static final String JSON_PROPERTY_PERCENT_PREMIUM = "percentPremium";
    private Float percentPremium;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    private Float percentDiscount;

    public TransactionalTravelInventorySupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public TransactionalTravelInventorySupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public TransactionalTravelInventorySupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public TransactionalTravelInventorySupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public TransactionalTravelInventorySupplier pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public TransactionalTravelInventorySupplier basePrice(CustomMonetaryAmount basePrice) {
        this.basePrice = basePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getBasePrice() {
        return this.basePrice;
    }

    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBasePrice(CustomMonetaryAmount basePrice) {
        this.basePrice = basePrice;
    }

    public TransactionalTravelInventorySupplier discountedPrice(CustomMonetaryAmount discountedPrice) {
        this.discountedPrice = discountedPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="discountedPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getDiscountedPrice() {
        return this.discountedPrice;
    }

    @JsonProperty(value="discountedPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDiscountedPrice(CustomMonetaryAmount discountedPrice) {
        this.discountedPrice = discountedPrice;
    }

    public TransactionalTravelInventorySupplier multimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public TransactionalTravelInventorySupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaSupplier>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleMultimediaSupplier> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
    }

    public TransactionalTravelInventorySupplier minPax(Integer minPax) {
        this.minPax = minPax;
        return this;
    }

    @Nullable
    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinPax() {
        return this.minPax;
    }

    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinPax(Integer minPax) {
        this.minPax = minPax;
    }

    public TransactionalTravelInventorySupplier maxPax(Integer maxPax) {
        this.maxPax = maxPax;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxPax() {
        return this.maxPax;
    }

    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxPax(Integer maxPax) {
        this.maxPax = maxPax;
    }

    public TransactionalTravelInventorySupplier percentPremium(Float percentPremium) {
        this.percentPremium = percentPremium;
        return this;
    }

    @Nullable
    @JsonProperty(value="percentPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPercentPremium() {
        return this.percentPremium;
    }

    @JsonProperty(value="percentPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercentPremium(Float percentPremium) {
        this.percentPremium = percentPremium;
    }

    public TransactionalTravelInventorySupplier percentDiscount(Float percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nullable
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercentDiscount(Float percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionalTravelInventorySupplier transactionalTravelInventorySupplier = (TransactionalTravelInventorySupplier)o;
        return Objects.equals(this.identifier, transactionalTravelInventorySupplier.identifier) && Objects.equals(this.name, transactionalTravelInventorySupplier.name) && Objects.equals(this.descriptions, transactionalTravelInventorySupplier.descriptions) && Objects.equals((Object)this.pricingType, (Object)transactionalTravelInventorySupplier.pricingType) && Objects.equals(this.basePrice, transactionalTravelInventorySupplier.basePrice) && Objects.equals(this.discountedPrice, transactionalTravelInventorySupplier.discountedPrice) && Objects.equals(this.multimedias, transactionalTravelInventorySupplier.multimedias) && Objects.equals(this.minPax, transactionalTravelInventorySupplier.minPax) && Objects.equals(this.maxPax, transactionalTravelInventorySupplier.maxPax) && Objects.equals(this.percentPremium, transactionalTravelInventorySupplier.percentPremium) && Objects.equals(this.percentDiscount, transactionalTravelInventorySupplier.percentDiscount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.descriptions, this.pricingType, this.basePrice, this.discountedPrice, this.multimedias, this.minPax, this.maxPax, this.percentPremium, this.percentDiscount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionalTravelInventorySupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    basePrice: ").append(this.toIndentedString(this.basePrice)).append("\n");
        sb.append("    discountedPrice: ").append(this.toIndentedString(this.discountedPrice)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    minPax: ").append(this.toIndentedString(this.minPax)).append("\n");
        sb.append("    maxPax: ").append(this.toIndentedString(this.maxPax)).append("\n");
        sb.append("    percentPremium: ").append(this.toIndentedString(this.percentPremium)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

