/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.AnnouncementViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.UpsertAnnouncementRequestSupplier;

public class AnnouncementApi {
    private ApiClient apiClient;

    public AnnouncementApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnnouncementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAnnouncementRequestCreation(String hotelIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertAnnouncementRequestSupplier postBody = upsertAnnouncementRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAnnouncementRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAnnouncementRequestSupplier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementViewSupplier> createAnnouncement(String hotelIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.createAnnouncementRequestCreation(hotelIdentifier, upsertAnnouncementRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementViewSupplier>> createAnnouncementWithHttpInfo(String hotelIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.createAnnouncementRequestCreation(hotelIdentifier, upsertAnnouncementRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAnnouncementWithResponseSpec(String hotelIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createAnnouncementRequestCreation(hotelIdentifier, upsertAnnouncementRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(){};
        return this.removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(){};
        return this.removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAnnouncementWithResponseSpec(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementViewSupplier> showAnnouncement(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementViewSupplier>> showAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnnouncementWithResponseSpec(String hotelIdentifier, String announcementIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAnnouncementsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAnnouncements", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AnnouncementViewSupplier> showAnnouncements(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AnnouncementViewSupplier>>> showAnnouncementsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.showAnnouncementsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnnouncementsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAnnouncementsRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateAnnouncementRequestCreation(String hotelIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertAnnouncementRequestSupplier postBody = upsertAnnouncementRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAnnouncementRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAnnouncementRequestSupplier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/announcement/{announcementIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementViewSupplier> updateAnnouncement(String hotelIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementViewSupplier>> updateAnnouncementWithHttpInfo(String hotelIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(){};
        return this.updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAnnouncementWithResponseSpec(String hotelIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateAnnouncementRequestCreation(hotelIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion);
    }
}

