/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Objects;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;

@JsonPropertyOrder(value={"startDate", "endDate", "rateSource", "master", "closedOnArrival", "closedOnDeparture", "numberOfUnits", "rate", "minLengthOfStay", "maxLengthOfStay"})
@JsonTypeName(value="DailyRateUpdate_Supplier")
public class DailyRateUpdateSupplier {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private String rateSource = "TRAVELIKO";
    public static final String JSON_PROPERTY_MASTER = "master";
    private Boolean master = true;
    public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
    private Boolean closedOnArrival = false;
    public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
    private Boolean closedOnDeparture = false;
    public static final String JSON_PROPERTY_NUMBER_OF_UNITS = "numberOfUnits";
    private Integer numberOfUnits;
    public static final String JSON_PROPERTY_RATE = "rate";
    private CustomMonetaryAmount rate;
    public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
    private Integer minLengthOfStay;
    public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
    private Integer maxLengthOfStay;

    public DailyRateUpdateSupplier startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public DailyRateUpdateSupplier endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public DailyRateUpdateSupplier rateSource(String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRateSource(String rateSource) {
        this.rateSource = rateSource;
    }

    public DailyRateUpdateSupplier master(Boolean master) {
        this.master = master;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getMaster() {
        return this.master;
    }

    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaster(Boolean master) {
        this.master = master;
    }

    public DailyRateUpdateSupplier closedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnArrival() {
        return this.closedOnArrival;
    }

    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
    }

    public DailyRateUpdateSupplier closedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnDeparture() {
        return this.closedOnDeparture;
    }

    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
    }

    public DailyRateUpdateSupplier numberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfUnits() {
        return this.numberOfUnits;
    }

    @JsonProperty(value="numberOfUnits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfUnits(Integer numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public DailyRateUpdateSupplier rate(CustomMonetaryAmount rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getRate() {
        return this.rate;
    }

    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRate(CustomMonetaryAmount rate) {
        this.rate = rate;
    }

    public DailyRateUpdateSupplier minLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
        return this;
    }

    @Nullable
    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLengthOfStay() {
        return this.minLengthOfStay;
    }

    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
    }

    public DailyRateUpdateSupplier maxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLengthOfStay() {
        return this.maxLengthOfStay;
    }

    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DailyRateUpdateSupplier dailyRateUpdateSupplier = (DailyRateUpdateSupplier)o;
        return Objects.equals(this.startDate, dailyRateUpdateSupplier.startDate) && Objects.equals(this.endDate, dailyRateUpdateSupplier.endDate) && Objects.equals(this.rateSource, dailyRateUpdateSupplier.rateSource) && Objects.equals(this.master, dailyRateUpdateSupplier.master) && Objects.equals(this.closedOnArrival, dailyRateUpdateSupplier.closedOnArrival) && Objects.equals(this.closedOnDeparture, dailyRateUpdateSupplier.closedOnDeparture) && Objects.equals(this.numberOfUnits, dailyRateUpdateSupplier.numberOfUnits) && Objects.equals(this.rate, dailyRateUpdateSupplier.rate) && Objects.equals(this.minLengthOfStay, dailyRateUpdateSupplier.minLengthOfStay) && Objects.equals(this.maxLengthOfStay, dailyRateUpdateSupplier.maxLengthOfStay);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.rateSource, this.master, this.closedOnArrival, this.closedOnDeparture, this.numberOfUnits, this.rate, this.minLengthOfStay, this.maxLengthOfStay);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DailyRateUpdateSupplier {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    master: ").append(this.toIndentedString(this.master)).append("\n");
        sb.append("    closedOnArrival: ").append(this.toIndentedString(this.closedOnArrival)).append("\n");
        sb.append("    closedOnDeparture: ").append(this.toIndentedString(this.closedOnDeparture)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    minLengthOfStay: ").append(this.toIndentedString(this.minLengthOfStay)).append("\n");
        sb.append("    maxLengthOfStay: ").append(this.toIndentedString(this.maxLengthOfStay)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

