/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 27.1.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.DisplayCompanySupplier;
import travel.wink.sdk.extranet.model.GroupedBookingSalesMetricsSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CompanyDetailsBookingSalesMetricsSupplier
 */
@JsonPropertyOrder({
  CompanyDetailsBookingSalesMetricsSupplier.JSON_PROPERTY_COMPANY,
  CompanyDetailsBookingSalesMetricsSupplier.JSON_PROPERTY_TOTAL,
  CompanyDetailsBookingSalesMetricsSupplier.JSON_PROPERTY_BY_PROPERTY_LIST,
  CompanyDetailsBookingSalesMetricsSupplier.JSON_PROPERTY_BY_COUNTRY_LIST
})
@JsonTypeName("CompanyDetailsBookingSalesMetrics_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-24T11:29:25.504149142+07:00[Asia/Bangkok]")
public class CompanyDetailsBookingSalesMetricsSupplier {
  public static final String JSON_PROPERTY_COMPANY = "company";
  private DisplayCompanySupplier company;

  public static final String JSON_PROPERTY_TOTAL = "total";
  private GroupedBookingSalesMetricsSupplier total;

  public static final String JSON_PROPERTY_BY_PROPERTY_LIST = "byPropertyList";
  private List<GroupedBookingSalesMetricsSupplier> byPropertyList = new ArrayList<>();

  public static final String JSON_PROPERTY_BY_COUNTRY_LIST = "byCountryList";
  private List<GroupedBookingSalesMetricsSupplier> byCountryList = new ArrayList<>();

  public CompanyDetailsBookingSalesMetricsSupplier() {
  }

  public CompanyDetailsBookingSalesMetricsSupplier company(DisplayCompanySupplier company) {
    
    this.company = company;
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DisplayCompanySupplier getCompany() {
    return company;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompany(DisplayCompanySupplier company) {
    this.company = company;
  }


  public CompanyDetailsBookingSalesMetricsSupplier total(GroupedBookingSalesMetricsSupplier total) {
    
    this.total = total;
    return this;
  }

   /**
   * Get total
   * @return total
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GroupedBookingSalesMetricsSupplier getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(GroupedBookingSalesMetricsSupplier total) {
    this.total = total;
  }


  public CompanyDetailsBookingSalesMetricsSupplier byPropertyList(List<GroupedBookingSalesMetricsSupplier> byPropertyList) {
    
    this.byPropertyList = byPropertyList;
    return this;
  }

  public CompanyDetailsBookingSalesMetricsSupplier addByPropertyListItem(GroupedBookingSalesMetricsSupplier byPropertyListItem) {
    if (this.byPropertyList == null) {
      this.byPropertyList = new ArrayList<>();
    }
    this.byPropertyList.add(byPropertyListItem);
    return this;
  }

   /**
   * Get byPropertyList
   * @return byPropertyList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BY_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<GroupedBookingSalesMetricsSupplier> getByPropertyList() {
    return byPropertyList;
  }


  @JsonProperty(JSON_PROPERTY_BY_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setByPropertyList(List<GroupedBookingSalesMetricsSupplier> byPropertyList) {
    this.byPropertyList = byPropertyList;
  }


  public CompanyDetailsBookingSalesMetricsSupplier byCountryList(List<GroupedBookingSalesMetricsSupplier> byCountryList) {
    
    this.byCountryList = byCountryList;
    return this;
  }

  public CompanyDetailsBookingSalesMetricsSupplier addByCountryListItem(GroupedBookingSalesMetricsSupplier byCountryListItem) {
    if (this.byCountryList == null) {
      this.byCountryList = new ArrayList<>();
    }
    this.byCountryList.add(byCountryListItem);
    return this;
  }

   /**
   * Get byCountryList
   * @return byCountryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BY_COUNTRY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<GroupedBookingSalesMetricsSupplier> getByCountryList() {
    return byCountryList;
  }


  @JsonProperty(JSON_PROPERTY_BY_COUNTRY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setByCountryList(List<GroupedBookingSalesMetricsSupplier> byCountryList) {
    this.byCountryList = byCountryList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyDetailsBookingSalesMetricsSupplier companyDetailsBookingSalesMetricsSupplier = (CompanyDetailsBookingSalesMetricsSupplier) o;
    return Objects.equals(this.company, companyDetailsBookingSalesMetricsSupplier.company) &&
        Objects.equals(this.total, companyDetailsBookingSalesMetricsSupplier.total) &&
        Objects.equals(this.byPropertyList, companyDetailsBookingSalesMetricsSupplier.byPropertyList) &&
        Objects.equals(this.byCountryList, companyDetailsBookingSalesMetricsSupplier.byCountryList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(company, total, byPropertyList, byCountryList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyDetailsBookingSalesMetricsSupplier {\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    byPropertyList: ").append(toIndentedString(byPropertyList)).append("\n");
    sb.append("    byCountryList: ").append(toIndentedString(byCountryList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

