/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.0.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AddressSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.LocalizedDescriptionSupplier;
import travel.wink.sdk.extranet.model.PropertyPolicySupplier;
import travel.wink.sdk.extranet.model.RecognitionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.model.SocialSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Combined property data.
 */
@JsonPropertyOrder({
  HotelOnMapSupplier.JSON_PROPERTY_IDENTIFIER,
  HotelOnMapSupplier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelOnMapSupplier.JSON_PROPERTY_NAME,
  HotelOnMapSupplier.JSON_PROPERTY_LOCAL_NAME,
  HotelOnMapSupplier.JSON_PROPERTY_CHAIN,
  HotelOnMapSupplier.JSON_PROPERTY_BRAND,
  HotelOnMapSupplier.JSON_PROPERTY_URL_NAME,
  HotelOnMapSupplier.JSON_PROPERTY_STAR_RATING,
  HotelOnMapSupplier.JSON_PROPERTY_BOOKINGS,
  HotelOnMapSupplier.JSON_PROPERTY_AGGREGATE_REVIEW_RATING,
  HotelOnMapSupplier.JSON_PROPERTY_LOCATION,
  HotelOnMapSupplier.JSON_PROPERTY_SHORT_DESCRIPTIONS,
  HotelOnMapSupplier.JSON_PROPERTY_LONG_DESCRIPTIONS,
  HotelOnMapSupplier.JSON_PROPERTY_AGGREGATE_GREENDEX_RATING,
  HotelOnMapSupplier.JSON_PROPERTY_LIFESTYLE_TYPES,
  HotelOnMapSupplier.JSON_PROPERTY_TOTAL_REVIEWS,
  HotelOnMapSupplier.JSON_PROPERTY_AVAILABLE,
  HotelOnMapSupplier.JSON_PROPERTY_HOTEL_AVAILABLE,
  HotelOnMapSupplier.JSON_PROPERTY_RESERVATIONS,
  HotelOnMapSupplier.JSON_PROPERTY_SOCIALS,
  HotelOnMapSupplier.JSON_PROPERTY_IMAGES,
  HotelOnMapSupplier.JSON_PROPERTY_VIDEOS,
  HotelOnMapSupplier.JSON_PROPERTY_POLICY,
  HotelOnMapSupplier.JSON_PROPERTY_THIRD_PARTY_REVIEWS,
  HotelOnMapSupplier.JSON_PROPERTY_ATTRACTIONS,
  HotelOnMapSupplier.JSON_PROPERTY_RECREATIONS,
  HotelOnMapSupplier.JSON_PROPERTY_POIS,
  HotelOnMapSupplier.JSON_PROPERTY_RESTAURANTS,
  HotelOnMapSupplier.JSON_PROPERTY_MEETING_ROOMS,
  HotelOnMapSupplier.JSON_PROPERTY_SPAS,
  HotelOnMapSupplier.JSON_PROPERTY_ADD_ONS,
  HotelOnMapSupplier.JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER,
  HotelOnMapSupplier.JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER,
  HotelOnMapSupplier.JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER,
  HotelOnMapSupplier.JSON_PROPERTY_LOCATION_CATEGORY,
  HotelOnMapSupplier.JSON_PROPERTY_SEGMENT_CATEGORY,
  HotelOnMapSupplier.JSON_PROPERTY_HOTEL_CATEGORY,
  HotelOnMapSupplier.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  HotelOnMapSupplier.JSON_PROPERTY_WHEN_BUILT,
  HotelOnMapSupplier.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  HotelOnMapSupplier.JSON_PROPERTY_IMAGE_IDENTIFIER,
  HotelOnMapSupplier.JSON_PROPERTY_IMAGE_ANGLE,
  HotelOnMapSupplier.JSON_PROPERTY_VIDEO_IDENTIFIER,
  HotelOnMapSupplier.JSON_PROPERTY_CURRENCY_CODE,
  HotelOnMapSupplier.JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT,
  HotelOnMapSupplier.JSON_PROPERTY_PRICE_SCORE,
  HotelOnMapSupplier.JSON_PROPERTY_PERK_SCORE,
  HotelOnMapSupplier.JSON_PROPERTY_PACKAGE_SCORE,
  HotelOnMapSupplier.JSON_PROPERTY_LOYALTY_SCORE,
  HotelOnMapSupplier.JSON_PROPERTY_POPULAR_SCORE,
  HotelOnMapSupplier.JSON_PROPERTY_EXPERIENCE_SCORE,
  HotelOnMapSupplier.JSON_PROPERTY_AVAILABILITY_SCORE,
  HotelOnMapSupplier.JSON_PROPERTY_VIEWS,
  HotelOnMapSupplier.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  HotelOnMapSupplier.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  HotelOnMapSupplier.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  HotelOnMapSupplier.JSON_PROPERTY_NUMBER_OF_ROOMS,
  HotelOnMapSupplier.JSON_PROPERTY_ADDRESS,
  HotelOnMapSupplier.JSON_PROPERTY_ACTIVE,
  HotelOnMapSupplier.JSON_PROPERTY_URL_PARAMETERS
})
@JsonTypeName("HotelOnMap_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-07-31T09:10:59.911161702+07:00[Asia/Bangkok]")
public class HotelOnMapSupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  private String chain;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings = 0l;

  public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
  private Float aggregateReviewRating = 0.0f;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointSupplier location;

  public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
  private List<LocalizedDescriptionSupplier> shortDescriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
  private List<LocalizedDescriptionSupplier> longDescriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_AGGREGATE_GREENDEX_RATING = "aggregateGreendexRating";
  private Float aggregateGreendexRating = 0.0f;

  /**
   * A list of lifestyles the property associates with.
   */
  public enum LifestyleTypesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypesEnum fromValue(String value) {
      for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  private List<LifestyleTypesEnum> lifestyleTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_TOTAL_REVIEWS = "totalReviews";
  private Integer totalReviews = 0;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available = false;

  public static final String JSON_PROPERTY_HOTEL_AVAILABLE = "hotelAvailable";
  private Boolean hotelAvailable = false;

  public static final String JSON_PROPERTY_RESERVATIONS = "reservations";
  private ContactSupplier reservations;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialSupplier> socials = new ArrayList<>();

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<SimpleMultimediaSupplier> images = new ArrayList<>();

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  private List<SimpleMultimediaSupplier> videos = new ArrayList<>();

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicySupplier policy;

  public static final String JSON_PROPERTY_THIRD_PARTY_REVIEWS = "thirdPartyReviews";
  private List<RecognitionSupplier> thirdPartyReviews = new ArrayList<>();

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private Integer attractions = 0;

  public static final String JSON_PROPERTY_RECREATIONS = "recreations";
  private Integer recreations = 0;

  public static final String JSON_PROPERTY_POIS = "pois";
  private Integer pois = 0;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private Integer restaurants = 0;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private Integer meetingRooms = 0;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private Integer spas = 0;

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  private Integer addOns = 0;

  public static final String JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER = "fullNameOfGeneralManager";
  private String fullNameOfGeneralManager;

  public static final String JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER = "profilePictureIdentifierGeneralManager";
  private String profilePictureIdentifierGeneralManager;

  public static final String JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER = "messagesOfGeneralManager";
  private List<LocalizedDescriptionSupplier> messagesOfGeneralManager = new ArrayList<>();

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private String multimediaIdentifier;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_IMAGE_ANGLE = "imageAngle";
  private String imageAngle;

  public static final String JSON_PROPERTY_VIDEO_IDENTIFIER = "videoIdentifier";
  private String videoIdentifier;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT = "membershipRateDiscount";
  private Float membershipRateDiscount = 0f;

  public static final String JSON_PROPERTY_PRICE_SCORE = "priceScore";
  private Integer priceScore = 0;

  public static final String JSON_PROPERTY_PERK_SCORE = "perkScore";
  private Integer perkScore = 0;

  public static final String JSON_PROPERTY_PACKAGE_SCORE = "packageScore";
  private Integer packageScore = 0;

  public static final String JSON_PROPERTY_LOYALTY_SCORE = "loyaltyScore";
  private Integer loyaltyScore = 0;

  public static final String JSON_PROPERTY_POPULAR_SCORE = "popularScore";
  private Integer popularScore = 0;

  public static final String JSON_PROPERTY_EXPERIENCE_SCORE = "experienceScore";
  private Integer experienceScore = 0;

  public static final String JSON_PROPERTY_AVAILABILITY_SCORE = "availabilityScore";
  private Integer availabilityScore = 0;

  public static final String JSON_PROPERTY_VIEWS = "views";
  private Long views = 0l;

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  private List<String> hotelAmenityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  private List<String> propertyAccessibilityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  private List<String> propertySecurityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms = 0;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplier address;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_URL_PARAMETERS = "urlParameters";
  private String urlParameters;

  public HotelOnMapSupplier() {
  }

  public HotelOnMapSupplier identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier. This is NOT the same as the unique hotel record identifier.
   * @return identifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public HotelOnMapSupplier hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelOnMapSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Hotel trade name
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public HotelOnMapSupplier localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Hotel local name if different from the trade name or if it is the local language.
   * @return localName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public HotelOnMapSupplier chain(String chain) {
    
    this.chain = chain;
    return this;
  }

   /**
   * Name of hotel chain if applicable.
   * @return chain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(String chain) {
    this.chain = chain;
  }


  public HotelOnMapSupplier brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Name of hotel brand
   * @return brand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public HotelOnMapSupplier urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique URL-friendly name slug of hotel
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelOnMapSupplier starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.
   * minimum: 0
   * maximum: 6
   * @return starRating
  **/
  @jakarta.annotation.Nullable
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  public HotelOnMapSupplier bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Number of bookings for this property on the wink.travel payment.
   * @return bookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public HotelOnMapSupplier aggregateReviewRating(Float aggregateReviewRating) {
    
    this.aggregateReviewRating = aggregateReviewRating;
    return this;
  }

   /**
   * Aggregate score based on all current user reviews.
   * @return aggregateReviewRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateReviewRating() {
    return aggregateReviewRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateReviewRating(Float aggregateReviewRating) {
    this.aggregateReviewRating = aggregateReviewRating;
  }


  public HotelOnMapSupplier location(GeoJsonPointSupplier location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointSupplier getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointSupplier location) {
    this.location = location;
  }


  public HotelOnMapSupplier shortDescriptions(List<LocalizedDescriptionSupplier> shortDescriptions) {
    
    this.shortDescriptions = shortDescriptions;
    return this;
  }

  public HotelOnMapSupplier addShortDescriptionsItem(LocalizedDescriptionSupplier shortDescriptionsItem) {
    if (this.shortDescriptions == null) {
      this.shortDescriptions = new ArrayList<>();
    }
    this.shortDescriptions.add(shortDescriptionsItem);
    return this;
  }

   /**
   * A localized list of short property descriptions
   * @return shortDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionSupplier> getShortDescriptions() {
    return shortDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortDescriptions(List<LocalizedDescriptionSupplier> shortDescriptions) {
    this.shortDescriptions = shortDescriptions;
  }


  public HotelOnMapSupplier longDescriptions(List<LocalizedDescriptionSupplier> longDescriptions) {
    
    this.longDescriptions = longDescriptions;
    return this;
  }

  public HotelOnMapSupplier addLongDescriptionsItem(LocalizedDescriptionSupplier longDescriptionsItem) {
    if (this.longDescriptions == null) {
      this.longDescriptions = new ArrayList<>();
    }
    this.longDescriptions.add(longDescriptionsItem);
    return this;
  }

   /**
   * A localized list of longer property descriptions
   * @return longDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionSupplier> getLongDescriptions() {
    return longDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongDescriptions(List<LocalizedDescriptionSupplier> longDescriptions) {
    this.longDescriptions = longDescriptions;
  }


  public HotelOnMapSupplier aggregateGreendexRating(Float aggregateGreendexRating) {
    
    this.aggregateGreendexRating = aggregateGreendexRating;
    return this;
  }

   /**
   * Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.
   * @return aggregateGreendexRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateGreendexRating() {
    return aggregateGreendexRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateGreendexRating(Float aggregateGreendexRating) {
    this.aggregateGreendexRating = aggregateGreendexRating;
  }


  public HotelOnMapSupplier lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public HotelOnMapSupplier addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

   /**
   * Get lifestyleTypes
   * @return lifestyleTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestyleTypesEnum> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }


  public HotelOnMapSupplier totalReviews(Integer totalReviews) {
    
    this.totalReviews = totalReviews;
    return this;
  }

   /**
   * Count of total reviews left by users at this property.
   * @return totalReviews
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalReviews() {
    return totalReviews;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalReviews(Integer totalReviews) {
    this.totalReviews = totalReviews;
  }


  public HotelOnMapSupplier available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Flag indicating whether the payment has made this property available for sale.
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public HotelOnMapSupplier hotelAvailable(Boolean hotelAvailable) {
    
    this.hotelAvailable = hotelAvailable;
    return this;
  }

   /**
   * Flag indicating whether the property has made this property available for sale.
   * @return hotelAvailable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHotelAvailable() {
    return hotelAvailable;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAvailable(Boolean hotelAvailable) {
    this.hotelAvailable = hotelAvailable;
  }


  public HotelOnMapSupplier reservations(ContactSupplier reservations) {
    
    this.reservations = reservations;
    return this;
  }

   /**
   * Get reservations
   * @return reservations
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactSupplier getReservations() {
    return reservations;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservations(ContactSupplier reservations) {
    this.reservations = reservations;
  }


  public HotelOnMapSupplier socials(List<SocialSupplier> socials) {
    
    this.socials = socials;
    return this;
  }

  public HotelOnMapSupplier addSocialsItem(SocialSupplier socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Property&#39;s social network accounts
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialSupplier> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialSupplier> socials) {
    this.socials = socials;
  }


  public HotelOnMapSupplier images(List<SimpleMultimediaSupplier> images) {
    
    this.images = images;
    return this;
  }

  public HotelOnMapSupplier addImagesItem(SimpleMultimediaSupplier imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * Property images.
   * @return images
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaSupplier> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<SimpleMultimediaSupplier> images) {
    this.images = images;
  }


  public HotelOnMapSupplier videos(List<SimpleMultimediaSupplier> videos) {
    
    this.videos = videos;
    return this;
  }

  public HotelOnMapSupplier addVideosItem(SimpleMultimediaSupplier videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

   /**
   * Property videos.
   * @return videos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaSupplier> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(List<SimpleMultimediaSupplier> videos) {
    this.videos = videos;
  }


  public HotelOnMapSupplier policy(PropertyPolicySupplier policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicySupplier getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicySupplier policy) {
    this.policy = policy;
  }


  public HotelOnMapSupplier thirdPartyReviews(List<RecognitionSupplier> thirdPartyReviews) {
    
    this.thirdPartyReviews = thirdPartyReviews;
    return this;
  }

  public HotelOnMapSupplier addThirdPartyReviewsItem(RecognitionSupplier thirdPartyReviewsItem) {
    if (this.thirdPartyReviews == null) {
      this.thirdPartyReviews = new ArrayList<>();
    }
    this.thirdPartyReviews.add(thirdPartyReviewsItem);
    return this;
  }

   /**
   * Array of awards and third party reviews given to property by certified / non-certified providers.
   * @return thirdPartyReviews
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RecognitionSupplier> getThirdPartyReviews() {
    return thirdPartyReviews;
  }


  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThirdPartyReviews(List<RecognitionSupplier> thirdPartyReviews) {
    this.thirdPartyReviews = thirdPartyReviews;
  }


  public HotelOnMapSupplier attractions(Integer attractions) {
    
    this.attractions = attractions;
    return this;
  }

   /**
   * Number of attractions property has listed on its profile.
   * @return attractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(Integer attractions) {
    this.attractions = attractions;
  }


  public HotelOnMapSupplier recreations(Integer recreations) {
    
    this.recreations = recreations;
    return this;
  }

   /**
   * Number of activites property has listed on its profile.
   * @return recreations
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRecreations() {
    return recreations;
  }


  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreations(Integer recreations) {
    this.recreations = recreations;
  }


  public HotelOnMapSupplier pois(Integer pois) {
    
    this.pois = pois;
    return this;
  }

   /**
   * Number of places property has listed on its profile.
   * @return pois
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPois() {
    return pois;
  }


  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPois(Integer pois) {
    this.pois = pois;
  }


  public HotelOnMapSupplier restaurants(Integer restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

   /**
   * Number of restaurants property has on its profile.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(Integer restaurants) {
    this.restaurants = restaurants;
  }


  public HotelOnMapSupplier meetingRooms(Integer meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

   /**
   * Number of meeting rooms property has on its profile.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(Integer meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public HotelOnMapSupplier spas(Integer spas) {
    
    this.spas = spas;
    return this;
  }

   /**
   * Number of spas property has on its profile.
   * @return spas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(Integer spas) {
    this.spas = spas;
  }


  public HotelOnMapSupplier addOns(Integer addOns) {
    
    this.addOns = addOns;
    return this;
  }

   /**
   * Number of add-ons property has on its profile.
   * @return addOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(Integer addOns) {
    this.addOns = addOns;
  }


  public HotelOnMapSupplier fullNameOfGeneralManager(String fullNameOfGeneralManager) {
    
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
    return this;
  }

   /**
   * Full name of the property&#39;s current and active general manager.
   * @return fullNameOfGeneralManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullNameOfGeneralManager() {
    return fullNameOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullNameOfGeneralManager(String fullNameOfGeneralManager) {
    this.fullNameOfGeneralManager = fullNameOfGeneralManager;
  }


  public HotelOnMapSupplier profilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
    return this;
  }

   /**
   * Cloudinary identifier referencing image of general manager.
   * @return profilePictureIdentifierGeneralManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProfilePictureIdentifierGeneralManager() {
    return profilePictureIdentifierGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_IDENTIFIER_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfilePictureIdentifierGeneralManager(String profilePictureIdentifierGeneralManager) {
    this.profilePictureIdentifierGeneralManager = profilePictureIdentifierGeneralManager;
  }


  public HotelOnMapSupplier messagesOfGeneralManager(List<LocalizedDescriptionSupplier> messagesOfGeneralManager) {
    
    this.messagesOfGeneralManager = messagesOfGeneralManager;
    return this;
  }

  public HotelOnMapSupplier addMessagesOfGeneralManagerItem(LocalizedDescriptionSupplier messagesOfGeneralManagerItem) {
    if (this.messagesOfGeneralManager == null) {
      this.messagesOfGeneralManager = new ArrayList<>();
    }
    this.messagesOfGeneralManager.add(messagesOfGeneralManagerItem);
    return this;
  }

   /**
   * A list of localized welcome messages created by the property&#39;s general manager.
   * @return messagesOfGeneralManager
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionSupplier> getMessagesOfGeneralManager() {
    return messagesOfGeneralManager;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGES_OF_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessagesOfGeneralManager(List<LocalizedDescriptionSupplier> messagesOfGeneralManager) {
    this.messagesOfGeneralManager = messagesOfGeneralManager;
  }


  public HotelOnMapSupplier locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public HotelOnMapSupplier segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public HotelOnMapSupplier hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public HotelOnMapSupplier architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public HotelOnMapSupplier whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public HotelOnMapSupplier multimediaIdentifier(String multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Featured image identifier for this property.
   * @return multimediaIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimediaIdentifier(String multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public HotelOnMapSupplier imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary image identifier for this property.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public HotelOnMapSupplier imageAngle(String imageAngle) {
    
    this.imageAngle = imageAngle;
    return this;
  }

   /**
   * Meta data information about image angle that gives integrators a chance to crop this image properly.
   * @return imageAngle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageAngle() {
    return imageAngle;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageAngle(String imageAngle) {
    this.imageAngle = imageAngle;
  }


  public HotelOnMapSupplier videoIdentifier(String videoIdentifier) {
    
    this.videoIdentifier = videoIdentifier;
    return this;
  }

   /**
   * Featured Cloudinary video identifier for this property.
   * @return videoIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VIDEO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVideoIdentifier() {
    return videoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_VIDEO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideoIdentifier(String videoIdentifier) {
    this.videoIdentifier = videoIdentifier;
  }


  public HotelOnMapSupplier currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code for property.
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public HotelOnMapSupplier membershipRateDiscount(Float membershipRateDiscount) {
    
    this.membershipRateDiscount = membershipRateDiscount;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return membershipRateDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMembershipRateDiscount() {
    return membershipRateDiscount;
  }


  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMembershipRateDiscount(Float membershipRateDiscount) {
    this.membershipRateDiscount = membershipRateDiscount;
  }


  public HotelOnMapSupplier priceScore(Integer priceScore) {
    
    this.priceScore = priceScore;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return priceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriceScore() {
    return priceScore;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceScore(Integer priceScore) {
    this.priceScore = priceScore;
  }


  public HotelOnMapSupplier perkScore(Integer perkScore) {
    
    this.perkScore = perkScore;
    return this;
  }

   /**
   * A property&#39;s perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it&#39;s there to compare it against other properties.
   * @return perkScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkScore() {
    return perkScore;
  }


  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkScore(Integer perkScore) {
    this.perkScore = perkScore;
  }


  public HotelOnMapSupplier packageScore(Integer packageScore) {
    
    this.packageScore = packageScore;
    return this;
  }

   /**
   * A property&#39;s package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it&#39;s there to compare it against other properties.
   * @return packageScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPackageScore() {
    return packageScore;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageScore(Integer packageScore) {
    this.packageScore = packageScore;
  }


  public HotelOnMapSupplier loyaltyScore(Integer loyaltyScore) {
    
    this.loyaltyScore = loyaltyScore;
    return this;
  }

   /**
   * A property&#39;s loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it&#39;s there to compare it against other properties.
   * @return loyaltyScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLoyaltyScore() {
    return loyaltyScore;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyScore(Integer loyaltyScore) {
    this.loyaltyScore = loyaltyScore;
  }


  public HotelOnMapSupplier popularScore(Integer popularScore) {
    
    this.popularScore = popularScore;
    return this;
  }

   /**
   * A property&#39;s popular score is based on calculating number of bookings across room types. There is no max score; it&#39;s there to compare it against other properties.
   * @return popularScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPopularScore() {
    return popularScore;
  }


  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopularScore(Integer popularScore) {
    this.popularScore = popularScore;
  }


  public HotelOnMapSupplier experienceScore(Integer experienceScore) {
    
    this.experienceScore = experienceScore;
    return this;
  }

   /**
   * A property&#39;s experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it&#39;s there to compare it against other properties.
   * @return experienceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExperienceScore() {
    return experienceScore;
  }


  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperienceScore(Integer experienceScore) {
    this.experienceScore = experienceScore;
  }


  public HotelOnMapSupplier availabilityScore(Integer availabilityScore) {
    
    this.availabilityScore = availabilityScore;
    return this;
  }

   /**
   * A property&#39;s availability score is based on general availability of all room types. If most room types are always unavailable, the attractiveness of this property goes down. We use this as our primary benchmark to decide how and when to feature properties. There is no max score; it&#39;s there to compare it against other properties.
   * @return availabilityScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAvailabilityScore() {
    return availabilityScore;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailabilityScore(Integer availabilityScore) {
    this.availabilityScore = availabilityScore;
  }


  public HotelOnMapSupplier views(Long views) {
    
    this.views = views;
    return this;
  }

   /**
   * Total number of user views of this property.
   * @return views
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getViews() {
    return views;
  }


  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViews(Long views) {
    this.views = views;
  }


  public HotelOnMapSupplier hotelAmenityCodes(List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public HotelOnMapSupplier addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelAmenityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }


  public HotelOnMapSupplier propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public HotelOnMapSupplier addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertyAccessibilityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }


  public HotelOnMapSupplier propertySecurityCodes(List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public HotelOnMapSupplier addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertySecurityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }


  public HotelOnMapSupplier numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for this property.
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public HotelOnMapSupplier address(AddressSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(AddressSupplier address) {
    this.address = address;
  }


  public HotelOnMapSupplier active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * A property is considered active when both available and hotelAvailable flags are true.
   * @return active
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public HotelOnMapSupplier urlParameters(String urlParameters) {
    
    this.urlParameters = urlParameters;
    return this;
  }

   /**
   * Convenience data point that creates url friendly query parameters of property.
   * @return urlParameters
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlParameters() {
    return urlParameters;
  }


  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlParameters(String urlParameters) {
    this.urlParameters = urlParameters;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelOnMapSupplier hotelOnMapSupplier = (HotelOnMapSupplier) o;
    return Objects.equals(this.identifier, hotelOnMapSupplier.identifier) &&
        Objects.equals(this.hotelIdentifier, hotelOnMapSupplier.hotelIdentifier) &&
        Objects.equals(this.name, hotelOnMapSupplier.name) &&
        Objects.equals(this.localName, hotelOnMapSupplier.localName) &&
        Objects.equals(this.chain, hotelOnMapSupplier.chain) &&
        Objects.equals(this.brand, hotelOnMapSupplier.brand) &&
        Objects.equals(this.urlName, hotelOnMapSupplier.urlName) &&
        Objects.equals(this.starRating, hotelOnMapSupplier.starRating) &&
        Objects.equals(this.bookings, hotelOnMapSupplier.bookings) &&
        Objects.equals(this.aggregateReviewRating, hotelOnMapSupplier.aggregateReviewRating) &&
        Objects.equals(this.location, hotelOnMapSupplier.location) &&
        Objects.equals(this.shortDescriptions, hotelOnMapSupplier.shortDescriptions) &&
        Objects.equals(this.longDescriptions, hotelOnMapSupplier.longDescriptions) &&
        Objects.equals(this.aggregateGreendexRating, hotelOnMapSupplier.aggregateGreendexRating) &&
        Objects.equals(this.lifestyleTypes, hotelOnMapSupplier.lifestyleTypes) &&
        Objects.equals(this.totalReviews, hotelOnMapSupplier.totalReviews) &&
        Objects.equals(this.available, hotelOnMapSupplier.available) &&
        Objects.equals(this.hotelAvailable, hotelOnMapSupplier.hotelAvailable) &&
        Objects.equals(this.reservations, hotelOnMapSupplier.reservations) &&
        Objects.equals(this.socials, hotelOnMapSupplier.socials) &&
        Objects.equals(this.images, hotelOnMapSupplier.images) &&
        Objects.equals(this.videos, hotelOnMapSupplier.videos) &&
        Objects.equals(this.policy, hotelOnMapSupplier.policy) &&
        Objects.equals(this.thirdPartyReviews, hotelOnMapSupplier.thirdPartyReviews) &&
        Objects.equals(this.attractions, hotelOnMapSupplier.attractions) &&
        Objects.equals(this.recreations, hotelOnMapSupplier.recreations) &&
        Objects.equals(this.pois, hotelOnMapSupplier.pois) &&
        Objects.equals(this.restaurants, hotelOnMapSupplier.restaurants) &&
        Objects.equals(this.meetingRooms, hotelOnMapSupplier.meetingRooms) &&
        Objects.equals(this.spas, hotelOnMapSupplier.spas) &&
        Objects.equals(this.addOns, hotelOnMapSupplier.addOns) &&
        Objects.equals(this.fullNameOfGeneralManager, hotelOnMapSupplier.fullNameOfGeneralManager) &&
        Objects.equals(this.profilePictureIdentifierGeneralManager, hotelOnMapSupplier.profilePictureIdentifierGeneralManager) &&
        Objects.equals(this.messagesOfGeneralManager, hotelOnMapSupplier.messagesOfGeneralManager) &&
        Objects.equals(this.locationCategory, hotelOnMapSupplier.locationCategory) &&
        Objects.equals(this.segmentCategory, hotelOnMapSupplier.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotelOnMapSupplier.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotelOnMapSupplier.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotelOnMapSupplier.whenBuilt) &&
        Objects.equals(this.multimediaIdentifier, hotelOnMapSupplier.multimediaIdentifier) &&
        Objects.equals(this.imageIdentifier, hotelOnMapSupplier.imageIdentifier) &&
        Objects.equals(this.imageAngle, hotelOnMapSupplier.imageAngle) &&
        Objects.equals(this.videoIdentifier, hotelOnMapSupplier.videoIdentifier) &&
        Objects.equals(this.currencyCode, hotelOnMapSupplier.currencyCode) &&
        Objects.equals(this.membershipRateDiscount, hotelOnMapSupplier.membershipRateDiscount) &&
        Objects.equals(this.priceScore, hotelOnMapSupplier.priceScore) &&
        Objects.equals(this.perkScore, hotelOnMapSupplier.perkScore) &&
        Objects.equals(this.packageScore, hotelOnMapSupplier.packageScore) &&
        Objects.equals(this.loyaltyScore, hotelOnMapSupplier.loyaltyScore) &&
        Objects.equals(this.popularScore, hotelOnMapSupplier.popularScore) &&
        Objects.equals(this.experienceScore, hotelOnMapSupplier.experienceScore) &&
        Objects.equals(this.availabilityScore, hotelOnMapSupplier.availabilityScore) &&
        Objects.equals(this.views, hotelOnMapSupplier.views) &&
        Objects.equals(this.hotelAmenityCodes, hotelOnMapSupplier.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, hotelOnMapSupplier.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, hotelOnMapSupplier.propertySecurityCodes) &&
        Objects.equals(this.numberOfRooms, hotelOnMapSupplier.numberOfRooms) &&
        Objects.equals(this.address, hotelOnMapSupplier.address) &&
        Objects.equals(this.active, hotelOnMapSupplier.active) &&
        Objects.equals(this.urlParameters, hotelOnMapSupplier.urlParameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, localName, chain, brand, urlName, starRating, bookings, aggregateReviewRating, location, shortDescriptions, longDescriptions, aggregateGreendexRating, lifestyleTypes, totalReviews, available, hotelAvailable, reservations, socials, images, videos, policy, thirdPartyReviews, attractions, recreations, pois, restaurants, meetingRooms, spas, addOns, fullNameOfGeneralManager, profilePictureIdentifierGeneralManager, messagesOfGeneralManager, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, multimediaIdentifier, imageIdentifier, imageAngle, videoIdentifier, currencyCode, membershipRateDiscount, priceScore, perkScore, packageScore, loyaltyScore, popularScore, experienceScore, availabilityScore, views, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, numberOfRooms, address, active, urlParameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelOnMapSupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    aggregateReviewRating: ").append(toIndentedString(aggregateReviewRating)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    shortDescriptions: ").append(toIndentedString(shortDescriptions)).append("\n");
    sb.append("    longDescriptions: ").append(toIndentedString(longDescriptions)).append("\n");
    sb.append("    aggregateGreendexRating: ").append(toIndentedString(aggregateGreendexRating)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    totalReviews: ").append(toIndentedString(totalReviews)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    hotelAvailable: ").append(toIndentedString(hotelAvailable)).append("\n");
    sb.append("    reservations: ").append(toIndentedString(reservations)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    thirdPartyReviews: ").append(toIndentedString(thirdPartyReviews)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    recreations: ").append(toIndentedString(recreations)).append("\n");
    sb.append("    pois: ").append(toIndentedString(pois)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("    fullNameOfGeneralManager: ").append(toIndentedString(fullNameOfGeneralManager)).append("\n");
    sb.append("    profilePictureIdentifierGeneralManager: ").append(toIndentedString(profilePictureIdentifierGeneralManager)).append("\n");
    sb.append("    messagesOfGeneralManager: ").append(toIndentedString(messagesOfGeneralManager)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    imageAngle: ").append(toIndentedString(imageAngle)).append("\n");
    sb.append("    videoIdentifier: ").append(toIndentedString(videoIdentifier)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    membershipRateDiscount: ").append(toIndentedString(membershipRateDiscount)).append("\n");
    sb.append("    priceScore: ").append(toIndentedString(priceScore)).append("\n");
    sb.append("    perkScore: ").append(toIndentedString(perkScore)).append("\n");
    sb.append("    packageScore: ").append(toIndentedString(packageScore)).append("\n");
    sb.append("    loyaltyScore: ").append(toIndentedString(loyaltyScore)).append("\n");
    sb.append("    popularScore: ").append(toIndentedString(popularScore)).append("\n");
    sb.append("    experienceScore: ").append(toIndentedString(experienceScore)).append("\n");
    sb.append("    availabilityScore: ").append(toIndentedString(availabilityScore)).append("\n");
    sb.append("    views: ").append(toIndentedString(views)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    urlParameters: ").append(toIndentedString(urlParameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

