/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CountResponseSupplier;
import travel.wink.sdk.extranet.model.PageReviewViewSupplier;
import travel.wink.sdk.extranet.model.ReviewResponseSupplier;
import travel.wink.sdk.extranet.model.ReviewViewSupplier;
import travel.wink.sdk.extranet.model.StateSupplier;

public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec respondToReviewRequestCreation(String hotelIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        ReviewResponseSupplier postBody = reviewResponseSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewResponseSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewResponseSupplier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/{reviewIdentifier}/response", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewViewSupplier> respondToReview(String hotelIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>(){};
        return this.respondToReviewRequestCreation(hotelIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewViewSupplier>> respondToReviewWithHttpInfo(String hotelIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>(){};
        return this.respondToReviewRequestCreation(hotelIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec respondToReviewWithResponseSpec(String hotelIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        return this.respondToReviewRequestCreation(hotelIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showReviewRequestCreation(String hotelIdentifier, String reviewIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/{reviewIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewViewSupplier> showReview(String hotelIdentifier, String reviewIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>(){};
        return this.showReviewRequestCreation(hotelIdentifier, reviewIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewViewSupplier>> showReviewWithHttpInfo(String hotelIdentifier, String reviewIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>(){};
        return this.showReviewRequestCreation(hotelIdentifier, reviewIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showReviewWithResponseSpec(String hotelIdentifier, String reviewIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showReviewRequestCreation(hotelIdentifier, reviewIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showReviewCountRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReviewCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CountResponseSupplier> showReviewCount(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>(){};
        return this.showReviewCountRequestCreation(hotelIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponseSupplier>> showReviewCountWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>(){};
        return this.showReviewCountRequestCreation(hotelIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showReviewCountWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showReviewCountRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showReviewsRequestCreation(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/review/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageReviewViewSupplier> showReviews(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewViewSupplier>(){};
        return this.showReviewsRequestCreation(hotelIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageReviewViewSupplier>> showReviewsWithHttpInfo(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewViewSupplier>(){};
        return this.showReviewsRequestCreation(hotelIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showReviewsWithResponseSpec(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return this.showReviewsRequestCreation(hotelIdentifier, stateSupplier, winkVersion);
    }
}

