/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.VariableChargeSupplier;

@JsonPropertyOrder(value={"name", "enabled", "itemIdentifiers", "modifierOverride", "type", "pricingType"})
@JsonTypeName(value="UpsertRateModifierBundleRequest_Supplier")
public class UpsertRateModifierBundleRequestSupplier {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_ITEM_IDENTIFIERS = "itemIdentifiers";
    private List<UUID> itemIdentifiers = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
    private VariableChargeSupplier modifierOverride;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;

    public UpsertRateModifierBundleRequestSupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UpsertRateModifierBundleRequestSupplier enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UpsertRateModifierBundleRequestSupplier itemIdentifiers(List<UUID> itemIdentifiers) {
        this.itemIdentifiers = itemIdentifiers;
        return this;
    }

    public UpsertRateModifierBundleRequestSupplier addItemIdentifiersItem(UUID itemIdentifiersItem) {
        this.itemIdentifiers.add(itemIdentifiersItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=2, max=0x7FFFFFFF)
    @JsonProperty(value="itemIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=2, max=0x7FFFFFFF) List<UUID> getItemIdentifiers() {
        return this.itemIdentifiers;
    }

    @JsonProperty(value="itemIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemIdentifiers(List<UUID> itemIdentifiers) {
        this.itemIdentifiers = itemIdentifiers;
    }

    public UpsertRateModifierBundleRequestSupplier modifierOverride(VariableChargeSupplier modifierOverride) {
        this.modifierOverride = modifierOverride;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VariableChargeSupplier getModifierOverride() {
        return this.modifierOverride;
    }

    @JsonProperty(value="modifierOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModifierOverride(VariableChargeSupplier modifierOverride) {
        this.modifierOverride = modifierOverride;
    }

    public UpsertRateModifierBundleRequestSupplier type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UpsertRateModifierBundleRequestSupplier pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nullable
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier = (UpsertRateModifierBundleRequestSupplier)o;
        return Objects.equals(this.name, upsertRateModifierBundleRequestSupplier.name) && Objects.equals(this.enabled, upsertRateModifierBundleRequestSupplier.enabled) && Objects.equals(this.itemIdentifiers, upsertRateModifierBundleRequestSupplier.itemIdentifiers) && Objects.equals(this.modifierOverride, upsertRateModifierBundleRequestSupplier.modifierOverride) && Objects.equals((Object)this.type, (Object)upsertRateModifierBundleRequestSupplier.type) && Objects.equals((Object)this.pricingType, (Object)upsertRateModifierBundleRequestSupplier.pricingType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.enabled, this.itemIdentifiers, this.modifierOverride, this.type, this.pricingType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertRateModifierBundleRequestSupplier {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    itemIdentifiers: ").append(this.toIndentedString(this.itemIdentifiers)).append("\n");
        sb.append("    modifierOverride: ").append(this.toIndentedString(this.modifierOverride)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PREMIUM("PREMIUM"),
        DISCOUNT("DISCOUNT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PricingTypeEnum {
        STAY("PER_STAY"),
        DAY("PER_DAY"),
        NIGHT("PER_NIGHT"),
        USE("PER_USE"),
        HOUR("PER_HOUR"),
        PERSON("PER_PERSON"),
        PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        ADULT("PER_ADULT"),
        ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
        ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
        CHILD("PER_CHILD"),
        CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
        CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

