package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RatePlanRemovableResponseSupplier;
import travel.wink.sdk.extranet.model.RatePlanViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertRatePlanRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-06T10:49:48.675577965+07:00[Asia/Bangkok]")
public class RatePlanApi {
    private ApiClient apiClient;

    public RatePlanApi() {
        this(new ApiClient());
    }

    @Autowired
    public RatePlanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new rate plan and associate it with this hotel identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createRatePlanRequestCreation(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRatePlanRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRatePlanRequestSupplier' is set
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new rate plan and associate it with this hotel identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanViewSupplier> createRatePlan(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new rate plan and associate it with this hotel identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RatePlanViewSupplier>> createRatePlanWithHttpInfo(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new rate plan and associate it with this hotel identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createRatePlanWithResponseSpec(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }
    /**
     * Verify Removable
     * Check if a rate plan is removable. If a rate plan is associated / linked with a master rate, package or add-on, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if rate plan, owned by this hotel identifier, is removable.
     * @param ratePlanIdentifier Verify if rate plan, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return RatePlanRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removableRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removableRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a rate plan is removable. If a rate plan is associated / linked with a master rate, package or add-on, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if rate plan, owned by this hotel identifier, is removable.
     * @param ratePlanIdentifier Verify if rate plan, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return RatePlanRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanRemovableResponseSupplier> removableRatePlan(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponseSupplier>() {};
        return removableRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a rate plan is removable. If a rate plan is associated / linked with a master rate, package or add-on, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if rate plan, owned by this hotel identifier, is removable.
     * @param ratePlanIdentifier Verify if rate plan, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RatePlanRemovableResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RatePlanRemovableResponseSupplier>> removableRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanRemovableResponseSupplier>() {};
        return removableRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a rate plan is removable. If a rate plan is associated / linked with a master rate, package or add-on, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if rate plan, owned by this hotel identifier, is removable.
     * @param ratePlanIdentifier Verify if rate plan, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removableRatePlanWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        return removableRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion);
    }
    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeRatePlan(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRatePlanWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        return removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion);
    }
    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Show rate plan with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Show rate plan with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanViewSupplier> showRatePlan(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Show rate plan with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RatePlanViewSupplier>> showRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Show rate plan with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRatePlanWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        return showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion);
    }
    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of rate plans owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRatePlansRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlans", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of rate plans owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RatePlanViewSupplier> showRatePlans(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlansRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of rate plans owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RatePlanViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RatePlanViewSupplier>>> showRatePlansWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlansRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of rate plans owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRatePlansWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showRatePlansRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRatePlanRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRatePlanRequestSupplier' is set
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanViewSupplier> updateRatePlan(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RatePlanViewSupplier>> updateRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing rate plan owned by this hotel identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRatePlanWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }
}
