package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.InventoryUpdateRequestSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.SalesChannelCreateRequestSupplier;
import travel.wink.sdk.extranet.model.SalesChannelSupplier;
import travel.wink.sdk.extranet.model.SalesChannelUpdateRequestSupplier;
import travel.wink.sdk.extranet.model.SelectableKeyValuePairSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-06T10:49:48.675577965+07:00[Asia/Bangkok]")
public class SalesChannelsApi {
    private ApiClient apiClient;

    public SalesChannelsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create sales channel
     * Create a new sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel and associate it with this hotel identifier
     * @param salesChannelCreateRequestSupplier The salesChannelCreateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSalesChannelRequestCreation(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = salesChannelCreateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelCreateRequestSupplier' is set
        if (salesChannelCreateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelCreateRequestSupplier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create sales channel
     * Create a new sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel and associate it with this hotel identifier
     * @param salesChannelCreateRequestSupplier The salesChannelCreateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannelSupplier> createSalesChannel(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create sales channel
     * Create a new sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel and associate it with this hotel identifier
     * @param salesChannelCreateRequestSupplier The salesChannelCreateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SalesChannelSupplier>> createSalesChannelWithHttpInfo(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create sales channel
     * Create a new sales channel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel and associate it with this hotel identifier
     * @param salesChannelCreateRequestSupplier The salesChannelCreateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSalesChannelWithResponseSpec(String hotelIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createSalesChannelRequestCreation(hotelIdentifier, salesChannelCreateRequestSupplier, winkVersion);
    }
    /**
     * Remove sales channel
     * Delete a specific sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Remove sales channel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove sales channel
     * Delete a specific sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Remove sales channel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Remove sales channel
     * Delete a specific sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Remove sales channel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Remove sales channel
     * Delete a specific sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Remove sales channel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSalesChannelWithResponseSpec(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        return removeSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion);
    }
    /**
     * Show sales channels
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channels for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAccountsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAccounts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show sales channels
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channels for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannelSupplier> showAccounts(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return showAccountsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show sales channels
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channels for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SalesChannelSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SalesChannelSupplier>>> showAccountsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return showAccountsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show sales channels
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channels for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAccountsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showAccountsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Show sales channel
     * Retrieve a specific sales channel by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Show sales channel with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show sales channel
     * Retrieve a specific sales channel by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Show sales channel with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannelSupplier> showSalesChannel(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show sales channel
     * Retrieve a specific sales channel by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Show sales channel with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SalesChannelSupplier>> showSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show sales channel
     * Retrieve a specific sales channel by identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Show sales channel with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSalesChannelWithResponseSpec(String hotelIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        return showSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, winkVersion);
    }
    /**
     * Show rate modifier bundle availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifier bundles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierBundleIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SelectableKeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelContextRateModifierBundlePairsRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierBundleIdentifier' is set
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show rate modifier bundle availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifier bundles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierBundleIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SelectableKeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierBundlePairs(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>() {};
        return showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show rate modifier bundle availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifier bundles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierBundleIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SelectableKeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierBundlePairsWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>() {};
        return showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show rate modifier bundle availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifier bundles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierBundleIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSalesChannelContextRateModifierBundlePairsWithResponseSpec(String hotelIdentifier, String rateModifierBundleIdentifier, String winkVersion) throws WebClientResponseException {
        return showSalesChannelContextRateModifierBundlePairsRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, winkVersion);
    }
    /**
     * Show rate modifier availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifiers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SelectableKeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelContextRateModifierPairsRequestCreation(String hotelIdentifier, String rateModifierIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierIdentifier' is set
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show rate modifier availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifiers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SelectableKeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierPairs(String hotelIdentifier, String rateModifierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>() {};
        return showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show rate modifier availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifiers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SelectableKeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierPairsWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>() {};
        return showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show rate modifier availability
     * Display a list of key / value pairs that shows the availability of sales channels in the context of rate modifiers.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel pairs for this hotel identifier
     * @param rateModifierIdentifier Show all sales channels pairs in the context of rate modifier availability
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSalesChannelContextRateModifierPairsWithResponseSpec(String hotelIdentifier, String rateModifierIdentifier, String winkVersion) throws WebClientResponseException {
        return showSalesChannelContextRateModifierPairsRequestCreation(hotelIdentifier, rateModifierIdentifier, winkVersion);
    }
    /**
     * Update sale channels promos
     * Toggles availability of a promo for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierIdentifier The rate modifier we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec toggleSalesChannelPromoAvailabilityRequestCreation(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = inventoryUpdateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierIdentifier' is set
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryUpdateRequestSupplier' is set
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promo/{rateModifierIdentifier}/list", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update sale channels promos
     * Toggles availability of a promo for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierIdentifier The rate modifier we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannelSupplier> toggleSalesChannelPromoAvailability(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Update sale channels promos
     * Toggles availability of a promo for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierIdentifier The rate modifier we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SalesChannelSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Update sale channels promos
     * Toggles availability of a promo for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierIdentifier The rate modifier we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec toggleSalesChannelPromoAvailabilityWithResponseSpec(String hotelIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return toggleSalesChannelPromoAvailabilityRequestCreation(hotelIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }
    /**
     * Update sale channels promo bundles
     * Toggles availability of a promo bundle for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierBundleIdentifier The rate modifier bundle we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec toggleSalesChannelPromoBundleAvailabilityRequestCreation(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = inventoryUpdateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierBundleIdentifier' is set
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryUpdateRequestSupplier' is set
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/promobundle/{rateModifierBundleIdentifier}/list", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update sale channels promo bundles
     * Toggles availability of a promo bundle for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierBundleIdentifier The rate modifier bundle we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannelSupplier> toggleSalesChannelPromoBundleAvailability(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Update sale channels promo bundles
     * Toggles availability of a promo bundle for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierBundleIdentifier The rate modifier bundle we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SalesChannelSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoBundleAvailabilityWithHttpInfo(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Update sale channels promo bundles
     * Toggles availability of a promo bundle for a list of sales channels
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param rateModifierBundleIdentifier The rate modifier bundle we are enabling / disabling on the sales channel
     * @param inventoryUpdateRequestSupplier The inventoryUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec toggleSalesChannelPromoBundleAvailabilityWithResponseSpec(String hotelIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return toggleSalesChannelPromoBundleAvailabilityRequestCreation(hotelIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }
    /**
     * Update sales channel
     * Update a chosen sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Update sales channel settings for sales channel with this identifier
     * @param salesChannelUpdateRequestSupplier The salesChannelUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSalesChannelRequestCreation(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = salesChannelUpdateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelUpdateRequestSupplier' is set
        if (salesChannelUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelUpdateRequestSupplier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update sales channel
     * Update a chosen sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Update sales channel settings for sales channel with this identifier
     * @param salesChannelUpdateRequestSupplier The salesChannelUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannelSupplier> updateSalesChannel(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update sales channel
     * Update a chosen sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Update sales channel settings for sales channel with this identifier
     * @param salesChannelUpdateRequestSupplier The salesChannelUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SalesChannelSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SalesChannelSupplier>> updateSalesChannelWithHttpInfo(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>() {};
        return updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update sales channel
     * Update a chosen sales channel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update sales channel owned by this hotel identifier
     * @param salesChannelIdentifier Update sales channel settings for sales channel with this identifier
     * @param salesChannelUpdateRequestSupplier The salesChannelUpdateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSalesChannelWithResponseSpec(String hotelIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateSalesChannelRequestCreation(hotelIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion);
    }
}
