/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.11.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.Address;
import travel.wink.sdk.extranet.model.BedroomConfiguration;
import travel.wink.sdk.extranet.model.Contact;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.GeoJsonPoint;
import travel.wink.sdk.extranet.model.SimpleDescription;
import travel.wink.sdk.extranet.model.SimpleMultimedia;
import travel.wink.sdk.extranet.model.Social;
import travel.wink.sdk.extranet.model.TransactionalTravelInventory;
import travel.wink.sdk.extranet.model.TravelInventoryRecognition;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Contains room type data
 */
@JsonPropertyOrder({
  GuestRoom.JSON_PROPERTY_IDENTIFIER,
  GuestRoom.JSON_PROPERTY_HOTEL_IDENTIFIER,
  GuestRoom.JSON_PROPERTY_FEATURED_IND,
  GuestRoom.JSON_PROPERTY_LIFESTYLE_TYPE,
  GuestRoom.JSON_PROPERTY_LOCATION,
  GuestRoom.JSON_PROPERTY_DESCRIPTIONS,
  GuestRoom.JSON_PROPERTY_MULTIMEDIAS,
  GuestRoom.JSON_PROPERTY_CONTACT,
  GuestRoom.JSON_PROPERTY_ADDRESS,
  GuestRoom.JSON_PROPERTY_COMMISSIONABLE,
  GuestRoom.JSON_PROPERTY_NAME,
  GuestRoom.JSON_PROPERTY_PROXIMITY_CODE,
  GuestRoom.JSON_PROPERTY_SORT,
  GuestRoom.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  GuestRoom.JSON_PROPERTY_BOOKABLE,
  GuestRoom.JSON_PROPERTY_ACTIVE,
  GuestRoom.JSON_PROPERTY_DISABILITY_FEATURES,
  GuestRoom.JSON_PROPERTY_SECURITY_FEATURES,
  GuestRoom.JSON_PROPERTY_SOCIALS,
  GuestRoom.JSON_PROPERTY_PRICE_POINT,
  GuestRoom.JSON_PROPERTY_RECOGNITION_LIST,
  GuestRoom.JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST,
  GuestRoom.JSON_PROPERTY_MAX_OCCUPANCY,
  GuestRoom.JSON_PROPERTY_MIN_OCCUPANCY,
  GuestRoom.JSON_PROPERTY_QUANTITY,
  GuestRoom.JSON_PROPERTY_NON_SMOKING,
  GuestRoom.JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST,
  GuestRoom.JSON_PROPERTY_SIZE,
  GuestRoom.JSON_PROPERTY_MAX_ADULT_OCCUPANCY,
  GuestRoom.JSON_PROPERTY_MAX_CHILD_OCCUPANCY,
  GuestRoom.JSON_PROPERTY_BATHROOM_COUNT,
  GuestRoom.JSON_PROPERTY_LIVING_ROOM_COUNT,
  GuestRoom.JSON_PROPERTY_MAX_ROLLAWAYS,
  GuestRoom.JSON_PROPERTY_ROOM_CATEGORY,
  GuestRoom.JSON_PROPERTY_FLOOR,
  GuestRoom.JSON_PROPERTY_ROOM_LOCATION_CODE,
  GuestRoom.JSON_PROPERTY_ROOM_VIEW_CODE,
  GuestRoom.JSON_PROPERTY_COMPOSITE,
  GuestRoom.JSON_PROPERTY_COMPOSITE_COUNT,
  GuestRoom.JSON_PROPERTY_ROOM_CLASSIFICATION_CODE,
  GuestRoom.JSON_PROPERTY_ROOM_ARCHITECTURE_CODE,
  GuestRoom.JSON_PROPERTY_ROOM_GENDER,
  GuestRoom.JSON_PROPERTY_SHARED_ROOM_IND,
  GuestRoom.JSON_PROPERTY_MAX_CRIBS,
  GuestRoom.JSON_PROPERTY_AMENITIES,
  GuestRoom.JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY,
  GuestRoom.JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY,
  GuestRoom.JSON_PROPERTY_BASE_RATE,
  GuestRoom.JSON_PROPERTY_MIN_RATE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-06T10:49:48.675577965+07:00[Asia/Bangkok]")
public class GuestRoom {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPoint location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimedia> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private Contact contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<Social> socials;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognition> recognitionList;

  public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
  private List<TransactionalTravelInventory> transactionalInventoryList;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy = 2;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy = 1;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
  private Boolean nonSmoking;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
  private List<BedroomConfiguration> bedroomConfigurationList = new ArrayList<>();

  public static final String JSON_PROPERTY_SIZE = "size";
  private Float size;

  public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
  private Integer maxAdultOccupancy = 2;

  public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
  private Integer maxChildOccupancy = 0;

  public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
  private Integer bathroomCount = 1;

  public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
  private Integer livingRoomCount = 1;

  public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
  private Integer maxRollaways = 0;

  public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
  private String roomCategory;

  public static final String JSON_PROPERTY_FLOOR = "floor";
  private String floor;

  public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
  private String roomLocationCode;

  public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
  private String roomViewCode;

  public static final String JSON_PROPERTY_COMPOSITE = "composite";
  private Boolean composite = false;

  public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
  private Integer compositeCount = 0;

  public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
  private String roomClassificationCode;

  public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
  private String roomArchitectureCode;

  /**
   * Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.
   */
  public enum RoomGenderEnum {
    MALE("Male"),
    
    FEMALE("Female"),
    
    MALEANDFEMALE("MaleAndFemale"),
    
    UNKNOWN("Unknown");

    private String value;

    RoomGenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RoomGenderEnum fromValue(String value) {
      for (RoomGenderEnum b : RoomGenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
  private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;

  public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
  private Boolean sharedRoomInd = false;

  public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
  private Integer maxCribs = 0;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities;

  public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
  private Integer includedAdultOccupancy = 2;

  public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
  private Integer includedChildOccupancy = 0;

  public static final String JSON_PROPERTY_BASE_RATE = "baseRate";
  private CustomMonetaryAmount baseRate;

  public static final String JSON_PROPERTY_MIN_RATE = "minRate";
  private CustomMonetaryAmount minRate;

  public GuestRoom() {
  }

  public GuestRoom identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public GuestRoom hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public GuestRoom featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public GuestRoom lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public GuestRoom location(GeoJsonPoint location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPoint getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPoint location) {
    this.location = location;
  }


  public GuestRoom descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public GuestRoom addDescriptionsItem(SimpleDescription descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public GuestRoom multimedias(List<SimpleMultimedia> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public GuestRoom addMultimediasItem(SimpleMultimedia multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimedia> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimedia> multimedias) {
    this.multimedias = multimedias;
  }


  public GuestRoom contact(Contact contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Contact getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(Contact contact) {
    this.contact = contact;
  }


  public GuestRoom address(Address address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Address getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public GuestRoom commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public GuestRoom name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public GuestRoom proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public GuestRoom sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public GuestRoom minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public GuestRoom bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public GuestRoom active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public GuestRoom disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public GuestRoom addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public GuestRoom securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public GuestRoom addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public GuestRoom socials(List<Social> socials) {
    
    this.socials = socials;
    return this;
  }

  public GuestRoom addSocialsItem(Social socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Social> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<Social> socials) {
    this.socials = socials;
  }


  public GuestRoom pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public GuestRoom recognitionList(List<TravelInventoryRecognition> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public GuestRoom addRecognitionListItem(TravelInventoryRecognition recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognition> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognition> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public GuestRoom transactionalInventoryList(List<TransactionalTravelInventory> transactionalInventoryList) {
    
    this.transactionalInventoryList = transactionalInventoryList;
    return this;
  }

  public GuestRoom addTransactionalInventoryListItem(TransactionalTravelInventory transactionalInventoryListItem) {
    if (this.transactionalInventoryList == null) {
      this.transactionalInventoryList = new ArrayList<>();
    }
    this.transactionalInventoryList.add(transactionalInventoryListItem);
    return this;
  }

   /**
   * Purchasable items for this inventory.
   * @return transactionalInventoryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionalTravelInventory> getTransactionalInventoryList() {
    return transactionalInventoryList;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionalInventoryList(List<TransactionalTravelInventory> transactionalInventoryList) {
    this.transactionalInventoryList = transactionalInventoryList;
  }


  public GuestRoom maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Maximum number of guest allowed in a room type.
   * minimum: 1
   * @return maxOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public GuestRoom minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Minimum number of guests allowed in a room type.
   * minimum: 1
   * @return minOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public GuestRoom quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Defines the number of rooms of this type
   * minimum: 1
   * @return quantity
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public GuestRoom nonSmoking(Boolean nonSmoking) {
    
    this.nonSmoking = nonSmoking;
    return this;
  }

   /**
   * Non-smoking indicator
   * @return nonSmoking
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NON_SMOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getNonSmoking() {
    return nonSmoking;
  }


  @JsonProperty(JSON_PROPERTY_NON_SMOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNonSmoking(Boolean nonSmoking) {
    this.nonSmoking = nonSmoking;
  }


  public GuestRoom bedroomConfigurationList(List<BedroomConfiguration> bedroomConfigurationList) {
    
    this.bedroomConfigurationList = bedroomConfigurationList;
    return this;
  }

  public GuestRoom addBedroomConfigurationListItem(BedroomConfiguration bedroomConfigurationListItem) {
    if (this.bedroomConfigurationList == null) {
      this.bedroomConfigurationList = new ArrayList<>();
    }
    this.bedroomConfigurationList.add(bedroomConfigurationListItem);
    return this;
  }

   /**
   * A room type can have more than one bed configuration.
   * @return bedroomConfigurationList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BedroomConfiguration> getBedroomConfigurationList() {
    return bedroomConfigurationList;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBedroomConfigurationList(List<BedroomConfiguration> bedroomConfigurationList) {
    this.bedroomConfigurationList = bedroomConfigurationList;
  }


  public GuestRoom size(Float size) {
    
    this.size = size;
    return this;
  }

   /**
   * Number of square meters that defines the size of this room type.
   * minimum: 1
   * @return size
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSize(Float size) {
    this.size = size;
  }


  public GuestRoom maxAdultOccupancy(Integer maxAdultOccupancy) {
    
    this.maxAdultOccupancy = maxAdultOccupancy;
    return this;
  }

   /**
   * Maximum number of adults allowed in a room type.
   * minimum: 1
   * @return maxAdultOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxAdultOccupancy() {
    return maxAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
    this.maxAdultOccupancy = maxAdultOccupancy;
  }


  public GuestRoom maxChildOccupancy(Integer maxChildOccupancy) {
    
    this.maxChildOccupancy = maxChildOccupancy;
    return this;
  }

   /**
   * Maximum number of children allowed in a room type.
   * minimum: 0
   * @return maxChildOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxChildOccupancy() {
    return maxChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxChildOccupancy(Integer maxChildOccupancy) {
    this.maxChildOccupancy = maxChildOccupancy;
  }


  public GuestRoom bathroomCount(Integer bathroomCount) {
    
    this.bathroomCount = bathroomCount;
    return this;
  }

   /**
   * Number of bathrooms
   * minimum: 0
   * @return bathroomCount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_BATHROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getBathroomCount() {
    return bathroomCount;
  }


  @JsonProperty(JSON_PROPERTY_BATHROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBathroomCount(Integer bathroomCount) {
    this.bathroomCount = bathroomCount;
  }


  public GuestRoom livingRoomCount(Integer livingRoomCount) {
    
    this.livingRoomCount = livingRoomCount;
    return this;
  }

   /**
   * Number of living rooms
   * minimum: 0
   * @return livingRoomCount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_LIVING_ROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getLivingRoomCount() {
    return livingRoomCount;
  }


  @JsonProperty(JSON_PROPERTY_LIVING_ROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLivingRoomCount(Integer livingRoomCount) {
    this.livingRoomCount = livingRoomCount;
  }


  public GuestRoom maxRollaways(Integer maxRollaways) {
    
    this.maxRollaways = maxRollaways;
    return this;
  }

   /**
   * Maximum number of rollaway beds allowed in this room type.
   * minimum: 0
   * @return maxRollaways
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MAX_ROLLAWAYS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxRollaways() {
    return maxRollaways;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ROLLAWAYS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxRollaways(Integer maxRollaways) {
    this.maxRollaways = maxRollaways;
  }


  public GuestRoom roomCategory(String roomCategory) {
    
    this.roomCategory = roomCategory;
    return this;
  }

   /**
   * Indicates the category of the room. Typical values would be Moderate, Standard, or Deluxe. Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomCategory() {
    return roomCategory;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomCategory(String roomCategory) {
    this.roomCategory = roomCategory;
  }


  public GuestRoom floor(String floor) {
    
    this.floor = floor;
    return this;
  }

   /**
   * Floor an which a room is located
   * @return floor
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FLOOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFloor() {
    return floor;
  }


  @JsonProperty(JSON_PROPERTY_FLOOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFloor(String floor) {
    this.floor = floor;
  }


  public GuestRoom roomLocationCode(String roomLocationCode) {
    
    this.roomLocationCode = roomLocationCode;
    return this;
  }

   /**
   * Indicates the location of the room within the hotel structure. Typical values would be \&quot;Near Exit\&quot;,\&quot;Close to elevator\&quot;, \&quot;Low Floor\&quot; or \&quot;High Floor\&quot;. Supported OTA specification &#x60;RLT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomLocationCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomLocationCode() {
    return roomLocationCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomLocationCode(String roomLocationCode) {
    this.roomLocationCode = roomLocationCode;
  }


  public GuestRoom roomViewCode(String roomViewCode) {
    
    this.roomViewCode = roomViewCode;
    return this;
  }

   /**
   * Indicates the view of the room. Typical values would be \&quot;Ocean view\&quot;, \&quot;Pool view\&quot; or \&quot;Garden View\&quot;. Supported OTA specification &#x60;RVT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomViewCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_VIEW_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomViewCode() {
    return roomViewCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_VIEW_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomViewCode(String roomViewCode) {
    this.roomViewCode = roomViewCode;
  }


  public GuestRoom composite(Boolean composite) {
    
    this.composite = composite;
    return this;
  }

   /**
   * Indicates that the room (suite) is a composite of smaller units.
   * @return composite
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMPOSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getComposite() {
    return composite;
  }


  @JsonProperty(JSON_PROPERTY_COMPOSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setComposite(Boolean composite) {
    this.composite = composite;
  }


  public GuestRoom compositeCount(Integer compositeCount) {
    
    this.compositeCount = compositeCount;
    return this;
  }

   /**
   * Number of rooms of this room type that makes up a larger unit (composite) such as a two bedroom suite could be comprised of two king rooms plus other room types. A 0 means disabled.
   * minimum: 0
   * @return compositeCount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_COMPOSITE_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getCompositeCount() {
    return compositeCount;
  }


  @JsonProperty(JSON_PROPERTY_COMPOSITE_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompositeCount(Integer compositeCount) {
    this.compositeCount = compositeCount;
  }


  public GuestRoom roomClassificationCode(String roomClassificationCode) {
    
    this.roomClassificationCode = roomClassificationCode;
    return this;
  }

   /**
   * Specifies the room classification (e.g., cabin, apartment). Supported OTA specification &#x60;GRI&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomClassificationCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_CLASSIFICATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomClassificationCode() {
    return roomClassificationCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CLASSIFICATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomClassificationCode(String roomClassificationCode) {
    this.roomClassificationCode = roomClassificationCode;
  }


  public GuestRoom roomArchitectureCode(String roomArchitectureCode) {
    
    this.roomArchitectureCode = roomArchitectureCode;
    return this;
  }

   /**
   * Specifies the architectural style of a room. Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomArchitectureCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_ARCHITECTURE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomArchitectureCode() {
    return roomArchitectureCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_ARCHITECTURE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomArchitectureCode(String roomArchitectureCode) {
    this.roomArchitectureCode = roomArchitectureCode;
  }


  public GuestRoom roomGender(RoomGenderEnum roomGender) {
    
    this.roomGender = roomGender;
    return this;
  }

   /**
   * Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.
   * @return roomGender
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomGenderEnum getRoomGender() {
    return roomGender;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomGender(RoomGenderEnum roomGender) {
    this.roomGender = roomGender;
  }


  public GuestRoom sharedRoomInd(Boolean sharedRoomInd) {
    
    this.sharedRoomInd = sharedRoomInd;
    return this;
  }

   /**
   * If TRUE, the room requires or has sharing available. Note: Typically used by Hosteliers.
   * @return sharedRoomInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SHARED_ROOM_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getSharedRoomInd() {
    return sharedRoomInd;
  }


  @JsonProperty(JSON_PROPERTY_SHARED_ROOM_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSharedRoomInd(Boolean sharedRoomInd) {
    this.sharedRoomInd = sharedRoomInd;
  }


  public GuestRoom maxCribs(Integer maxCribs) {
    
    this.maxCribs = maxCribs;
    return this;
  }

   /**
   * Maximum number of cribs allowed in a room type.
   * minimum: 0
   * @return maxCribs
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MAX_CRIBS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxCribs() {
    return maxCribs;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CRIBS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxCribs(Integer maxCribs) {
    this.maxCribs = maxCribs;
  }


  public GuestRoom amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public GuestRoom addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * Collection of room amenity items available to the guest. Supported OTA specification &#x60;RMA&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return amenities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }


  public GuestRoom includedAdultOccupancy(Integer includedAdultOccupancy) {
    
    this.includedAdultOccupancy = includedAdultOccupancy;
    return this;
  }

   /**
   * The number of pax the room price was meant for
   * minimum: 0
   * @return includedAdultOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedAdultOccupancy() {
    return includedAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
    this.includedAdultOccupancy = includedAdultOccupancy;
  }


  public GuestRoom includedChildOccupancy(Integer includedChildOccupancy) {
    
    this.includedChildOccupancy = includedChildOccupancy;
    return this;
  }

   /**
   * The number of children the room price was meant for
   * minimum: 0
   * @return includedChildOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedChildOccupancy() {
    return includedChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
    this.includedChildOccupancy = includedChildOccupancy;
  }


  public GuestRoom baseRate(CustomMonetaryAmount baseRate) {
    
    this.baseRate = baseRate;
    return this;
  }

   /**
   * Get baseRate
   * @return baseRate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getBaseRate() {
    return baseRate;
  }


  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBaseRate(CustomMonetaryAmount baseRate) {
    this.baseRate = baseRate;
  }


  public GuestRoom minRate(CustomMonetaryAmount minRate) {
    
    this.minRate = minRate;
    return this;
  }

   /**
   * Get minRate
   * @return minRate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getMinRate() {
    return minRate;
  }


  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMinRate(CustomMonetaryAmount minRate) {
    this.minRate = minRate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GuestRoom guestRoom = (GuestRoom) o;
    return Objects.equals(this.identifier, guestRoom.identifier) &&
        Objects.equals(this.hotelIdentifier, guestRoom.hotelIdentifier) &&
        Objects.equals(this.featuredInd, guestRoom.featuredInd) &&
        Objects.equals(this.lifestyleType, guestRoom.lifestyleType) &&
        Objects.equals(this.location, guestRoom.location) &&
        Objects.equals(this.descriptions, guestRoom.descriptions) &&
        Objects.equals(this.multimedias, guestRoom.multimedias) &&
        Objects.equals(this.contact, guestRoom.contact) &&
        Objects.equals(this.address, guestRoom.address) &&
        Objects.equals(this.commissionable, guestRoom.commissionable) &&
        Objects.equals(this.name, guestRoom.name) &&
        Objects.equals(this.proximityCode, guestRoom.proximityCode) &&
        Objects.equals(this.sort, guestRoom.sort) &&
        Objects.equals(this.minAgeAppropriateCode, guestRoom.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, guestRoom.bookable) &&
        Objects.equals(this.active, guestRoom.active) &&
        Objects.equals(this.disabilityFeatures, guestRoom.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, guestRoom.securityFeatures) &&
        Objects.equals(this.socials, guestRoom.socials) &&
        Objects.equals(this.pricePoint, guestRoom.pricePoint) &&
        Objects.equals(this.recognitionList, guestRoom.recognitionList) &&
        Objects.equals(this.transactionalInventoryList, guestRoom.transactionalInventoryList) &&
        Objects.equals(this.maxOccupancy, guestRoom.maxOccupancy) &&
        Objects.equals(this.minOccupancy, guestRoom.minOccupancy) &&
        Objects.equals(this.quantity, guestRoom.quantity) &&
        Objects.equals(this.nonSmoking, guestRoom.nonSmoking) &&
        Objects.equals(this.bedroomConfigurationList, guestRoom.bedroomConfigurationList) &&
        Objects.equals(this.size, guestRoom.size) &&
        Objects.equals(this.maxAdultOccupancy, guestRoom.maxAdultOccupancy) &&
        Objects.equals(this.maxChildOccupancy, guestRoom.maxChildOccupancy) &&
        Objects.equals(this.bathroomCount, guestRoom.bathroomCount) &&
        Objects.equals(this.livingRoomCount, guestRoom.livingRoomCount) &&
        Objects.equals(this.maxRollaways, guestRoom.maxRollaways) &&
        Objects.equals(this.roomCategory, guestRoom.roomCategory) &&
        Objects.equals(this.floor, guestRoom.floor) &&
        Objects.equals(this.roomLocationCode, guestRoom.roomLocationCode) &&
        Objects.equals(this.roomViewCode, guestRoom.roomViewCode) &&
        Objects.equals(this.composite, guestRoom.composite) &&
        Objects.equals(this.compositeCount, guestRoom.compositeCount) &&
        Objects.equals(this.roomClassificationCode, guestRoom.roomClassificationCode) &&
        Objects.equals(this.roomArchitectureCode, guestRoom.roomArchitectureCode) &&
        Objects.equals(this.roomGender, guestRoom.roomGender) &&
        Objects.equals(this.sharedRoomInd, guestRoom.sharedRoomInd) &&
        Objects.equals(this.maxCribs, guestRoom.maxCribs) &&
        Objects.equals(this.amenities, guestRoom.amenities) &&
        Objects.equals(this.includedAdultOccupancy, guestRoom.includedAdultOccupancy) &&
        Objects.equals(this.includedChildOccupancy, guestRoom.includedChildOccupancy) &&
        Objects.equals(this.baseRate, guestRoom.baseRate) &&
        Objects.equals(this.minRate, guestRoom.minRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, transactionalInventoryList, maxOccupancy, minOccupancy, quantity, nonSmoking, bedroomConfigurationList, size, maxAdultOccupancy, maxChildOccupancy, bathroomCount, livingRoomCount, maxRollaways, roomCategory, floor, roomLocationCode, roomViewCode, composite, compositeCount, roomClassificationCode, roomArchitectureCode, roomGender, sharedRoomInd, maxCribs, amenities, includedAdultOccupancy, includedChildOccupancy, baseRate, minRate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GuestRoom {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    transactionalInventoryList: ").append(toIndentedString(transactionalInventoryList)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    nonSmoking: ").append(toIndentedString(nonSmoking)).append("\n");
    sb.append("    bedroomConfigurationList: ").append(toIndentedString(bedroomConfigurationList)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    maxAdultOccupancy: ").append(toIndentedString(maxAdultOccupancy)).append("\n");
    sb.append("    maxChildOccupancy: ").append(toIndentedString(maxChildOccupancy)).append("\n");
    sb.append("    bathroomCount: ").append(toIndentedString(bathroomCount)).append("\n");
    sb.append("    livingRoomCount: ").append(toIndentedString(livingRoomCount)).append("\n");
    sb.append("    maxRollaways: ").append(toIndentedString(maxRollaways)).append("\n");
    sb.append("    roomCategory: ").append(toIndentedString(roomCategory)).append("\n");
    sb.append("    floor: ").append(toIndentedString(floor)).append("\n");
    sb.append("    roomLocationCode: ").append(toIndentedString(roomLocationCode)).append("\n");
    sb.append("    roomViewCode: ").append(toIndentedString(roomViewCode)).append("\n");
    sb.append("    composite: ").append(toIndentedString(composite)).append("\n");
    sb.append("    compositeCount: ").append(toIndentedString(compositeCount)).append("\n");
    sb.append("    roomClassificationCode: ").append(toIndentedString(roomClassificationCode)).append("\n");
    sb.append("    roomArchitectureCode: ").append(toIndentedString(roomArchitectureCode)).append("\n");
    sb.append("    roomGender: ").append(toIndentedString(roomGender)).append("\n");
    sb.append("    sharedRoomInd: ").append(toIndentedString(sharedRoomInd)).append("\n");
    sb.append("    maxCribs: ").append(toIndentedString(maxCribs)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("    includedAdultOccupancy: ").append(toIndentedString(includedAdultOccupancy)).append("\n");
    sb.append("    includedChildOccupancy: ").append(toIndentedString(includedChildOccupancy)).append("\n");
    sb.append("    baseRate: ").append(toIndentedString(baseRate)).append("\n");
    sb.append("    minRate: ").append(toIndentedString(minRate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

