/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.11.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AddressSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.DowPatternGroupSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.model.SocialSupplier;
import travel.wink.sdk.extranet.model.TransactionalTravelInventorySupplier;
import travel.wink.sdk.extranet.model.TravelInventoryRecognitionSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Restaurant data
 */
@JsonPropertyOrder({
  RestaurantSupplier.JSON_PROPERTY_IDENTIFIER,
  RestaurantSupplier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RestaurantSupplier.JSON_PROPERTY_FEATURED_IND,
  RestaurantSupplier.JSON_PROPERTY_LIFESTYLE_TYPE,
  RestaurantSupplier.JSON_PROPERTY_LOCATION,
  RestaurantSupplier.JSON_PROPERTY_DESCRIPTIONS,
  RestaurantSupplier.JSON_PROPERTY_MULTIMEDIAS,
  RestaurantSupplier.JSON_PROPERTY_CONTACT,
  RestaurantSupplier.JSON_PROPERTY_ADDRESS,
  RestaurantSupplier.JSON_PROPERTY_COMMISSIONABLE,
  RestaurantSupplier.JSON_PROPERTY_NAME,
  RestaurantSupplier.JSON_PROPERTY_PROXIMITY_CODE,
  RestaurantSupplier.JSON_PROPERTY_SORT,
  RestaurantSupplier.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  RestaurantSupplier.JSON_PROPERTY_BOOKABLE,
  RestaurantSupplier.JSON_PROPERTY_ACTIVE,
  RestaurantSupplier.JSON_PROPERTY_DISABILITY_FEATURES,
  RestaurantSupplier.JSON_PROPERTY_SECURITY_FEATURES,
  RestaurantSupplier.JSON_PROPERTY_SOCIALS,
  RestaurantSupplier.JSON_PROPERTY_PRICE_POINT,
  RestaurantSupplier.JSON_PROPERTY_RECOGNITION_LIST,
  RestaurantSupplier.JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST,
  RestaurantSupplier.JSON_PROPERTY_APPLICABLE_START,
  RestaurantSupplier.JSON_PROPERTY_APPLICABLE_END,
  RestaurantSupplier.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  RestaurantSupplier.JSON_PROPERTY_OPENS,
  RestaurantSupplier.JSON_PROPERTY_CLOSES,
  RestaurantSupplier.JSON_PROPERTY_DAYS_OF_WEEK,
  RestaurantSupplier.JSON_PROPERTY_MAX_SEATING_CAPACITY,
  RestaurantSupplier.JSON_PROPERTY_MAX_SINGLE_PARTY,
  RestaurantSupplier.JSON_PROPERTY_OFFER_BREAKFAST,
  RestaurantSupplier.JSON_PROPERTY_OFFER_LUNCH,
  RestaurantSupplier.JSON_PROPERTY_OFFER_DINNER,
  RestaurantSupplier.JSON_PROPERTY_OFFER_BRUNCH,
  RestaurantSupplier.JSON_PROPERTY_AMENITIES,
  RestaurantSupplier.JSON_PROPERTY_INFO_CODES,
  RestaurantSupplier.JSON_PROPERTY_CUISINE_CODES
})
@JsonTypeName("Restaurant_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-06T10:49:48.675577965+07:00[Asia/Bangkok]")
public class RestaurantSupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointSupplier location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionSupplier> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaSupplier> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactSupplier contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplier address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialSupplier> socials;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionSupplier> recognitionList;

  public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
  private List<TransactionalTravelInventorySupplier> transactionalInventoryList;

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  private String closes;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  private DowPatternGroupSupplier daysOfWeek;

  public static final String JSON_PROPERTY_MAX_SEATING_CAPACITY = "maxSeatingCapacity";
  private Integer maxSeatingCapacity;

  public static final String JSON_PROPERTY_MAX_SINGLE_PARTY = "maxSingleParty";
  private Integer maxSingleParty;

  public static final String JSON_PROPERTY_OFFER_BREAKFAST = "offerBreakfast";
  private Boolean offerBreakfast = false;

  public static final String JSON_PROPERTY_OFFER_LUNCH = "offerLunch";
  private Boolean offerLunch = false;

  public static final String JSON_PROPERTY_OFFER_DINNER = "offerDinner";
  private Boolean offerDinner = false;

  public static final String JSON_PROPERTY_OFFER_BRUNCH = "offerBrunch";
  private Boolean offerBrunch = false;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities;

  public static final String JSON_PROPERTY_INFO_CODES = "infoCodes";
  private List<String> infoCodes;

  public static final String JSON_PROPERTY_CUISINE_CODES = "cuisineCodes";
  private List<String> cuisineCodes;

  public RestaurantSupplier() {
  }

  public RestaurantSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RestaurantSupplier hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RestaurantSupplier featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public RestaurantSupplier lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public RestaurantSupplier location(GeoJsonPointSupplier location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointSupplier getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointSupplier location) {
    this.location = location;
  }


  public RestaurantSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public RestaurantSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionSupplier> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
    this.descriptions = descriptions;
  }


  public RestaurantSupplier multimedias(List<SimpleMultimediaSupplier> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public RestaurantSupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaSupplier> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaSupplier> multimedias) {
    this.multimedias = multimedias;
  }


  public RestaurantSupplier contact(ContactSupplier contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactSupplier getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactSupplier contact) {
    this.contact = contact;
  }


  public RestaurantSupplier address(AddressSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressSupplier address) {
    this.address = address;
  }


  public RestaurantSupplier commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public RestaurantSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RestaurantSupplier proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public RestaurantSupplier sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public RestaurantSupplier minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public RestaurantSupplier bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public RestaurantSupplier active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public RestaurantSupplier disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public RestaurantSupplier addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public RestaurantSupplier securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public RestaurantSupplier addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public RestaurantSupplier socials(List<SocialSupplier> socials) {
    
    this.socials = socials;
    return this;
  }

  public RestaurantSupplier addSocialsItem(SocialSupplier socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialSupplier> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialSupplier> socials) {
    this.socials = socials;
  }


  public RestaurantSupplier pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public RestaurantSupplier recognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public RestaurantSupplier addRecognitionListItem(TravelInventoryRecognitionSupplier recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionSupplier> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public RestaurantSupplier transactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
    
    this.transactionalInventoryList = transactionalInventoryList;
    return this;
  }

  public RestaurantSupplier addTransactionalInventoryListItem(TransactionalTravelInventorySupplier transactionalInventoryListItem) {
    if (this.transactionalInventoryList == null) {
      this.transactionalInventoryList = new ArrayList<>();
    }
    this.transactionalInventoryList.add(transactionalInventoryListItem);
    return this;
  }

   /**
   * Purchasable items for this inventory.
   * @return transactionalInventoryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionalTravelInventorySupplier> getTransactionalInventoryList() {
    return transactionalInventoryList;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
    this.transactionalInventoryList = transactionalInventoryList;
  }


  public RestaurantSupplier applicableStart(LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

   /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }


  public RestaurantSupplier applicableEnd(LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

   /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }


  public RestaurantSupplier reservationRequiredInd(Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

   /**
   * Indicates whether a reservation is required to participate in this inventory.
   * @return reservationRequiredInd
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }


  public RestaurantSupplier opens(String opens) {
    
    this.opens = opens;
    return this;
  }

   /**
   * Opening time of inventory (if applicable). Leave empty if inventory is always available.
   * @return opens
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(String opens) {
    this.opens = opens;
  }


  public RestaurantSupplier closes(String closes) {
    
    this.closes = closes;
    return this;
  }

   /**
   * Closing time of inventory (if applicable). Leave empty if inventory is always available.
   * @return closes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(String closes) {
    this.closes = closes;
  }


  public RestaurantSupplier daysOfWeek(DowPatternGroupSupplier daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

   /**
   * Get daysOfWeek
   * @return daysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupSupplier getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(DowPatternGroupSupplier daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }


  public RestaurantSupplier maxSeatingCapacity(Integer maxSeatingCapacity) {
    
    this.maxSeatingCapacity = maxSeatingCapacity;
    return this;
  }

   /**
   * Restaurant supports these many people.
   * minimum: 1
   * @return maxSeatingCapacity
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_SEATING_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxSeatingCapacity() {
    return maxSeatingCapacity;
  }


  @JsonProperty(JSON_PROPERTY_MAX_SEATING_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxSeatingCapacity(Integer maxSeatingCapacity) {
    this.maxSeatingCapacity = maxSeatingCapacity;
  }


  public RestaurantSupplier maxSingleParty(Integer maxSingleParty) {
    
    this.maxSingleParty = maxSingleParty;
    return this;
  }

   /**
   * Largest table at restaurant.
   * minimum: 1
   * @return maxSingleParty
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_SINGLE_PARTY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxSingleParty() {
    return maxSingleParty;
  }


  @JsonProperty(JSON_PROPERTY_MAX_SINGLE_PARTY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxSingleParty(Integer maxSingleParty) {
    this.maxSingleParty = maxSingleParty;
  }


  public RestaurantSupplier offerBreakfast(Boolean offerBreakfast) {
    
    this.offerBreakfast = offerBreakfast;
    return this;
  }

   /**
   * Restaurant offers breakfast.
   * @return offerBreakfast
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferBreakfast() {
    return offerBreakfast;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferBreakfast(Boolean offerBreakfast) {
    this.offerBreakfast = offerBreakfast;
  }


  public RestaurantSupplier offerLunch(Boolean offerLunch) {
    
    this.offerLunch = offerLunch;
    return this;
  }

   /**
   * Restaurant offers lunch.
   * @return offerLunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferLunch() {
    return offerLunch;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferLunch(Boolean offerLunch) {
    this.offerLunch = offerLunch;
  }


  public RestaurantSupplier offerDinner(Boolean offerDinner) {
    
    this.offerDinner = offerDinner;
    return this;
  }

   /**
   * Restaurant offers dinner.
   * @return offerDinner
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferDinner() {
    return offerDinner;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferDinner(Boolean offerDinner) {
    this.offerDinner = offerDinner;
  }


  public RestaurantSupplier offerBrunch(Boolean offerBrunch) {
    
    this.offerBrunch = offerBrunch;
    return this;
  }

   /**
   * Restaurant offers brunch.
   * @return offerBrunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferBrunch() {
    return offerBrunch;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferBrunch(Boolean offerBrunch) {
    this.offerBrunch = offerBrunch;
  }


  public RestaurantSupplier amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public RestaurantSupplier addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;RSI&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return amenities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }


  public RestaurantSupplier infoCodes(List<String> infoCodes) {
    
    this.infoCodes = infoCodes;
    return this;
  }

  public RestaurantSupplier addInfoCodesItem(String infoCodesItem) {
    if (this.infoCodes == null) {
      this.infoCodes = new ArrayList<>();
    }
    this.infoCodes.add(infoCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;RES&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return infoCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INFO_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInfoCodes() {
    return infoCodes;
  }


  @JsonProperty(JSON_PROPERTY_INFO_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfoCodes(List<String> infoCodes) {
    this.infoCodes = infoCodes;
  }


  public RestaurantSupplier cuisineCodes(List<String> cuisineCodes) {
    
    this.cuisineCodes = cuisineCodes;
    return this;
  }

  public RestaurantSupplier addCuisineCodesItem(String cuisineCodesItem) {
    if (this.cuisineCodes == null) {
      this.cuisineCodes = new ArrayList<>();
    }
    this.cuisineCodes.add(cuisineCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;CUI&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return cuisineCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUISINE_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCuisineCodes() {
    return cuisineCodes;
  }


  @JsonProperty(JSON_PROPERTY_CUISINE_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCuisineCodes(List<String> cuisineCodes) {
    this.cuisineCodes = cuisineCodes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RestaurantSupplier restaurantSupplier = (RestaurantSupplier) o;
    return Objects.equals(this.identifier, restaurantSupplier.identifier) &&
        Objects.equals(this.hotelIdentifier, restaurantSupplier.hotelIdentifier) &&
        Objects.equals(this.featuredInd, restaurantSupplier.featuredInd) &&
        Objects.equals(this.lifestyleType, restaurantSupplier.lifestyleType) &&
        Objects.equals(this.location, restaurantSupplier.location) &&
        Objects.equals(this.descriptions, restaurantSupplier.descriptions) &&
        Objects.equals(this.multimedias, restaurantSupplier.multimedias) &&
        Objects.equals(this.contact, restaurantSupplier.contact) &&
        Objects.equals(this.address, restaurantSupplier.address) &&
        Objects.equals(this.commissionable, restaurantSupplier.commissionable) &&
        Objects.equals(this.name, restaurantSupplier.name) &&
        Objects.equals(this.proximityCode, restaurantSupplier.proximityCode) &&
        Objects.equals(this.sort, restaurantSupplier.sort) &&
        Objects.equals(this.minAgeAppropriateCode, restaurantSupplier.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, restaurantSupplier.bookable) &&
        Objects.equals(this.active, restaurantSupplier.active) &&
        Objects.equals(this.disabilityFeatures, restaurantSupplier.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, restaurantSupplier.securityFeatures) &&
        Objects.equals(this.socials, restaurantSupplier.socials) &&
        Objects.equals(this.pricePoint, restaurantSupplier.pricePoint) &&
        Objects.equals(this.recognitionList, restaurantSupplier.recognitionList) &&
        Objects.equals(this.transactionalInventoryList, restaurantSupplier.transactionalInventoryList) &&
        Objects.equals(this.applicableStart, restaurantSupplier.applicableStart) &&
        Objects.equals(this.applicableEnd, restaurantSupplier.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, restaurantSupplier.reservationRequiredInd) &&
        Objects.equals(this.opens, restaurantSupplier.opens) &&
        Objects.equals(this.closes, restaurantSupplier.closes) &&
        Objects.equals(this.daysOfWeek, restaurantSupplier.daysOfWeek) &&
        Objects.equals(this.maxSeatingCapacity, restaurantSupplier.maxSeatingCapacity) &&
        Objects.equals(this.maxSingleParty, restaurantSupplier.maxSingleParty) &&
        Objects.equals(this.offerBreakfast, restaurantSupplier.offerBreakfast) &&
        Objects.equals(this.offerLunch, restaurantSupplier.offerLunch) &&
        Objects.equals(this.offerDinner, restaurantSupplier.offerDinner) &&
        Objects.equals(this.offerBrunch, restaurantSupplier.offerBrunch) &&
        Objects.equals(this.amenities, restaurantSupplier.amenities) &&
        Objects.equals(this.infoCodes, restaurantSupplier.infoCodes) &&
        Objects.equals(this.cuisineCodes, restaurantSupplier.cuisineCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, transactionalInventoryList, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, daysOfWeek, maxSeatingCapacity, maxSingleParty, offerBreakfast, offerLunch, offerDinner, offerBrunch, amenities, infoCodes, cuisineCodes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RestaurantSupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    transactionalInventoryList: ").append(toIndentedString(transactionalInventoryList)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    maxSeatingCapacity: ").append(toIndentedString(maxSeatingCapacity)).append("\n");
    sb.append("    maxSingleParty: ").append(toIndentedString(maxSingleParty)).append("\n");
    sb.append("    offerBreakfast: ").append(toIndentedString(offerBreakfast)).append("\n");
    sb.append("    offerLunch: ").append(toIndentedString(offerLunch)).append("\n");
    sb.append("    offerDinner: ").append(toIndentedString(offerDinner)).append("\n");
    sb.append("    offerBrunch: ").append(toIndentedString(offerBrunch)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("    infoCodes: ").append(toIndentedString(infoCodes)).append("\n");
    sb.append("    cuisineCodes: ").append(toIndentedString(cuisineCodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

