/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.RecognitionSupplier;
import travel.wink.sdk.extranet.model.RecognitionViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;

public class RecognitionApi {
    private ApiClient apiClient;

    public RecognitionApi() {
        this(new ApiClient());
    }

    @Autowired
    public RecognitionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRecognitionRequestCreation(String hotelIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        RecognitionSupplier postBody = recognitionSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionSupplier' when calling createRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RecognitionViewSupplier> createRecognition(String hotelIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.createRecognitionRequestCreation(hotelIdentifier, recognitionSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RecognitionViewSupplier>> createRecognitionWithHttpInfo(String hotelIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.createRecognitionRequestCreation(hotelIdentifier, recognitionSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRecognitionWithResponseSpec(String hotelIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        return this.createRecognitionRequestCreation(hotelIdentifier, recognitionSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRecognitionRequestCreation(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeRecognition(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRecognitionWithHttpInfo(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRecognitionWithResponseSpec(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRecognitionRequestCreation(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RecognitionViewSupplier> showRecognition(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.showRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RecognitionViewSupplier>> showRecognitionWithHttpInfo(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.showRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRecognitionWithResponseSpec(String hotelIdentifier, String recognitionIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRecognitionsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRecognitions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RecognitionViewSupplier> showRecognitions(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.showRecognitionsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RecognitionViewSupplier>>> showRecognitionsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.showRecognitionsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRecognitionsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showRecognitionsRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRecognitionsByCategoryRequestCreation(String hotelIdentifier, String category, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (category == null) {
            throw new WebClientResponseException("Missing the required parameter 'category' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("category", category);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{category}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RecognitionViewSupplier> showRecognitionsByCategory(String hotelIdentifier, String category, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.showRecognitionsByCategoryRequestCreation(hotelIdentifier, category, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RecognitionViewSupplier>>> showRecognitionsByCategoryWithHttpInfo(String hotelIdentifier, String category, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.showRecognitionsByCategoryRequestCreation(hotelIdentifier, category, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRecognitionsByCategoryWithResponseSpec(String hotelIdentifier, String category, String winkVersion) throws WebClientResponseException {
        return this.showRecognitionsByCategoryRequestCreation(hotelIdentifier, category, winkVersion);
    }

    private WebClient.ResponseSpec updateRecognitionRequestCreation(String hotelIdentifier, String recognitionIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        RecognitionSupplier postBody = recognitionSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionSupplier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RecognitionViewSupplier> updateRecognition(String hotelIdentifier, String recognitionIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.updateRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, recognitionSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RecognitionViewSupplier>> updateRecognitionWithHttpInfo(String hotelIdentifier, String recognitionIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RecognitionViewSupplier> localVarReturnType = new ParameterizedTypeReference<RecognitionViewSupplier>(this){};
        return this.updateRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, recognitionSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRecognitionWithResponseSpec(String hotelIdentifier, String recognitionIdentifier, RecognitionSupplier recognitionSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateRecognitionRequestCreation(hotelIdentifier, recognitionIdentifier, recognitionSupplier, winkVersion);
    }
}

