package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CancellationPolicyRemovableResponseSupplier;
import travel.wink.sdk.extranet.model.CancellationPolicyViewSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertCancellationPolicyRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:18:27.744667752+07:00[Asia/Bangkok]")
public class CancellationPolicyApi {
    private ApiClient apiClient;

    public CancellationPolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CancellationPolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create cancellation policy and associate it with by this hotel identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCancellationPolicyRequestCreation(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCancellationPolicyRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCancellationPolicyRequestSupplier' is set
        if (upsertCancellationPolicyRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequestSupplier' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create cancellation policy and associate it with by this hotel identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyViewSupplier> createCancellationPolicy(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create cancellation policy and associate it with by this hotel identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> createCancellationPolicyWithHttpInfo(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create cancellation policy and associate it with by this hotel identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCancellationPolicyWithResponseSpec(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion);
    }
    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if cancellation policy is removable and owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isCancellationPolicyRemovableRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if cancellation policy is removable and owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyRemovableResponseSupplier> isCancellationPolicyRemovable(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>() {};
        return isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if cancellation policy is removable and owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CancellationPolicyRemovableResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyRemovableResponseSupplier>> isCancellationPolicyRemovableWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>() {};
        return isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if cancellation policy is removable and owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isCancellationPolicyRemovableWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        return isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion);
    }
    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Delete cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCancellationPolicyWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        return removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion);
    }
    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyViewSupplier> showCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> showCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCancellationPolicyWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion) throws WebClientResponseException {
        return showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion);
    }
    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier List all cancellation policies for this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCancellationPolicyListRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier List all cancellation policies for this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CancellationPolicyViewSupplier> showCancellationPolicyList(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier List all cancellation policies for this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;CancellationPolicyViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<CancellationPolicyViewSupplier>>> showCancellationPolicyListWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier List all cancellation policies for this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCancellationPolicyListWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCancellationPolicyRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCancellationPolicyRequestSupplier' is set
        if (upsertCancellationPolicyRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequestSupplier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyViewSupplier> updateCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> updateCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing cancellation policy owned by this hotel identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCancellationPolicyWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion);
    }
}
