package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.MultimediaViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.RemoveListEntriesResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:18:27.744667752+07:00[Asia/Bangkok]")
public class MediaApi {
    private ApiClient apiClient;

    public MediaApi() {
        this(new ApiClient());
    }

    @Autowired
    public MediaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Multimedia
     * Save multimedia of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Save a single media associated with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MultimediaViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createMultimediaRequestCreation(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = simpleMultimediaSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'simpleMultimediaSupplier' is set
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling createMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Multimedia
     * Save multimedia of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Save a single media associated with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MultimediaViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MultimediaViewSupplier> createMultimedia(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return createMultimediaRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Multimedia
     * Save multimedia of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Save a single media associated with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MultimediaViewSupplier>> createMultimediaWithHttpInfo(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return createMultimediaRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Multimedia
     * Save multimedia of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Save a single media associated with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createMultimediaWithResponseSpec(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        return createMultimediaRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion);
    }
    /**
     * Delete Multimedia List
     * Remove multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Remove selected media for this hotel identifier
     * @param multimediaIdentifiers Remove media identified by these identifiers
     * @param winkVersion The winkVersion parameter
     * @return RemoveListEntriesResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMediaListRequestCreation(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifiers' is set
        if (multimediaIdentifiers == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifiers' when calling removeMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "multimediaIdentifiers", multimediaIdentifiers));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveListEntriesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveListEntriesResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedias", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia List
     * Remove multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Remove selected media for this hotel identifier
     * @param multimediaIdentifiers Remove media identified by these identifiers
     * @param winkVersion The winkVersion parameter
     * @return RemoveListEntriesResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveListEntriesResponseSupplier> removeMediaList(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveListEntriesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveListEntriesResponseSupplier>() {};
        return removeMediaListRequestCreation(hotelIdentifier, multimediaIdentifiers, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Multimedia List
     * Remove multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Remove selected media for this hotel identifier
     * @param multimediaIdentifiers Remove media identified by these identifiers
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveListEntriesResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveListEntriesResponseSupplier>> removeMediaListWithHttpInfo(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveListEntriesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveListEntriesResponseSupplier>() {};
        return removeMediaListRequestCreation(hotelIdentifier, multimediaIdentifiers, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Multimedia List
     * Remove multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Remove selected media for this hotel identifier
     * @param multimediaIdentifiers Remove media identified by these identifiers
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMediaListWithResponseSpec(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        return removeMediaListRequestCreation(hotelIdentifier, multimediaIdentifiers, winkVersion);
    }
    /**
     * Delete Multimedia
     * Remove multimedia record for hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a single media associated with this hotel identifier
     * @param multimediaIdentifier Remove record for this media identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimediaRequestCreation(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove multimedia record for hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a single media associated with this hotel identifier
     * @param multimediaIdentifier Remove record for this media identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeMultimedia(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove multimedia record for hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a single media associated with this hotel identifier
     * @param multimediaIdentifier Remove record for this media identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeMultimediaWithHttpInfo(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove multimedia record for hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a single media associated with this hotel identifier
     * @param multimediaIdentifier Remove record for this media identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMultimediaWithResponseSpec(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        return removeMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, winkVersion);
    }
    /**
     * Show Multimedia
     * Retrieve list of multimedia (images / videos) for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show media associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMediaListRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Multimedia
     * Retrieve list of multimedia (images / videos) for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show media associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MultimediaViewSupplier> showMediaList(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return showMediaListRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Multimedia
     * Retrieve list of multimedia (images / videos) for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show media associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;MultimediaViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MultimediaViewSupplier>>> showMediaListWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return showMediaListRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Multimedia
     * Retrieve list of multimedia (images / videos) for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show media associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMediaListWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showMediaListRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Multimedia List
     * Save/Update multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Save media to the property with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMediaListRequestCreation(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = simpleMultimediaSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'simpleMultimediaSupplier' is set
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling updateMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Multimedia List
     * Save/Update multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Save media to the property with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MultimediaViewSupplier> updateMediaList(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return updateMediaListRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Update Multimedia List
     * Save/Update multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Save media to the property with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;MultimediaViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MultimediaViewSupplier>>> updateMediaListWithHttpInfo(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return updateMediaListRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Update Multimedia List
     * Save/Update multimedia list of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Save media to the property with this hotel identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMediaListWithResponseSpec(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        return updateMediaListRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion);
    }
    /**
     * Update Multimedia
     * Update multimedia properties of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Update a single media associated with this hotel identifier
     * @param multimediaIdentifier Update record for this media identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MultimediaViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMultimediaRequestCreation(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = simpleMultimediaSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'simpleMultimediaSupplier' is set
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update multimedia properties of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Update a single media associated with this hotel identifier
     * @param multimediaIdentifier Update record for this media identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MultimediaViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MultimediaViewSupplier> updateMultimedia(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return updateMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update multimedia properties of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Update a single media associated with this hotel identifier
     * @param multimediaIdentifier Update record for this media identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MultimediaViewSupplier>> updateMultimediaWithHttpInfo(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return updateMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update multimedia properties of a hotel identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Update a single media associated with this hotel identifier
     * @param multimediaIdentifier Update record for this media identifier
     * @param simpleMultimediaSupplier The simpleMultimediaSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMultimediaWithResponseSpec(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        return updateMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion);
    }
    /**
     * Upload GM Profile Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Add general manager profile picture for this hotel identifier
     * @param _file The _file parameter
     * @return SimpleMultimediaSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadGeneralManagerProfilePictureRequestCreation(String hotelIdentifier, File _file) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new WebClientResponseException("Missing the required parameter '_file' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (_file != null)
            formParams.add("file", new FileSystemResource(_file));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/generalmanager/upload", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload GM Profile Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Add general manager profile picture for this hotel identifier
     * @param _file The _file parameter
     * @return SimpleMultimediaSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SimpleMultimediaSupplier> uploadGeneralManagerProfilePicture(String hotelIdentifier, File _file) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>() {};
        return uploadGeneralManagerProfilePictureRequestCreation(hotelIdentifier, _file).bodyToMono(localVarReturnType);
    }

    /**
     * Upload GM Profile Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Add general manager profile picture for this hotel identifier
     * @param _file The _file parameter
     * @return ResponseEntity&lt;SimpleMultimediaSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SimpleMultimediaSupplier>> uploadGeneralManagerProfilePictureWithHttpInfo(String hotelIdentifier, File _file) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>() {};
        return uploadGeneralManagerProfilePictureRequestCreation(hotelIdentifier, _file).toEntity(localVarReturnType);
    }

    /**
     * Upload GM Profile Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Add general manager profile picture for this hotel identifier
     * @param _file The _file parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadGeneralManagerProfilePictureWithResponseSpec(String hotelIdentifier, File _file) throws WebClientResponseException {
        return uploadGeneralManagerProfilePictureRequestCreation(hotelIdentifier, _file);
    }
    /**
     * Upload Multimedia
     * Upload videos and/or images and associate it with specified hotelIdentifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart file media for this hotel identifier
     * @param files The files parameter
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadMultimediaRequestCreation(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/upload", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Multimedia
     * Upload videos and/or images and associate it with specified hotelIdentifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart file media for this hotel identifier
     * @param files The files parameter
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MultimediaViewSupplier> uploadMultimedia(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return uploadMultimediaRequestCreation(hotelIdentifier, files).bodyToFlux(localVarReturnType);
    }

    /**
     * Upload Multimedia
     * Upload videos and/or images and associate it with specified hotelIdentifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart file media for this hotel identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;List&lt;MultimediaViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MultimediaViewSupplier>>> uploadMultimediaWithHttpInfo(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return uploadMultimediaRequestCreation(hotelIdentifier, files).toEntityList(localVarReturnType);
    }

    /**
     * Upload Multimedia
     * Upload videos and/or images and associate it with specified hotelIdentifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart file media for this hotel identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadMultimediaWithResponseSpec(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        return uploadMultimediaRequestCreation(hotelIdentifier, files);
    }
}
