package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RateModifierViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertRateModifierRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:18:27.744667752+07:00[Asia/Bangkok]")
public class PromotionApi {
    private ApiClient apiClient;

    public PromotionApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion and associate with this hotel identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPromotionRequestCreation(String hotelIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierRequestSupplier' is set
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion and associate with this hotel identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierViewSupplier> createPromotion(String hotelIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return createPromotionRequestCreation(hotelIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion and associate with this hotel identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierViewSupplier>> createPromotionWithHttpInfo(String hotelIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return createPromotionRequestCreation(hotelIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion and associate with this hotel identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPromotionWithResponseSpec(String hotelIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createPromotionRequestCreation(hotelIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }
    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion owned by this hotel identifier.
     * @param promotionIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRateModifierRequestCreation(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionIdentifier' is set
        if (promotionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionIdentifier", promotionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/{promotionIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion owned by this hotel identifier.
     * @param promotionIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeRateModifier(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierRequestCreation(hotelIdentifier, promotionIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion owned by this hotel identifier.
     * @param promotionIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRateModifierWithHttpInfo(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierRequestCreation(hotelIdentifier, promotionIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion owned by this hotel identifier.
     * @param promotionIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRateModifierWithResponseSpec(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        return removeRateModifierRequestCreation(hotelIdentifier, promotionIdentifier, winkVersion);
    }
    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion owned by this hotel identifier.
     * @param promotionIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPromotionRequestCreation(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionIdentifier' is set
        if (promotionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionIdentifier", promotionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/{promotionIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion owned by this hotel identifier.
     * @param promotionIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierViewSupplier> showPromotion(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionRequestCreation(hotelIdentifier, promotionIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion owned by this hotel identifier.
     * @param promotionIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierViewSupplier>> showPromotionWithHttpInfo(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionRequestCreation(hotelIdentifier, promotionIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion owned by this hotel identifier.
     * @param promotionIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPromotionWithResponseSpec(String hotelIdentifier, String promotionIdentifier, String winkVersion) throws WebClientResponseException {
        return showPromotionRequestCreation(hotelIdentifier, promotionIdentifier, winkVersion);
    }
    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotions owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPromotionsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPromotions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotions owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateModifierViewSupplier> showPromotions(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotions owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RateModifierViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateModifierViewSupplier>>> showPromotionsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotions owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPromotionsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showPromotionsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion owned by this hotel identifier.
     * @param promotionIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePromotionRequestCreation(String hotelIdentifier, String promotionIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionIdentifier' is set
        if (promotionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierRequestSupplier' is set
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionIdentifier", promotionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/{promotionIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion owned by this hotel identifier.
     * @param promotionIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierViewSupplier> updatePromotion(String hotelIdentifier, String promotionIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return updatePromotionRequestCreation(hotelIdentifier, promotionIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion owned by this hotel identifier.
     * @param promotionIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierViewSupplier>> updatePromotionWithHttpInfo(String hotelIdentifier, String promotionIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return updatePromotionRequestCreation(hotelIdentifier, promotionIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion owned by this hotel identifier.
     * @param promotionIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updatePromotionWithResponseSpec(String hotelIdentifier, String promotionIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updatePromotionRequestCreation(hotelIdentifier, promotionIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }
}
