/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.extranet.model.DescriptiveReasonSupplierDetails;
import travel.wink.sdk.extranet.model.DescriptiveRoomTypeWithPriceConfigurationsSupplierDetails;
import travel.wink.sdk.extranet.model.InventorySupplierDetails;
import travel.wink.sdk.extranet.model.MasterRateSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DescriptiveRoomSupplierDetails
 */
@JsonPropertyOrder({
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_IDENTIFIER,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_ROOM_NAME,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_ACCESSIBLE_MASTER_RATES,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_INACCESSIBLE_MASTER_RATES,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_ACCESSIBLE_INVENTORY,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_ACCESSIBLE_RATE_PLANS,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_INACCESSIBLE_RATE_PLANS,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_ACCESSIBLE_AVAILABILITY,
  DescriptiveRoomSupplierDetails.JSON_PROPERTY_INACCESSIBLE_AVAILABILITY
})
@JsonTypeName("DescriptiveRoom_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:18:27.744667752+07:00[Asia/Bangkok]")
public class DescriptiveRoomSupplierDetails {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_ROOM_NAME = "roomName";
  private String roomName;

  public static final String JSON_PROPERTY_ACCESSIBLE_MASTER_RATES = "accessibleMasterRates";
  private List<MasterRateSupplierDetails> accessibleMasterRates;

  public static final String JSON_PROPERTY_INACCESSIBLE_MASTER_RATES = "inaccessibleMasterRates";
  private List<DescriptiveReasonSupplierDetails> inaccessibleMasterRates;

  public static final String JSON_PROPERTY_ACCESSIBLE_INVENTORY = "accessibleInventory";
  private List<InventorySupplierDetails> accessibleInventory;

  public static final String JSON_PROPERTY_ACCESSIBLE_RATE_PLANS = "accessibleRatePlans";
  private List<DescriptiveReasonSupplierDetails> accessibleRatePlans;

  public static final String JSON_PROPERTY_INACCESSIBLE_RATE_PLANS = "inaccessibleRatePlans";
  private List<DescriptiveReasonSupplierDetails> inaccessibleRatePlans;

  public static final String JSON_PROPERTY_ACCESSIBLE_AVAILABILITY = "accessibleAvailability";
  private List<DescriptiveRoomTypeWithPriceConfigurationsSupplierDetails> accessibleAvailability;

  public static final String JSON_PROPERTY_INACCESSIBLE_AVAILABILITY = "inaccessibleAvailability";
  private List<DescriptiveReasonSupplierDetails> inaccessibleAvailability;

  public DescriptiveRoomSupplierDetails() {
  }

  public DescriptiveRoomSupplierDetails identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Get identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public DescriptiveRoomSupplierDetails roomName(String roomName) {
    
    this.roomName = roomName;
    return this;
  }

   /**
   * Get roomName
   * @return roomName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomName() {
    return roomName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomName(String roomName) {
    this.roomName = roomName;
  }


  public DescriptiveRoomSupplierDetails accessibleMasterRates(List<MasterRateSupplierDetails> accessibleMasterRates) {
    
    this.accessibleMasterRates = accessibleMasterRates;
    return this;
  }

  public DescriptiveRoomSupplierDetails addAccessibleMasterRatesItem(MasterRateSupplierDetails accessibleMasterRatesItem) {
    if (this.accessibleMasterRates == null) {
      this.accessibleMasterRates = new ArrayList<>();
    }
    this.accessibleMasterRates.add(accessibleMasterRatesItem);
    return this;
  }

   /**
   * Get accessibleMasterRates
   * @return accessibleMasterRates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MasterRateSupplierDetails> getAccessibleMasterRates() {
    return accessibleMasterRates;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleMasterRates(List<MasterRateSupplierDetails> accessibleMasterRates) {
    this.accessibleMasterRates = accessibleMasterRates;
  }


  public DescriptiveRoomSupplierDetails inaccessibleMasterRates(List<DescriptiveReasonSupplierDetails> inaccessibleMasterRates) {
    
    this.inaccessibleMasterRates = inaccessibleMasterRates;
    return this;
  }

  public DescriptiveRoomSupplierDetails addInaccessibleMasterRatesItem(DescriptiveReasonSupplierDetails inaccessibleMasterRatesItem) {
    if (this.inaccessibleMasterRates == null) {
      this.inaccessibleMasterRates = new ArrayList<>();
    }
    this.inaccessibleMasterRates.add(inaccessibleMasterRatesItem);
    return this;
  }

   /**
   * Get inaccessibleMasterRates
   * @return inaccessibleMasterRates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonSupplierDetails> getInaccessibleMasterRates() {
    return inaccessibleMasterRates;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_MASTER_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleMasterRates(List<DescriptiveReasonSupplierDetails> inaccessibleMasterRates) {
    this.inaccessibleMasterRates = inaccessibleMasterRates;
  }


  public DescriptiveRoomSupplierDetails accessibleInventory(List<InventorySupplierDetails> accessibleInventory) {
    
    this.accessibleInventory = accessibleInventory;
    return this;
  }

  public DescriptiveRoomSupplierDetails addAccessibleInventoryItem(InventorySupplierDetails accessibleInventoryItem) {
    if (this.accessibleInventory == null) {
      this.accessibleInventory = new ArrayList<>();
    }
    this.accessibleInventory.add(accessibleInventoryItem);
    return this;
  }

   /**
   * Get accessibleInventory
   * @return accessibleInventory
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<InventorySupplierDetails> getAccessibleInventory() {
    return accessibleInventory;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleInventory(List<InventorySupplierDetails> accessibleInventory) {
    this.accessibleInventory = accessibleInventory;
  }


  public DescriptiveRoomSupplierDetails accessibleRatePlans(List<DescriptiveReasonSupplierDetails> accessibleRatePlans) {
    
    this.accessibleRatePlans = accessibleRatePlans;
    return this;
  }

  public DescriptiveRoomSupplierDetails addAccessibleRatePlansItem(DescriptiveReasonSupplierDetails accessibleRatePlansItem) {
    if (this.accessibleRatePlans == null) {
      this.accessibleRatePlans = new ArrayList<>();
    }
    this.accessibleRatePlans.add(accessibleRatePlansItem);
    return this;
  }

   /**
   * Get accessibleRatePlans
   * @return accessibleRatePlans
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonSupplierDetails> getAccessibleRatePlans() {
    return accessibleRatePlans;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleRatePlans(List<DescriptiveReasonSupplierDetails> accessibleRatePlans) {
    this.accessibleRatePlans = accessibleRatePlans;
  }


  public DescriptiveRoomSupplierDetails inaccessibleRatePlans(List<DescriptiveReasonSupplierDetails> inaccessibleRatePlans) {
    
    this.inaccessibleRatePlans = inaccessibleRatePlans;
    return this;
  }

  public DescriptiveRoomSupplierDetails addInaccessibleRatePlansItem(DescriptiveReasonSupplierDetails inaccessibleRatePlansItem) {
    if (this.inaccessibleRatePlans == null) {
      this.inaccessibleRatePlans = new ArrayList<>();
    }
    this.inaccessibleRatePlans.add(inaccessibleRatePlansItem);
    return this;
  }

   /**
   * Get inaccessibleRatePlans
   * @return inaccessibleRatePlans
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonSupplierDetails> getInaccessibleRatePlans() {
    return inaccessibleRatePlans;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_RATE_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleRatePlans(List<DescriptiveReasonSupplierDetails> inaccessibleRatePlans) {
    this.inaccessibleRatePlans = inaccessibleRatePlans;
  }


  public DescriptiveRoomSupplierDetails accessibleAvailability(List<DescriptiveRoomTypeWithPriceConfigurationsSupplierDetails> accessibleAvailability) {
    
    this.accessibleAvailability = accessibleAvailability;
    return this;
  }

  public DescriptiveRoomSupplierDetails addAccessibleAvailabilityItem(DescriptiveRoomTypeWithPriceConfigurationsSupplierDetails accessibleAvailabilityItem) {
    if (this.accessibleAvailability == null) {
      this.accessibleAvailability = new ArrayList<>();
    }
    this.accessibleAvailability.add(accessibleAvailabilityItem);
    return this;
  }

   /**
   * Get accessibleAvailability
   * @return accessibleAvailability
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveRoomTypeWithPriceConfigurationsSupplierDetails> getAccessibleAvailability() {
    return accessibleAvailability;
  }


  @JsonProperty(JSON_PROPERTY_ACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibleAvailability(List<DescriptiveRoomTypeWithPriceConfigurationsSupplierDetails> accessibleAvailability) {
    this.accessibleAvailability = accessibleAvailability;
  }


  public DescriptiveRoomSupplierDetails inaccessibleAvailability(List<DescriptiveReasonSupplierDetails> inaccessibleAvailability) {
    
    this.inaccessibleAvailability = inaccessibleAvailability;
    return this;
  }

  public DescriptiveRoomSupplierDetails addInaccessibleAvailabilityItem(DescriptiveReasonSupplierDetails inaccessibleAvailabilityItem) {
    if (this.inaccessibleAvailability == null) {
      this.inaccessibleAvailability = new ArrayList<>();
    }
    this.inaccessibleAvailability.add(inaccessibleAvailabilityItem);
    return this;
  }

   /**
   * Get inaccessibleAvailability
   * @return inaccessibleAvailability
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DescriptiveReasonSupplierDetails> getInaccessibleAvailability() {
    return inaccessibleAvailability;
  }


  @JsonProperty(JSON_PROPERTY_INACCESSIBLE_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInaccessibleAvailability(List<DescriptiveReasonSupplierDetails> inaccessibleAvailability) {
    this.inaccessibleAvailability = inaccessibleAvailability;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DescriptiveRoomSupplierDetails descriptiveRoomSupplierDetails = (DescriptiveRoomSupplierDetails) o;
    return Objects.equals(this.identifier, descriptiveRoomSupplierDetails.identifier) &&
        Objects.equals(this.roomName, descriptiveRoomSupplierDetails.roomName) &&
        Objects.equals(this.accessibleMasterRates, descriptiveRoomSupplierDetails.accessibleMasterRates) &&
        Objects.equals(this.inaccessibleMasterRates, descriptiveRoomSupplierDetails.inaccessibleMasterRates) &&
        Objects.equals(this.accessibleInventory, descriptiveRoomSupplierDetails.accessibleInventory) &&
        Objects.equals(this.accessibleRatePlans, descriptiveRoomSupplierDetails.accessibleRatePlans) &&
        Objects.equals(this.inaccessibleRatePlans, descriptiveRoomSupplierDetails.inaccessibleRatePlans) &&
        Objects.equals(this.accessibleAvailability, descriptiveRoomSupplierDetails.accessibleAvailability) &&
        Objects.equals(this.inaccessibleAvailability, descriptiveRoomSupplierDetails.inaccessibleAvailability);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, roomName, accessibleMasterRates, inaccessibleMasterRates, accessibleInventory, accessibleRatePlans, inaccessibleRatePlans, accessibleAvailability, inaccessibleAvailability);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DescriptiveRoomSupplierDetails {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    roomName: ").append(toIndentedString(roomName)).append("\n");
    sb.append("    accessibleMasterRates: ").append(toIndentedString(accessibleMasterRates)).append("\n");
    sb.append("    inaccessibleMasterRates: ").append(toIndentedString(inaccessibleMasterRates)).append("\n");
    sb.append("    accessibleInventory: ").append(toIndentedString(accessibleInventory)).append("\n");
    sb.append("    accessibleRatePlans: ").append(toIndentedString(accessibleRatePlans)).append("\n");
    sb.append("    inaccessibleRatePlans: ").append(toIndentedString(inaccessibleRatePlans)).append("\n");
    sb.append("    accessibleAvailability: ").append(toIndentedString(accessibleAvailability)).append("\n");
    sb.append("    inaccessibleAvailability: ").append(toIndentedString(inaccessibleAvailability)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

