/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.extranet.model.AgreementSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.UpsertAddressRequestSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyRegistrationRequestSupplier
 */
@JsonPropertyOrder({
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_NAME,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_LEGAL_NAME,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_LOCAL_NAME,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_CURRENCY_CODE,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_NUMBER_OF_ROOMS,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_RESERVATION_DESK_START_TIME,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_RESERVATION_DESK_END_TIME,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_ADDRESS,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_RESERVATION,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_OWNER,
  PropertyRegistrationRequestSupplier.JSON_PROPERTY_AGREEMENT
})
@JsonTypeName("PropertyRegistrationRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:18:27.744667752+07:00[Asia/Bangkok]")
public class PropertyRegistrationRequestSupplier {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms;

  public static final String JSON_PROPERTY_RESERVATION_DESK_START_TIME = "reservationDeskStartTime";
  private String reservationDeskStartTime;

  public static final String JSON_PROPERTY_RESERVATION_DESK_END_TIME = "reservationDeskEndTime";
  private String reservationDeskEndTime;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private UpsertAddressRequestSupplier address;

  public static final String JSON_PROPERTY_RESERVATION = "reservation";
  private ContactSupplier reservation;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private ContactSupplier owner;

  public static final String JSON_PROPERTY_AGREEMENT = "agreement";
  private AgreementSupplier agreement;

  public PropertyRegistrationRequestSupplier() {
  }

  public PropertyRegistrationRequestSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Unique hotel trade name. The hotel name must be unique. If there are multiple hotels with the same name, we recommend appending destination to the name. [Verify uniqueness here](#operation/isHotelNameUnique).
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public PropertyRegistrationRequestSupplier legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of the hotel as it is registered.
   * @return legalName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public PropertyRegistrationRequestSupplier localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Local name of the hotel as it is referred to in the local language.
   * @return localName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public PropertyRegistrationRequestSupplier currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Valid 3-character ISO currency code. Find our [supported currency codes here](#operation/showCurrencies).
   * @return currencyCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public PropertyRegistrationRequestSupplier numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for property
   * minimum: 1
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public PropertyRegistrationRequestSupplier reservationDeskStartTime(String reservationDeskStartTime) {
    
    this.reservationDeskStartTime = reservationDeskStartTime;
    return this;
  }

   /**
   * If the reservation desk does not operate 24 hours, enter a start time.
   * @return reservationDeskStartTime
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_START_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getReservationDeskStartTime() {
    return reservationDeskStartTime;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_START_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReservationDeskStartTime(String reservationDeskStartTime) {
    this.reservationDeskStartTime = reservationDeskStartTime;
  }


  public PropertyRegistrationRequestSupplier reservationDeskEndTime(String reservationDeskEndTime) {
    
    this.reservationDeskEndTime = reservationDeskEndTime;
    return this;
  }

   /**
   * If the reservation desk does not operate 24 hours, enter an end time.
   * @return reservationDeskEndTime
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_END_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getReservationDeskEndTime() {
    return reservationDeskEndTime;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_DESK_END_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReservationDeskEndTime(String reservationDeskEndTime) {
    this.reservationDeskEndTime = reservationDeskEndTime;
  }


  public PropertyRegistrationRequestSupplier address(UpsertAddressRequestSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UpsertAddressRequestSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(UpsertAddressRequestSupplier address) {
    this.address = address;
  }


  public PropertyRegistrationRequestSupplier reservation(ContactSupplier reservation) {
    
    this.reservation = reservation;
    return this;
  }

   /**
   * Get reservation
   * @return reservation
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_RESERVATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactSupplier getReservation() {
    return reservation;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReservation(ContactSupplier reservation) {
    this.reservation = reservation;
  }


  public PropertyRegistrationRequestSupplier owner(ContactSupplier owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactSupplier getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwner(ContactSupplier owner) {
    this.owner = owner;
  }


  public PropertyRegistrationRequestSupplier agreement(AgreementSupplier agreement) {
    
    this.agreement = agreement;
    return this;
  }

   /**
   * Get agreement
   * @return agreement
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AGREEMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AgreementSupplier getAgreement() {
    return agreement;
  }


  @JsonProperty(JSON_PROPERTY_AGREEMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAgreement(AgreementSupplier agreement) {
    this.agreement = agreement;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier = (PropertyRegistrationRequestSupplier) o;
    return Objects.equals(this.name, propertyRegistrationRequestSupplier.name) &&
        Objects.equals(this.legalName, propertyRegistrationRequestSupplier.legalName) &&
        Objects.equals(this.localName, propertyRegistrationRequestSupplier.localName) &&
        Objects.equals(this.currencyCode, propertyRegistrationRequestSupplier.currencyCode) &&
        Objects.equals(this.numberOfRooms, propertyRegistrationRequestSupplier.numberOfRooms) &&
        Objects.equals(this.reservationDeskStartTime, propertyRegistrationRequestSupplier.reservationDeskStartTime) &&
        Objects.equals(this.reservationDeskEndTime, propertyRegistrationRequestSupplier.reservationDeskEndTime) &&
        Objects.equals(this.address, propertyRegistrationRequestSupplier.address) &&
        Objects.equals(this.reservation, propertyRegistrationRequestSupplier.reservation) &&
        Objects.equals(this.owner, propertyRegistrationRequestSupplier.owner) &&
        Objects.equals(this.agreement, propertyRegistrationRequestSupplier.agreement);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, legalName, localName, currencyCode, numberOfRooms, reservationDeskStartTime, reservationDeskEndTime, address, reservation, owner, agreement);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyRegistrationRequestSupplier {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    reservationDeskStartTime: ").append(toIndentedString(reservationDeskStartTime)).append("\n");
    sb.append("    reservationDeskEndTime: ").append(toIndentedString(reservationDeskEndTime)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    reservation: ").append(toIndentedString(reservation)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    agreement: ").append(toIndentedString(agreement)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

