/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SalesChannelUpdateRequestSupplier
 */
@JsonPropertyOrder({
  SalesChannelUpdateRequestSupplier.JSON_PROPERTY_ENABLED,
  SalesChannelUpdateRequestSupplier.JSON_PROPERTY_BLACKLISTED,
  SalesChannelUpdateRequestSupplier.JSON_PROPERTY_PERCENT_DISCOUNT,
  SalesChannelUpdateRequestSupplier.JSON_PROPERTY_COMMISSION,
  SalesChannelUpdateRequestSupplier.JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS,
  SalesChannelUpdateRequestSupplier.JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS
})
@JsonTypeName("SalesChannelUpdateRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:18:27.744667752+07:00[Asia/Bangkok]")
public class SalesChannelUpdateRequestSupplier {
  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_BLACKLISTED = "blacklisted";
  private Boolean blacklisted = true;

  public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
  private Float percentDiscount;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS = "rateModifierIdentifiers";
  private List<UUID> rateModifierIdentifiers;

  public static final String JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS = "rateModifierBundleIdentifiers";
  private List<UUID> rateModifierBundleIdentifiers;

  public SalesChannelUpdateRequestSupplier() {
  }

  public SalesChannelUpdateRequestSupplier enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Flag the supplier can use to enable / disable a sales channel
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public SalesChannelUpdateRequestSupplier blacklisted(Boolean blacklisted) {
    
    this.blacklisted = blacklisted;
    return this;
  }

   /**
   * Flag the supplier can use to ignore a sales channel
   * @return blacklisted
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBlacklisted() {
    return blacklisted;
  }


  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBlacklisted(Boolean blacklisted) {
    this.blacklisted = blacklisted;
  }


  public SalesChannelUpdateRequestSupplier percentDiscount(Float percentDiscount) {
    
    this.percentDiscount = percentDiscount;
    return this;
  }

   /**
   * Percent discount on this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return percentDiscount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0") @DecimalMax("1.0")
  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getPercentDiscount() {
    return percentDiscount;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPercentDiscount(Float percentDiscount) {
    this.percentDiscount = percentDiscount;
  }


  public SalesChannelUpdateRequestSupplier commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Amount of sales commission earned through this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return commission
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0") @DecimalMax("1.0")
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public SalesChannelUpdateRequestSupplier rateModifierIdentifiers(List<UUID> rateModifierIdentifiers) {
    
    this.rateModifierIdentifiers = rateModifierIdentifiers;
    return this;
  }

  public SalesChannelUpdateRequestSupplier addRateModifierIdentifiersItem(UUID rateModifierIdentifiersItem) {
    if (this.rateModifierIdentifiers == null) {
      this.rateModifierIdentifiers = new ArrayList<>();
    }
    this.rateModifierIdentifiers.add(rateModifierIdentifiersItem);
    return this;
  }

   /**
   * Get rateModifierIdentifiers
   * @return rateModifierIdentifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UUID> getRateModifierIdentifiers() {
    return rateModifierIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifierIdentifiers(List<UUID> rateModifierIdentifiers) {
    this.rateModifierIdentifiers = rateModifierIdentifiers;
  }


  public SalesChannelUpdateRequestSupplier rateModifierBundleIdentifiers(List<UUID> rateModifierBundleIdentifiers) {
    
    this.rateModifierBundleIdentifiers = rateModifierBundleIdentifiers;
    return this;
  }

  public SalesChannelUpdateRequestSupplier addRateModifierBundleIdentifiersItem(UUID rateModifierBundleIdentifiersItem) {
    if (this.rateModifierBundleIdentifiers == null) {
      this.rateModifierBundleIdentifiers = new ArrayList<>();
    }
    this.rateModifierBundleIdentifiers.add(rateModifierBundleIdentifiersItem);
    return this;
  }

   /**
   * Get rateModifierBundleIdentifiers
   * @return rateModifierBundleIdentifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UUID> getRateModifierBundleIdentifiers() {
    return rateModifierBundleIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifierBundleIdentifiers(List<UUID> rateModifierBundleIdentifiers) {
    this.rateModifierBundleIdentifiers = rateModifierBundleIdentifiers;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier = (SalesChannelUpdateRequestSupplier) o;
    return Objects.equals(this.enabled, salesChannelUpdateRequestSupplier.enabled) &&
        Objects.equals(this.blacklisted, salesChannelUpdateRequestSupplier.blacklisted) &&
        Objects.equals(this.percentDiscount, salesChannelUpdateRequestSupplier.percentDiscount) &&
        Objects.equals(this.commission, salesChannelUpdateRequestSupplier.commission) &&
        Objects.equals(this.rateModifierIdentifiers, salesChannelUpdateRequestSupplier.rateModifierIdentifiers) &&
        Objects.equals(this.rateModifierBundleIdentifiers, salesChannelUpdateRequestSupplier.rateModifierBundleIdentifiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, blacklisted, percentDiscount, commission, rateModifierIdentifiers, rateModifierBundleIdentifiers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesChannelUpdateRequestSupplier {\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    blacklisted: ").append(toIndentedString(blacklisted)).append("\n");
    sb.append("    percentDiscount: ").append(toIndentedString(percentDiscount)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    rateModifierIdentifiers: ").append(toIndentedString(rateModifierIdentifiers)).append("\n");
    sb.append("    rateModifierBundleIdentifiers: ").append(toIndentedString(rateModifierBundleIdentifiers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

