/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.20.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.PayoutFeeSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Payout keeps track of all outgoing funds for a certain account.
 */
@JsonPropertyOrder({
  PayoutSupplier.JSON_PROPERTY_VENDOR,
  PayoutSupplier.JSON_PROPERTY_VENDOR_IDENTIFIER,
  PayoutSupplier.JSON_PROPERTY_VENDOR_NAME,
  PayoutSupplier.JSON_PROPERTY_VENDOR_TOKEN_KEY,
  PayoutSupplier.JSON_PROPERTY_IDENTIFIER,
  PayoutSupplier.JSON_PROPERTY_BENEFICIARY_IDENTIFIER,
  PayoutSupplier.JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER,
  PayoutSupplier.JSON_PROPERTY_TYPE,
  PayoutSupplier.JSON_PROPERTY_ENTRY,
  PayoutSupplier.JSON_PROPERTY_FEES,
  PayoutSupplier.JSON_PROPERTY_CREATED,
  PayoutSupplier.JSON_PROPERTY_DESCRIPTION,
  PayoutSupplier.JSON_PROPERTY_PAYOUT_ID,
  PayoutSupplier.JSON_PROPERTY_REFERENCE_CODE,
  PayoutSupplier.JSON_PROPERTY_REFERENCE_CODE_DATE,
  PayoutSupplier.JSON_PROPERTY_STATUS
})
@JsonTypeName("Payout_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-30T09:50:32.356842367+07:00[Asia/Bangkok]")
public class PayoutSupplier {
  /**
   * Name of integration vendor
   */
  public enum VendorEnum {
    STRIPE("STRIPE"),
    
    AGENT("AGENT"),
    
    WISE("WISE");

    private String value;

    VendorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VendorEnum fromValue(String value) {
      for (VendorEnum b : VendorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VENDOR = "vendor";
  private VendorEnum vendor;

  public static final String JSON_PROPERTY_VENDOR_IDENTIFIER = "vendorIdentifier";
  private String vendorIdentifier;

  public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
  private String vendorName;

  public static final String JSON_PROPERTY_VENDOR_TOKEN_KEY = "vendorTokenKey";
  private String vendorTokenKey;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_BENEFICIARY_IDENTIFIER = "beneficiaryIdentifier";
  private UUID beneficiaryIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER = "externalPayeeIdentifier";
  private String externalPayeeIdentifier;

  /**
   * Type of withdrawal.
   */
  public enum TypeEnum {
    BANK_TRANSFER("BANK_TRANSFER"),
    
    VCC("VCC");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_ENTRY = "entry";
  private CustomMonetaryAmount entry;

  public static final String JSON_PROPERTY_FEES = "fees";
  private List<PayoutFeeSupplier> fees;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
  private String payoutId;

  public static final String JSON_PROPERTY_REFERENCE_CODE = "referenceCode";
  private String referenceCode;

  public static final String JSON_PROPERTY_REFERENCE_CODE_DATE = "referenceCodeDate";
  private java.time.LocalDateTime referenceCodeDate;

  /**
   * Status of withdrawal.
   */
  public enum StatusEnum {
    INITIATED("INITIATED"),
    
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    FAILED("FAILED"),
    
    CANCELLED("CANCELLED"),
    
    COMPLETE("COMPLETE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public PayoutSupplier() {
  }

  public PayoutSupplier vendor(VendorEnum vendor) {
    
    this.vendor = vendor;
    return this;
  }

   /**
   * Name of integration vendor
   * @return vendor
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VendorEnum getVendor() {
    return vendor;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVendor(VendorEnum vendor) {
    this.vendor = vendor;
  }


  public PayoutSupplier vendorIdentifier(String vendorIdentifier) {
    
    this.vendorIdentifier = vendorIdentifier;
    return this;
  }

   /**
   * Which acquirer account we return fund from.
   * @return vendorIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVendorIdentifier() {
    return vendorIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVendorIdentifier(String vendorIdentifier) {
    this.vendorIdentifier = vendorIdentifier;
  }


  public PayoutSupplier vendorName(String vendorName) {
    
    this.vendorName = vendorName;
    return this;
  }

   /**
   * Name of regional acquirer account.
   * @return vendorName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVendorName() {
    return vendorName;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVendorName(String vendorName) {
    this.vendorName = vendorName;
  }


  public PayoutSupplier vendorTokenKey(String vendorTokenKey) {
    
    this.vendorTokenKey = vendorTokenKey;
    return this;
  }

   /**
   * Key to help load Stripe for the correct region. Could be helpful for other vendors as well.
   * @return vendorTokenKey
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VENDOR_TOKEN_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVendorTokenKey() {
    return vendorTokenKey;
  }


  @JsonProperty(JSON_PROPERTY_VENDOR_TOKEN_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVendorTokenKey(String vendorTokenKey) {
    this.vendorTokenKey = vendorTokenKey;
  }


  public PayoutSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique system ID.
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public PayoutSupplier beneficiaryIdentifier(UUID beneficiaryIdentifier) {
    
    this.beneficiaryIdentifier = beneficiaryIdentifier;
    return this;
  }

   /**
   * Beneficiary ID.
   * @return beneficiaryIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BENEFICIARY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBeneficiaryIdentifier() {
    return beneficiaryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeneficiaryIdentifier(UUID beneficiaryIdentifier) {
    this.beneficiaryIdentifier = beneficiaryIdentifier;
  }


  public PayoutSupplier externalPayeeIdentifier(String externalPayeeIdentifier) {
    
    this.externalPayeeIdentifier = externalPayeeIdentifier;
    return this;
  }

   /**
   * This would be the cardholder ID for VCCs.
   * @return externalPayeeIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalPayeeIdentifier() {
    return externalPayeeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalPayeeIdentifier(String externalPayeeIdentifier) {
    this.externalPayeeIdentifier = externalPayeeIdentifier;
  }


  public PayoutSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of withdrawal.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public PayoutSupplier entry(CustomMonetaryAmount entry) {
    
    this.entry = entry;
    return this;
  }

   /**
   * Get entry
   * @return entry
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ENTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getEntry() {
    return entry;
  }


  @JsonProperty(JSON_PROPERTY_ENTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntry(CustomMonetaryAmount entry) {
    this.entry = entry;
  }


  public PayoutSupplier fees(List<PayoutFeeSupplier> fees) {
    
    this.fees = fees;
    return this;
  }

  public PayoutSupplier addFeesItem(PayoutFeeSupplier feesItem) {
    if (this.fees == null) {
      this.fees = new ArrayList<>();
    }
    this.fees.add(feesItem);
    return this;
  }

   /**
   * Fees incurred when making the withdrawal.
   * @return fees
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PayoutFeeSupplier> getFees() {
    return fees;
  }


  @JsonProperty(JSON_PROPERTY_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFees(List<PayoutFeeSupplier> fees) {
    this.fees = fees;
  }


  public PayoutSupplier created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * When the payout record was created.
   * @return created
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public PayoutSupplier description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Textual response from provider
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public PayoutSupplier payoutId(String payoutId) {
    
    this.payoutId = payoutId;
    return this;
  }

   /**
   * The identifier that was generated when scheduling the payout. This will come from the payout provider such as Stripe.
   * @return payoutId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAYOUT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutId() {
    return payoutId;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayoutId(String payoutId) {
    this.payoutId = payoutId;
  }


  public PayoutSupplier referenceCode(String referenceCode) {
    
    this.referenceCode = referenceCode;
    return this;
  }

   /**
   * The transaction code that was generated when the funds move out of TripPay&#39;s account. This will come from the payout provider such as Stripe. E.g. For VCCs, it will occur when an authorization takes place.
   * @return referenceCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReferenceCode() {
    return referenceCode;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceCode(String referenceCode) {
    this.referenceCode = referenceCode;
  }


  public PayoutSupplier referenceCodeDate(java.time.LocalDateTime referenceCodeDate) {
    
    this.referenceCodeDate = referenceCodeDate;
    return this;
  }

   /**
   * The time the funds were withdrawn
   * @return referenceCodeDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getReferenceCodeDate() {
    return referenceCodeDate;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE_CODE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReferenceCodeDate(java.time.LocalDateTime referenceCodeDate) {
    this.referenceCodeDate = referenceCodeDate;
  }


  public PayoutSupplier status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Status of withdrawal.
   * @return status
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutSupplier payoutSupplier = (PayoutSupplier) o;
    return Objects.equals(this.vendor, payoutSupplier.vendor) &&
        Objects.equals(this.vendorIdentifier, payoutSupplier.vendorIdentifier) &&
        Objects.equals(this.vendorName, payoutSupplier.vendorName) &&
        Objects.equals(this.vendorTokenKey, payoutSupplier.vendorTokenKey) &&
        Objects.equals(this.identifier, payoutSupplier.identifier) &&
        Objects.equals(this.beneficiaryIdentifier, payoutSupplier.beneficiaryIdentifier) &&
        Objects.equals(this.externalPayeeIdentifier, payoutSupplier.externalPayeeIdentifier) &&
        Objects.equals(this.type, payoutSupplier.type) &&
        Objects.equals(this.entry, payoutSupplier.entry) &&
        Objects.equals(this.fees, payoutSupplier.fees) &&
        Objects.equals(this.created, payoutSupplier.created) &&
        Objects.equals(this.description, payoutSupplier.description) &&
        Objects.equals(this.payoutId, payoutSupplier.payoutId) &&
        Objects.equals(this.referenceCode, payoutSupplier.referenceCode) &&
        Objects.equals(this.referenceCodeDate, payoutSupplier.referenceCodeDate) &&
        Objects.equals(this.status, payoutSupplier.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(vendor, vendorIdentifier, vendorName, vendorTokenKey, identifier, beneficiaryIdentifier, externalPayeeIdentifier, type, entry, fees, created, description, payoutId, referenceCode, referenceCodeDate, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutSupplier {\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    vendorIdentifier: ").append(toIndentedString(vendorIdentifier)).append("\n");
    sb.append("    vendorName: ").append(toIndentedString(vendorName)).append("\n");
    sb.append("    vendorTokenKey: ").append(toIndentedString(vendorTokenKey)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    beneficiaryIdentifier: ").append(toIndentedString(beneficiaryIdentifier)).append("\n");
    sb.append("    externalPayeeIdentifier: ").append(toIndentedString(externalPayeeIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    entry: ").append(toIndentedString(entry)).append("\n");
    sb.append("    fees: ").append(toIndentedString(fees)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    payoutId: ").append(toIndentedString(payoutId)).append("\n");
    sb.append("    referenceCode: ").append(toIndentedString(referenceCode)).append("\n");
    sb.append("    referenceCodeDate: ").append(toIndentedString(referenceCodeDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

