/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.PayoutFeeSupplierDetails;

@JsonPropertyOrder(value={"vendor", "vendorIdentifier", "vendorName", "vendorTokenKey", "identifier", "beneficiaryIdentifier", "externalPayeeIdentifier", "type", "entry", "fees", "created", "description", "payoutId", "referenceCode", "referenceCodeDate", "status"})
@JsonTypeName(value="Payout_SupplierDetails")
public class PayoutSupplierDetails {
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    private VendorEnum vendor;
    public static final String JSON_PROPERTY_VENDOR_IDENTIFIER = "vendorIdentifier";
    private String vendorIdentifier;
    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;
    public static final String JSON_PROPERTY_VENDOR_TOKEN_KEY = "vendorTokenKey";
    private String vendorTokenKey;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_BENEFICIARY_IDENTIFIER = "beneficiaryIdentifier";
    private UUID beneficiaryIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER = "externalPayeeIdentifier";
    private String externalPayeeIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ENTRY = "entry";
    private CustomMonetaryAmount entry;
    public static final String JSON_PROPERTY_FEES = "fees";
    private List<PayoutFeeSupplierDetails> fees;
    public static final String JSON_PROPERTY_CREATED = "created";
    private LocalDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
    private String payoutId;
    public static final String JSON_PROPERTY_REFERENCE_CODE = "referenceCode";
    private String referenceCode;
    public static final String JSON_PROPERTY_REFERENCE_CODE_DATE = "referenceCodeDate";
    private LocalDateTime referenceCodeDate;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public PayoutSupplierDetails vendor(VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nullable
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VendorEnum getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVendor(VendorEnum vendor) {
        this.vendor = vendor;
    }

    public PayoutSupplierDetails vendorIdentifier(String vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="vendorIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVendorIdentifier() {
        return this.vendorIdentifier;
    }

    @JsonProperty(value="vendorIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVendorIdentifier(String vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
    }

    public PayoutSupplierDetails vendorName(String vendorName) {
        this.vendorName = vendorName;
        return this;
    }

    @Nullable
    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVendorName() {
        return this.vendorName;
    }

    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public PayoutSupplierDetails vendorTokenKey(String vendorTokenKey) {
        this.vendorTokenKey = vendorTokenKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="vendorTokenKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVendorTokenKey() {
        return this.vendorTokenKey;
    }

    @JsonProperty(value="vendorTokenKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVendorTokenKey(String vendorTokenKey) {
        this.vendorTokenKey = vendorTokenKey;
    }

    public PayoutSupplierDetails identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public PayoutSupplierDetails beneficiaryIdentifier(UUID beneficiaryIdentifier) {
        this.beneficiaryIdentifier = beneficiaryIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="beneficiaryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getBeneficiaryIdentifier() {
        return this.beneficiaryIdentifier;
    }

    @JsonProperty(value="beneficiaryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBeneficiaryIdentifier(UUID beneficiaryIdentifier) {
        this.beneficiaryIdentifier = beneficiaryIdentifier;
    }

    public PayoutSupplierDetails externalPayeeIdentifier(String externalPayeeIdentifier) {
        this.externalPayeeIdentifier = externalPayeeIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalPayeeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalPayeeIdentifier() {
        return this.externalPayeeIdentifier;
    }

    @JsonProperty(value="externalPayeeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalPayeeIdentifier(String externalPayeeIdentifier) {
        this.externalPayeeIdentifier = externalPayeeIdentifier;
    }

    public PayoutSupplierDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PayoutSupplierDetails entry(CustomMonetaryAmount entry) {
        this.entry = entry;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getEntry() {
        return this.entry;
    }

    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntry(CustomMonetaryAmount entry) {
        this.entry = entry;
    }

    public PayoutSupplierDetails fees(List<PayoutFeeSupplierDetails> fees) {
        this.fees = fees;
        return this;
    }

    public PayoutSupplierDetails addFeesItem(PayoutFeeSupplierDetails feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList<PayoutFeeSupplierDetails>();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PayoutFeeSupplierDetails> getFees() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFees(List<PayoutFeeSupplierDetails> fees) {
        this.fees = fees;
    }

    public PayoutSupplierDetails created(LocalDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public PayoutSupplierDetails description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PayoutSupplierDetails payoutId(String payoutId) {
        this.payoutId = payoutId;
        return this;
    }

    @Nullable
    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutId() {
        return this.payoutId;
    }

    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutId(String payoutId) {
        this.payoutId = payoutId;
    }

    public PayoutSupplierDetails referenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="referenceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceCode() {
        return this.referenceCode;
    }

    @JsonProperty(value="referenceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public PayoutSupplierDetails referenceCodeDate(LocalDateTime referenceCodeDate) {
        this.referenceCodeDate = referenceCodeDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="referenceCodeDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getReferenceCodeDate() {
        return this.referenceCodeDate;
    }

    @JsonProperty(value="referenceCodeDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceCodeDate(LocalDateTime referenceCodeDate) {
        this.referenceCodeDate = referenceCodeDate;
    }

    public PayoutSupplierDetails status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutSupplierDetails payoutSupplierDetails = (PayoutSupplierDetails)o;
        return Objects.equals((Object)this.vendor, (Object)payoutSupplierDetails.vendor) && Objects.equals(this.vendorIdentifier, payoutSupplierDetails.vendorIdentifier) && Objects.equals(this.vendorName, payoutSupplierDetails.vendorName) && Objects.equals(this.vendorTokenKey, payoutSupplierDetails.vendorTokenKey) && Objects.equals(this.identifier, payoutSupplierDetails.identifier) && Objects.equals(this.beneficiaryIdentifier, payoutSupplierDetails.beneficiaryIdentifier) && Objects.equals(this.externalPayeeIdentifier, payoutSupplierDetails.externalPayeeIdentifier) && Objects.equals((Object)this.type, (Object)payoutSupplierDetails.type) && Objects.equals(this.entry, payoutSupplierDetails.entry) && Objects.equals(this.fees, payoutSupplierDetails.fees) && Objects.equals(this.created, payoutSupplierDetails.created) && Objects.equals(this.description, payoutSupplierDetails.description) && Objects.equals(this.payoutId, payoutSupplierDetails.payoutId) && Objects.equals(this.referenceCode, payoutSupplierDetails.referenceCode) && Objects.equals(this.referenceCodeDate, payoutSupplierDetails.referenceCodeDate) && Objects.equals((Object)this.status, (Object)payoutSupplierDetails.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendor, this.vendorIdentifier, this.vendorName, this.vendorTokenKey, this.identifier, this.beneficiaryIdentifier, this.externalPayeeIdentifier, this.type, this.entry, this.fees, this.created, this.description, this.payoutId, this.referenceCode, this.referenceCodeDate, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutSupplierDetails {\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("    vendorIdentifier: ").append(this.toIndentedString(this.vendorIdentifier)).append("\n");
        sb.append("    vendorName: ").append(this.toIndentedString(this.vendorName)).append("\n");
        sb.append("    vendorTokenKey: ").append(this.toIndentedString(this.vendorTokenKey)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    beneficiaryIdentifier: ").append(this.toIndentedString(this.beneficiaryIdentifier)).append("\n");
        sb.append("    externalPayeeIdentifier: ").append(this.toIndentedString(this.externalPayeeIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    entry: ").append(this.toIndentedString(this.entry)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    referenceCode: ").append(this.toIndentedString(this.referenceCode)).append("\n");
        sb.append("    referenceCodeDate: ").append(this.toIndentedString(this.referenceCodeDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VendorEnum {
        STRIPE("STRIPE"),
        AGENT("AGENT"),
        WISE("WISE");

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BANK_TRANSFER("BANK_TRANSFER"),
        VCC("VCC");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        INITIATED("INITIATED"),
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        FAILED("FAILED"),
        CANCELLED("CANCELLED"),
        COMPLETE("COMPLETE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

