package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.HotelViewSupplier;
import travel.wink.sdk.extranet.model.MultimediaViewSupplier;
import travel.wink.sdk.extranet.model.PropertyRegistrationRequestSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-03T16:31:02.054814418+07:00[Asia/Bangkok]")
public class OnboardingApi {
    private ApiClient apiClient;

    public OnboardingApi() {
        this(new ApiClient());
    }

    @Autowired
    public OnboardingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Register property
     * Registers a new property with the wink.travel payment. This is the minimum required dataset to onboard a property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param propertyRegistrationRequestSupplier The propertyRegistrationRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec registerHotelRequestCreation(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyRegistrationRequestSupplier;
        // verify the required parameter 'propertyRegistrationRequestSupplier' is set
        if (propertyRegistrationRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyRegistrationRequestSupplier' when calling registerHotel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/register", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Register property
     * Registers a new property with the wink.travel payment. This is the minimum required dataset to onboard a property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param propertyRegistrationRequestSupplier The propertyRegistrationRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> registerHotel(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return registerHotelRequestCreation(propertyRegistrationRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Register property
     * Registers a new property with the wink.travel payment. This is the minimum required dataset to onboard a property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param propertyRegistrationRequestSupplier The propertyRegistrationRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> registerHotelWithHttpInfo(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return registerHotelRequestCreation(propertyRegistrationRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Register property
     * Registers a new property with the wink.travel payment. This is the minimum required dataset to onboard a property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param propertyRegistrationRequestSupplier The propertyRegistrationRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec registerHotelWithResponseSpec(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        return registerHotelRequestCreation(propertyRegistrationRequestSupplier, winkVersion);
    }
    /**
     * Upload hotel logo
     * Upload images of hotel logo that wink.travel can use for marketing purposes.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Property identifier
     * @param files Multipart file array
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadHotelLogosRequestCreation(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadHotelLogos", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadHotelLogos", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/logo", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload hotel logo
     * Upload images of hotel logo that wink.travel can use for marketing purposes.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Property identifier
     * @param files Multipart file array
     * @return List&lt;MultimediaViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MultimediaViewSupplier> uploadHotelLogos(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return uploadHotelLogosRequestCreation(hotelIdentifier, files).bodyToFlux(localVarReturnType);
    }

    /**
     * Upload hotel logo
     * Upload images of hotel logo that wink.travel can use for marketing purposes.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Property identifier
     * @param files Multipart file array
     * @return ResponseEntity&lt;List&lt;MultimediaViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MultimediaViewSupplier>>> uploadHotelLogosWithHttpInfo(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>() {};
        return uploadHotelLogosRequestCreation(hotelIdentifier, files).toEntityList(localVarReturnType);
    }

    /**
     * Upload hotel logo
     * Upload images of hotel logo that wink.travel can use for marketing purposes.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Property identifier
     * @param files Multipart file array
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadHotelLogosWithResponseSpec(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        return uploadHotelLogosRequestCreation(hotelIdentifier, files);
    }
}
