package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.PropertyPolicySupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-03T16:31:02.054814418+07:00[Asia/Bangkok]")
public class PolicyApi {
    private ApiClient apiClient;

    public PolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create property policy for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPolicyRequestCreation(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyPolicySupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyPolicySupplier' is set
        if (propertyPolicySupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicySupplier' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create property policy for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyPolicySupplier> createPolicy(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return createPolicyRequestCreation(hotelIdentifier, propertyPolicySupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create property policy for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PropertyPolicySupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PropertyPolicySupplier>> createPolicyWithHttpInfo(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return createPolicyRequestCreation(hotelIdentifier, propertyPolicySupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create property policy for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPolicyWithResponseSpec(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        return createPolicyRequestCreation(hotelIdentifier, propertyPolicySupplier, winkVersion);
    }
    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property policy for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyPolicyRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property policy for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyPolicySupplier> showPropertyPolicy(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return showPropertyPolicyRequestCreation(hotelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property policy for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PropertyPolicySupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PropertyPolicySupplier>> showPropertyPolicyWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return showPropertyPolicyRequestCreation(hotelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Retrieve property policy for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyPolicyWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showPropertyPolicyRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update property policy record for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePropertyPolicyRequestCreation(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyPolicySupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyPolicySupplier' is set
        if (propertyPolicySupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicySupplier' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/policy/property", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update property policy record for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyPolicySupplier> updatePropertyPolicy(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return updatePropertyPolicyRequestCreation(hotelIdentifier, propertyPolicySupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update property policy record for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PropertyPolicySupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PropertyPolicySupplier>> updatePropertyPolicyWithHttpInfo(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return updatePropertyPolicyRequestCreation(hotelIdentifier, propertyPolicySupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update property policy record for this hotel identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updatePropertyPolicyWithResponseSpec(String hotelIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        return updatePropertyPolicyRequestCreation(hotelIdentifier, propertyPolicySupplier, winkVersion);
    }
}
