/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.RatePlanViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.UpsertRatePlanRequestSupplier;

public class RatePlanApi {
    private ApiClient apiClient;

    public RatePlanApi() {
        this(new ApiClient());
    }

    @Autowired
    public RatePlanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRatePlanRequestCreation(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRatePlanRequestSupplier postBody = upsertRatePlanRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanViewSupplier> createRatePlan(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanViewSupplier>> createRatePlanWithHttpInfo(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRatePlanWithResponseSpec(String hotelIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createRatePlanRequestCreation(hotelIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeRatePlan(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRatePlanWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanViewSupplier> showRatePlan(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanViewSupplier>> showRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRatePlanWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRatePlansRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlans", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RatePlanViewSupplier> showRatePlans(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.showRatePlansRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RatePlanViewSupplier>>> showRatePlansWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.showRatePlansRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRatePlansWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showRatePlansRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateRatePlanRequestCreation(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRatePlanRequestSupplier postBody = upsertRatePlanRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanViewSupplier> updateRatePlan(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanViewSupplier>> updateRatePlanWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>(this){};
        return this.updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRatePlanWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateRatePlanRequestCreation(hotelIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }
}

