/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"roomTypeIdentifier", "ratePlanIdentifier", "perkTypes"})
@JsonTypeName(value="CreateMasterRateRequest_Supplier")
public class CreateMasterRateRequestSupplier {
    public static final String JSON_PROPERTY_ROOM_TYPE_IDENTIFIER = "roomTypeIdentifier";
    private UUID roomTypeIdentifier;
    public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
    private UUID ratePlanIdentifier;
    public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
    private List<PerkTypesEnum> perkTypes;

    public CreateMasterRateRequestSupplier roomTypeIdentifier(UUID roomTypeIdentifier) {
        this.roomTypeIdentifier = roomTypeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="roomTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRoomTypeIdentifier() {
        return this.roomTypeIdentifier;
    }

    @JsonProperty(value="roomTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomTypeIdentifier(UUID roomTypeIdentifier) {
        this.roomTypeIdentifier = roomTypeIdentifier;
    }

    public CreateMasterRateRequestSupplier ratePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRatePlanIdentifier() {
        return this.ratePlanIdentifier;
    }

    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
    }

    public CreateMasterRateRequestSupplier perkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
        return this;
    }

    public CreateMasterRateRequestSupplier addPerkTypesItem(PerkTypesEnum perkTypesItem) {
        if (this.perkTypes == null) {
            this.perkTypes = new ArrayList<PerkTypesEnum>();
        }
        this.perkTypes.add(perkTypesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PerkTypesEnum> getPerkTypes() {
        return this.perkTypes;
    }

    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
        this.perkTypes = perkTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMasterRateRequestSupplier createMasterRateRequestSupplier = (CreateMasterRateRequestSupplier)o;
        return Objects.equals(this.roomTypeIdentifier, createMasterRateRequestSupplier.roomTypeIdentifier) && Objects.equals(this.ratePlanIdentifier, createMasterRateRequestSupplier.ratePlanIdentifier) && Objects.equals(this.perkTypes, createMasterRateRequestSupplier.perkTypes);
    }

    public int hashCode() {
        return Objects.hash(this.roomTypeIdentifier, this.ratePlanIdentifier, this.perkTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMasterRateRequestSupplier {\n");
        sb.append("    roomTypeIdentifier: ").append(this.toIndentedString(this.roomTypeIdentifier)).append("\n");
        sb.append("    ratePlanIdentifier: ").append(this.toIndentedString(this.ratePlanIdentifier)).append("\n");
        sb.append("    perkTypes: ").append(this.toIndentedString(this.perkTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PerkTypesEnum {
        LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
        WINE("PERK_WINE"),
        FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
        FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
        FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
        TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
        TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
        GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
        EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
        ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
        LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
        AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
        AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
        BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
        BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
        BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

        private String value;

        private PerkTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PerkTypesEnum fromValue(String value) {
            for (PerkTypesEnum b : PerkTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

