/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.3.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CouponSupplier
 */
@JsonPropertyOrder({
  CouponSupplier.JSON_PROPERTY_AMOUNT_OFF,
  CouponSupplier.JSON_PROPERTY_CREATED,
  CouponSupplier.JSON_PROPERTY_CURRENCY,
  CouponSupplier.JSON_PROPERTY_DELETED,
  CouponSupplier.JSON_PROPERTY_DURATION,
  CouponSupplier.JSON_PROPERTY_DURATION_IN_MONTHS,
  CouponSupplier.JSON_PROPERTY_ID,
  CouponSupplier.JSON_PROPERTY_LIVEMODE,
  CouponSupplier.JSON_PROPERTY_MAX_REDEMPTIONS,
  CouponSupplier.JSON_PROPERTY_METADATA,
  CouponSupplier.JSON_PROPERTY_NAME,
  CouponSupplier.JSON_PROPERTY_OBJECT,
  CouponSupplier.JSON_PROPERTY_PERCENT_OFF,
  CouponSupplier.JSON_PROPERTY_REDEEM_BY,
  CouponSupplier.JSON_PROPERTY_TIMES_REDEEMED,
  CouponSupplier.JSON_PROPERTY_VALID
})
@JsonTypeName("Coupon_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-06T13:39:13.055088027+07:00[Asia/Bangkok]")
public class CouponSupplier {
  public static final String JSON_PROPERTY_AMOUNT_OFF = "amountOff";
  private Long amountOff;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private String duration;

  public static final String JSON_PROPERTY_DURATION_IN_MONTHS = "durationInMonths";
  private Long durationInMonths;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_MAX_REDEMPTIONS = "maxRedemptions";
  private Long maxRedemptions;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_PERCENT_OFF = "percentOff";
  private BigDecimal percentOff;

  public static final String JSON_PROPERTY_REDEEM_BY = "redeemBy";
  private Long redeemBy;

  public static final String JSON_PROPERTY_TIMES_REDEEMED = "timesRedeemed";
  private Long timesRedeemed;

  public static final String JSON_PROPERTY_VALID = "valid";
  private Boolean valid;

  public CouponSupplier() {
  }

  public CouponSupplier amountOff(Long amountOff) {
    
    this.amountOff = amountOff;
    return this;
  }

   /**
   * Get amountOff
   * @return amountOff
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountOff() {
    return amountOff;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountOff(Long amountOff) {
    this.amountOff = amountOff;
  }


  public CouponSupplier created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public CouponSupplier currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public CouponSupplier deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public CouponSupplier duration(String duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Get duration
   * @return duration
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuration(String duration) {
    this.duration = duration;
  }


  public CouponSupplier durationInMonths(Long durationInMonths) {
    
    this.durationInMonths = durationInMonths;
    return this;
  }

   /**
   * Get durationInMonths
   * @return durationInMonths
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DURATION_IN_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDurationInMonths() {
    return durationInMonths;
  }


  @JsonProperty(JSON_PROPERTY_DURATION_IN_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDurationInMonths(Long durationInMonths) {
    this.durationInMonths = durationInMonths;
  }


  public CouponSupplier id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public CouponSupplier livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public CouponSupplier maxRedemptions(Long maxRedemptions) {
    
    this.maxRedemptions = maxRedemptions;
    return this;
  }

   /**
   * Get maxRedemptions
   * @return maxRedemptions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_REDEMPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMaxRedemptions() {
    return maxRedemptions;
  }


  @JsonProperty(JSON_PROPERTY_MAX_REDEMPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRedemptions(Long maxRedemptions) {
    this.maxRedemptions = maxRedemptions;
  }


  public CouponSupplier metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public CouponSupplier putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public CouponSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public CouponSupplier _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public CouponSupplier percentOff(BigDecimal percentOff) {
    
    this.percentOff = percentOff;
    return this;
  }

   /**
   * Get percentOff
   * @return percentOff
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PERCENT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getPercentOff() {
    return percentOff;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentOff(BigDecimal percentOff) {
    this.percentOff = percentOff;
  }


  public CouponSupplier redeemBy(Long redeemBy) {
    
    this.redeemBy = redeemBy;
    return this;
  }

   /**
   * Get redeemBy
   * @return redeemBy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REDEEM_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRedeemBy() {
    return redeemBy;
  }


  @JsonProperty(JSON_PROPERTY_REDEEM_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedeemBy(Long redeemBy) {
    this.redeemBy = redeemBy;
  }


  public CouponSupplier timesRedeemed(Long timesRedeemed) {
    
    this.timesRedeemed = timesRedeemed;
    return this;
  }

   /**
   * Get timesRedeemed
   * @return timesRedeemed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMES_REDEEMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimesRedeemed() {
    return timesRedeemed;
  }


  @JsonProperty(JSON_PROPERTY_TIMES_REDEEMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimesRedeemed(Long timesRedeemed) {
    this.timesRedeemed = timesRedeemed;
  }


  public CouponSupplier valid(Boolean valid) {
    
    this.valid = valid;
    return this;
  }

   /**
   * Get valid
   * @return valid
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValid() {
    return valid;
  }


  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValid(Boolean valid) {
    this.valid = valid;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CouponSupplier couponSupplier = (CouponSupplier) o;
    return Objects.equals(this.amountOff, couponSupplier.amountOff) &&
        Objects.equals(this.created, couponSupplier.created) &&
        Objects.equals(this.currency, couponSupplier.currency) &&
        Objects.equals(this.deleted, couponSupplier.deleted) &&
        Objects.equals(this.duration, couponSupplier.duration) &&
        Objects.equals(this.durationInMonths, couponSupplier.durationInMonths) &&
        Objects.equals(this.id, couponSupplier.id) &&
        Objects.equals(this.livemode, couponSupplier.livemode) &&
        Objects.equals(this.maxRedemptions, couponSupplier.maxRedemptions) &&
        Objects.equals(this.metadata, couponSupplier.metadata) &&
        Objects.equals(this.name, couponSupplier.name) &&
        Objects.equals(this._object, couponSupplier._object) &&
        Objects.equals(this.percentOff, couponSupplier.percentOff) &&
        Objects.equals(this.redeemBy, couponSupplier.redeemBy) &&
        Objects.equals(this.timesRedeemed, couponSupplier.timesRedeemed) &&
        Objects.equals(this.valid, couponSupplier.valid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amountOff, created, currency, deleted, duration, durationInMonths, id, livemode, maxRedemptions, metadata, name, _object, percentOff, redeemBy, timesRedeemed, valid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CouponSupplier {\n");
    sb.append("    amountOff: ").append(toIndentedString(amountOff)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    durationInMonths: ").append(toIndentedString(durationInMonths)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    maxRedemptions: ").append(toIndentedString(maxRedemptions)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    percentOff: ").append(toIndentedString(percentOff)).append("\n");
    sb.append("    redeemBy: ").append(toIndentedString(redeemBy)).append("\n");
    sb.append("    timesRedeemed: ").append(toIndentedString(timesRedeemed)).append("\n");
    sb.append("    valid: ").append(toIndentedString(valid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

