/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.VariableChargeSupplier;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "rateSource", "masterRateIdentifier", "ratePlanIdentifier", "guestRoomIdentifier", "rate", "master", "closedOnArrival", "closedOnDeparture", "date", "quantity", "minOccupancy", "maxOccupancy", "includedAdultOccupancy", "includedChildOccupancy", "maxAdultOccupancy", "maxChildOccupancy", "minLengthOfStay", "maxLengthOfStay", "singleOccupancyRateModifier", "extraPaxRateModifier", "extraChildRateModifier", "available"})
@JsonTypeName(value="Rate_Supplier")
public class RateSupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private String rateSource = "TRAVELIKO";
    public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIER = "masterRateIdentifier";
    private UUID masterRateIdentifier;
    public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
    private UUID ratePlanIdentifier;
    public static final String JSON_PROPERTY_GUEST_ROOM_IDENTIFIER = "guestRoomIdentifier";
    private UUID guestRoomIdentifier;
    public static final String JSON_PROPERTY_RATE = "rate";
    private CustomMonetaryAmount rate;
    public static final String JSON_PROPERTY_MASTER = "master";
    private Boolean master = true;
    public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
    private Boolean closedOnArrival = false;
    public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
    private Boolean closedOnDeparture = false;
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDate date;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity = 0;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    private Integer minOccupancy = 1;
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    private Integer maxOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
    private Integer includedAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
    private Integer includedChildOccupancy = 0;
    public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
    private Integer maxAdultOccupancy = 2;
    public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
    private Integer maxChildOccupancy = 0;
    public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
    private Integer minLengthOfStay = -1;
    public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
    private Integer maxLengthOfStay = -1;
    public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
    private VariableChargeSupplier singleOccupancyRateModifier;
    public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
    private VariableChargeSupplier extraPaxRateModifier;
    public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
    private VariableChargeSupplier extraChildRateModifier;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;

    public RateSupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RateSupplier hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RateSupplier rateSource(String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRateSource(String rateSource) {
        this.rateSource = rateSource;
    }

    public RateSupplier masterRateIdentifier(UUID masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getMasterRateIdentifier() {
        return this.masterRateIdentifier;
    }

    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMasterRateIdentifier(UUID masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
    }

    public RateSupplier ratePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRatePlanIdentifier() {
        return this.ratePlanIdentifier;
    }

    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
    }

    public RateSupplier guestRoomIdentifier(UUID guestRoomIdentifier) {
        this.guestRoomIdentifier = guestRoomIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="guestRoomIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getGuestRoomIdentifier() {
        return this.guestRoomIdentifier;
    }

    @JsonProperty(value="guestRoomIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuestRoomIdentifier(UUID guestRoomIdentifier) {
        this.guestRoomIdentifier = guestRoomIdentifier;
    }

    public RateSupplier rate(CustomMonetaryAmount rate) {
        this.rate = rate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getRate() {
        return this.rate;
    }

    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRate(CustomMonetaryAmount rate) {
        this.rate = rate;
    }

    public RateSupplier master(Boolean master) {
        this.master = master;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getMaster() {
        return this.master;
    }

    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaster(Boolean master) {
        this.master = master;
    }

    public RateSupplier closedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnArrival() {
        return this.closedOnArrival;
    }

    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
    }

    public RateSupplier closedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnDeparture() {
        return this.closedOnDeparture;
    }

    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
    }

    public RateSupplier date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public RateSupplier quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public RateSupplier minOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public RateSupplier maxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public RateSupplier includedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedAdultOccupancy() {
        return this.includedAdultOccupancy;
    }

    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
    }

    public RateSupplier includedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedChildOccupancy() {
        return this.includedChildOccupancy;
    }

    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
    }

    public RateSupplier maxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxAdultOccupancy() {
        return this.maxAdultOccupancy;
    }

    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
    }

    public RateSupplier maxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxChildOccupancy() {
        return this.maxChildOccupancy;
    }

    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
    }

    public RateSupplier minLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
        return this;
    }

    @Nullable
    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLengthOfStay() {
        return this.minLengthOfStay;
    }

    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
    }

    public RateSupplier maxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLengthOfStay() {
        return this.maxLengthOfStay;
    }

    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
    }

    public RateSupplier singleOccupancyRateModifier(VariableChargeSupplier singleOccupancyRateModifier) {
        this.singleOccupancyRateModifier = singleOccupancyRateModifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="singleOccupancyRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VariableChargeSupplier getSingleOccupancyRateModifier() {
        return this.singleOccupancyRateModifier;
    }

    @JsonProperty(value="singleOccupancyRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSingleOccupancyRateModifier(VariableChargeSupplier singleOccupancyRateModifier) {
        this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    }

    public RateSupplier extraPaxRateModifier(VariableChargeSupplier extraPaxRateModifier) {
        this.extraPaxRateModifier = extraPaxRateModifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="extraPaxRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VariableChargeSupplier getExtraPaxRateModifier() {
        return this.extraPaxRateModifier;
    }

    @JsonProperty(value="extraPaxRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraPaxRateModifier(VariableChargeSupplier extraPaxRateModifier) {
        this.extraPaxRateModifier = extraPaxRateModifier;
    }

    public RateSupplier extraChildRateModifier(VariableChargeSupplier extraChildRateModifier) {
        this.extraChildRateModifier = extraChildRateModifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="extraChildRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VariableChargeSupplier getExtraChildRateModifier() {
        return this.extraChildRateModifier;
    }

    @JsonProperty(value="extraChildRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraChildRateModifier(VariableChargeSupplier extraChildRateModifier) {
        this.extraChildRateModifier = extraChildRateModifier;
    }

    public RateSupplier available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateSupplier rateSupplier = (RateSupplier)o;
        return Objects.equals(this.identifier, rateSupplier.identifier) && Objects.equals(this.hotelIdentifier, rateSupplier.hotelIdentifier) && Objects.equals(this.rateSource, rateSupplier.rateSource) && Objects.equals(this.masterRateIdentifier, rateSupplier.masterRateIdentifier) && Objects.equals(this.ratePlanIdentifier, rateSupplier.ratePlanIdentifier) && Objects.equals(this.guestRoomIdentifier, rateSupplier.guestRoomIdentifier) && Objects.equals(this.rate, rateSupplier.rate) && Objects.equals(this.master, rateSupplier.master) && Objects.equals(this.closedOnArrival, rateSupplier.closedOnArrival) && Objects.equals(this.closedOnDeparture, rateSupplier.closedOnDeparture) && Objects.equals(this.date, rateSupplier.date) && Objects.equals(this.quantity, rateSupplier.quantity) && Objects.equals(this.minOccupancy, rateSupplier.minOccupancy) && Objects.equals(this.maxOccupancy, rateSupplier.maxOccupancy) && Objects.equals(this.includedAdultOccupancy, rateSupplier.includedAdultOccupancy) && Objects.equals(this.includedChildOccupancy, rateSupplier.includedChildOccupancy) && Objects.equals(this.maxAdultOccupancy, rateSupplier.maxAdultOccupancy) && Objects.equals(this.maxChildOccupancy, rateSupplier.maxChildOccupancy) && Objects.equals(this.minLengthOfStay, rateSupplier.minLengthOfStay) && Objects.equals(this.maxLengthOfStay, rateSupplier.maxLengthOfStay) && Objects.equals(this.singleOccupancyRateModifier, rateSupplier.singleOccupancyRateModifier) && Objects.equals(this.extraPaxRateModifier, rateSupplier.extraPaxRateModifier) && Objects.equals(this.extraChildRateModifier, rateSupplier.extraChildRateModifier) && Objects.equals(this.available, rateSupplier.available);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.hotelIdentifier, this.rateSource, this.masterRateIdentifier, this.ratePlanIdentifier, this.guestRoomIdentifier, this.rate, this.master, this.closedOnArrival, this.closedOnDeparture, this.date, this.quantity, this.minOccupancy, this.maxOccupancy, this.includedAdultOccupancy, this.includedChildOccupancy, this.maxAdultOccupancy, this.maxChildOccupancy, this.minLengthOfStay, this.maxLengthOfStay, this.singleOccupancyRateModifier, this.extraPaxRateModifier, this.extraChildRateModifier, this.available);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RateSupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    masterRateIdentifier: ").append(this.toIndentedString(this.masterRateIdentifier)).append("\n");
        sb.append("    ratePlanIdentifier: ").append(this.toIndentedString(this.ratePlanIdentifier)).append("\n");
        sb.append("    guestRoomIdentifier: ").append(this.toIndentedString(this.guestRoomIdentifier)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    master: ").append(this.toIndentedString(this.master)).append("\n");
        sb.append("    closedOnArrival: ").append(this.toIndentedString(this.closedOnArrival)).append("\n");
        sb.append("    closedOnDeparture: ").append(this.toIndentedString(this.closedOnDeparture)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    includedAdultOccupancy: ").append(this.toIndentedString(this.includedAdultOccupancy)).append("\n");
        sb.append("    includedChildOccupancy: ").append(this.toIndentedString(this.includedChildOccupancy)).append("\n");
        sb.append("    maxAdultOccupancy: ").append(this.toIndentedString(this.maxAdultOccupancy)).append("\n");
        sb.append("    maxChildOccupancy: ").append(this.toIndentedString(this.maxChildOccupancy)).append("\n");
        sb.append("    minLengthOfStay: ").append(this.toIndentedString(this.minLengthOfStay)).append("\n");
        sb.append("    maxLengthOfStay: ").append(this.toIndentedString(this.maxLengthOfStay)).append("\n");
        sb.append("    singleOccupancyRateModifier: ").append(this.toIndentedString(this.singleOccupancyRateModifier)).append("\n");
        sb.append("    extraPaxRateModifier: ").append(this.toIndentedString(this.extraPaxRateModifier)).append("\n");
        sb.append("    extraChildRateModifier: ").append(this.toIndentedString(this.extraChildRateModifier)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

