/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.30.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.BedroomConfigurationSupplier;
import travel.wink.sdk.extranet.model.CancellationPolicySupplier;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.ExtraChargesSupplier;
import travel.wink.sdk.extranet.model.GuestRoomSupplier;
import travel.wink.sdk.extranet.model.PropertyPolicySupplier;
import travel.wink.sdk.extranet.model.RatePlanSupplier;
import travel.wink.sdk.extranet.model.StayRateSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * All information about the room that was booked.
 */
@JsonPropertyOrder({
  RoomStaySupplier.JSON_PROPERTY_POLICY,
  RoomStaySupplier.JSON_PROPERTY_ROOM,
  RoomStaySupplier.JSON_PROPERTY_ROOMS,
  RoomStaySupplier.JSON_PROPERTY_BEDROOM_CONFIGURATION,
  RoomStaySupplier.JSON_PROPERTY_ADULTS,
  RoomStaySupplier.JSON_PROPERTY_CHILDREN,
  RoomStaySupplier.JSON_PROPERTY_START_DATE,
  RoomStaySupplier.JSON_PROPERTY_END_DATE,
  RoomStaySupplier.JSON_PROPERTY_PRICE,
  RoomStaySupplier.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomStaySupplier.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomStaySupplier.JSON_PROPERTY_RATE_PLAN,
  RoomStaySupplier.JSON_PROPERTY_PERK_TYPES,
  RoomStaySupplier.JSON_PROPERTY_EXTRA_CHARGES,
  RoomStaySupplier.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomStaySupplier.JSON_PROPERTY_CANCELLABLE_BY_HOTEL,
  RoomStaySupplier.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE,
  RoomStaySupplier.JSON_PROPERTY_CANCELLABLE,
  RoomStaySupplier.JSON_PROPERTY_SOURCE_TOTAL,
  RoomStaySupplier.JSON_PROPERTY_ROOM_NIGHTS,
  RoomStaySupplier.JSON_PROPERTY_RATE_SOURCE,
  RoomStaySupplier.JSON_PROPERTY_GUESTS,
  RoomStaySupplier.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  RoomStaySupplier.JSON_PROPERTY_INTERNAL_TOTAL
})
@JsonTypeName("RoomStay_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-12-27T18:01:39.058537384+07:00[Asia/Bangkok]")
public class RoomStaySupplier {
  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicySupplier policy;

  public static final String JSON_PROPERTY_ROOM = "room";
  private GuestRoomSupplier room;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms = 1;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION = "bedroomConfiguration";
  private BedroomConfigurationSupplier bedroomConfiguration;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults = 2;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children = 0;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_PRICE = "price";
  private StayRateSupplier price;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RatePlanSupplier ratePlan;

  /**
   * List of perks that came with the master rate
   */
  public enum PerkTypesEnum {
    LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
    
    WINE("PERK_WINE"),
    
    FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
    
    FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
    
    FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
    
    TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
    
    EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
    
    ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
    
    LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
    
    AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
    
    AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
    
    BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
    
    BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
    
    BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL");

    private String value;

    PerkTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PerkTypesEnum fromValue(String value) {
      for (PerkTypesEnum b : PerkTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  private List<PerkTypesEnum> perkTypes;

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  private ExtraChargesSupplier extraCharges;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  private CancellationPolicySupplier activeCancellationPolicy;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
  private Boolean cancellableByHotel;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
  private Boolean cancellableWithPotentialCharge;

  public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
  private Boolean cancellable;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  private Long roomNights;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private CustomMonetaryAmount internalTotal;

  public RoomStaySupplier() {
  }

  public RoomStaySupplier policy(PropertyPolicySupplier policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PropertyPolicySupplier getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPolicy(PropertyPolicySupplier policy) {
    this.policy = policy;
  }


  public RoomStaySupplier room(GuestRoomSupplier room) {
    
    this.room = room;
    return this;
  }

   /**
   * Get room
   * @return room
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestRoomSupplier getRoom() {
    return room;
  }


  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoom(GuestRoomSupplier room) {
    this.room = room;
  }


  public RoomStaySupplier rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Number of rooms. Always 1 since we switched to creating one booking per room.
   * @return rooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public RoomStaySupplier bedroomConfiguration(BedroomConfigurationSupplier bedroomConfiguration) {
    
    this.bedroomConfiguration = bedroomConfiguration;
    return this;
  }

   /**
   * Get bedroomConfiguration
   * @return bedroomConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BedroomConfigurationSupplier getBedroomConfiguration() {
    return bedroomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBedroomConfiguration(BedroomConfigurationSupplier bedroomConfiguration) {
    this.bedroomConfiguration = bedroomConfiguration;
  }


  public RoomStaySupplier adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * The actual amount of adults as determined by the hotel&#39;s policy.
   * @return adults
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public RoomStaySupplier children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * The actual amount of children as determined by the hotel&#39;s policy.
   * @return children
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public RoomStaySupplier startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Stay start date
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public RoomStaySupplier endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Stay end date
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public RoomStaySupplier price(StayRateSupplier price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StayRateSupplier getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(StayRateSupplier price) {
    this.price = price;
  }


  public RoomStaySupplier roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Master rate identifier
   * @return roomRateIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public RoomStaySupplier roomRateInternalName(String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

   /**
   * Master rate internal name
   * @return roomRateInternalName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateInternalName(String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }


  public RoomStaySupplier ratePlan(RatePlanSupplier ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RatePlanSupplier getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlan(RatePlanSupplier ratePlan) {
    this.ratePlan = ratePlan;
  }


  public RoomStaySupplier perkTypes(List<PerkTypesEnum> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomStaySupplier addPerkTypesItem(PerkTypesEnum perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

   /**
   * List of perks that came with the master rate
   * @return perkTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PerkTypesEnum> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
    this.perkTypes = perkTypes;
  }


  public RoomStaySupplier extraCharges(ExtraChargesSupplier extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

   /**
   * Get extraCharges
   * @return extraCharges
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ExtraChargesSupplier getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraCharges(ExtraChargesSupplier extraCharges) {
    this.extraCharges = extraCharges;
  }


  public RoomStaySupplier activeCancellationPolicy(CancellationPolicySupplier activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

   /**
   * Get activeCancellationPolicy
   * @return activeCancellationPolicy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationPolicySupplier getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActiveCancellationPolicy(CancellationPolicySupplier activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }


  public RoomStaySupplier cancellableByHotel(Boolean cancellableByHotel) {
    
    this.cancellableByHotel = cancellableByHotel;
    return this;
  }

   /**
   * Get cancellableByHotel
   * @return cancellableByHotel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByHotel() {
    return cancellableByHotel;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByHotel(Boolean cancellableByHotel) {
    this.cancellableByHotel = cancellableByHotel;
  }


  public RoomStaySupplier cancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    return this;
  }

   /**
   * Get cancellableWithPotentialCharge
   * @return cancellableWithPotentialCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharge() {
    return cancellableWithPotentialCharge;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
  }


  public RoomStaySupplier cancellable(Boolean cancellable) {
    
    this.cancellable = cancellable;
    return this;
  }

   /**
   * Get cancellable
   * @return cancellable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellable() {
    return cancellable;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellable(Boolean cancellable) {
    this.cancellable = cancellable;
  }


  public RoomStaySupplier sourceTotal(CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public RoomStaySupplier roomNights(Long roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

   /**
   * Total number of nights the guest stays at the hotel. -1 indicates there is an error.
   * @return roomNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNights(Long roomNights) {
    this.roomNights = roomNights;
  }


  public RoomStaySupplier rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Get rateSource
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public RoomStaySupplier guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Get guests
   * @return guests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }


  public RoomStaySupplier userSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public RoomStaySupplier internalTotal(CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomStaySupplier roomStaySupplier = (RoomStaySupplier) o;
    return Objects.equals(this.policy, roomStaySupplier.policy) &&
        Objects.equals(this.room, roomStaySupplier.room) &&
        Objects.equals(this.rooms, roomStaySupplier.rooms) &&
        Objects.equals(this.bedroomConfiguration, roomStaySupplier.bedroomConfiguration) &&
        Objects.equals(this.adults, roomStaySupplier.adults) &&
        Objects.equals(this.children, roomStaySupplier.children) &&
        Objects.equals(this.startDate, roomStaySupplier.startDate) &&
        Objects.equals(this.endDate, roomStaySupplier.endDate) &&
        Objects.equals(this.price, roomStaySupplier.price) &&
        Objects.equals(this.roomRateIdentifier, roomStaySupplier.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomStaySupplier.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomStaySupplier.ratePlan) &&
        Objects.equals(this.perkTypes, roomStaySupplier.perkTypes) &&
        Objects.equals(this.extraCharges, roomStaySupplier.extraCharges) &&
        Objects.equals(this.activeCancellationPolicy, roomStaySupplier.activeCancellationPolicy) &&
        Objects.equals(this.cancellableByHotel, roomStaySupplier.cancellableByHotel) &&
        Objects.equals(this.cancellableWithPotentialCharge, roomStaySupplier.cancellableWithPotentialCharge) &&
        Objects.equals(this.cancellable, roomStaySupplier.cancellable) &&
        Objects.equals(this.sourceTotal, roomStaySupplier.sourceTotal) &&
        Objects.equals(this.roomNights, roomStaySupplier.roomNights) &&
        Objects.equals(this.rateSource, roomStaySupplier.rateSource) &&
        Objects.equals(this.guests, roomStaySupplier.guests) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomStaySupplier.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, roomStaySupplier.internalTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(policy, room, rooms, bedroomConfiguration, adults, children, startDate, endDate, price, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, extraCharges, activeCancellationPolicy, cancellableByHotel, cancellableWithPotentialCharge, cancellable, sourceTotal, roomNights, rateSource, guests, userSpecifiedCurrencyTotal, internalTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomStaySupplier {\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    room: ").append(toIndentedString(room)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    bedroomConfiguration: ").append(toIndentedString(bedroomConfiguration)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    cancellableByHotel: ").append(toIndentedString(cancellableByHotel)).append("\n");
    sb.append("    cancellableWithPotentialCharge: ").append(toIndentedString(cancellableWithPotentialCharge)).append("\n");
    sb.append("    cancellable: ").append(toIndentedString(cancellable)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

