/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.SimpleDescription;

@JsonPropertyOrder(value={"multimediaIdentifier", "identifier", "type", "source", "sort", "angle", "width", "height", "published", "category", "descriptions", "lifestyleType", "isLandscape"})
public class SimpleMultimedia {
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
    private UUID multimediaIdentifier;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.CLOUDINARY;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort = 999;
    public static final String JSON_PROPERTY_ANGLE = "angle";
    private String angle;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height;
    public static final String JSON_PROPERTY_PUBLISHED = "published";
    private Boolean published = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private String category;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
    private Boolean isLandscape;

    public SimpleMultimedia multimediaIdentifier(UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getMultimediaIdentifier() {
        return this.multimediaIdentifier;
    }

    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimediaIdentifier(UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
    }

    public SimpleMultimedia identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public SimpleMultimedia type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SimpleMultimedia source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public SimpleMultimedia sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public SimpleMultimedia angle(String angle) {
        this.angle = angle;
        return this;
    }

    @Nullable
    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAngle() {
        return this.angle;
    }

    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAngle(String angle) {
        this.angle = angle;
    }

    public SimpleMultimedia width(Integer width) {
        this.width = width;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public SimpleMultimedia height(Integer height) {
        this.height = height;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public SimpleMultimedia published(Boolean published) {
        this.published = published;
        return this;
    }

    @Nullable
    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublished(Boolean published) {
        this.published = published;
    }

    public SimpleMultimedia category(String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(String category) {
        this.category = category;
    }

    public SimpleMultimedia descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SimpleMultimedia addDescriptionsItem(SimpleDescription descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescription>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public SimpleMultimedia lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public SimpleMultimedia isLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
        return this;
    }

    @Nullable
    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsLandscape() {
        return this.isLandscape;
    }

    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMultimedia simpleMultimedia = (SimpleMultimedia)o;
        return Objects.equals(this.multimediaIdentifier, simpleMultimedia.multimediaIdentifier) && Objects.equals(this.identifier, simpleMultimedia.identifier) && Objects.equals((Object)this.type, (Object)simpleMultimedia.type) && Objects.equals((Object)this.source, (Object)simpleMultimedia.source) && Objects.equals(this.sort, simpleMultimedia.sort) && Objects.equals(this.angle, simpleMultimedia.angle) && Objects.equals(this.width, simpleMultimedia.width) && Objects.equals(this.height, simpleMultimedia.height) && Objects.equals(this.published, simpleMultimedia.published) && Objects.equals(this.category, simpleMultimedia.category) && Objects.equals(this.descriptions, simpleMultimedia.descriptions) && Objects.equals((Object)this.lifestyleType, (Object)simpleMultimedia.lifestyleType) && Objects.equals(this.isLandscape, simpleMultimedia.isLandscape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.multimediaIdentifier, this.identifier, this.type, this.source, this.sort, this.angle, this.width, this.height, this.published, this.category, this.descriptions, this.lifestyleType, this.isLandscape});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimpleMultimedia {\n");
        sb.append("    multimediaIdentifier: ").append(this.toIndentedString(this.multimediaIdentifier)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    isLandscape: ").append(this.toIndentedString(this.isLandscape)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        YOUTUBE("YOUTUBE"),
        CLOUDINARY("CLOUDINARY");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        IMAGE("IMAGE"),
        VIDEO("VIDEO"),
        AUDIO("AUDIO"),
        RAW("RAW");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

