package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.GuestRoomView;
import travel.wink.sdk.extranet.model.GuestRoomViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertGuestRoomRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-28T21:19:30.792146187+07:00[Asia/Bangkok]")
public class GuestRoomApi {
    private ApiClient apiClient;

    public GuestRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public GuestRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Guest Room
     * create a new room type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create room type owned by this hotel identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createGuestRoomRequestCreation(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertGuestRoomRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertGuestRoomRequestSupplier' is set
        if (upsertGuestRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertGuestRoomRequestSupplier' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Guest Room
     * create a new room type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create room type owned by this hotel identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomViewSupplier> createGuestRoom(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Guest Room
     * create a new room type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create room type owned by this hotel identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;GuestRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GuestRoomViewSupplier>> createGuestRoomWithHttpInfo(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Guest Room
     * create a new room type
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create room type owned by this hotel identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createGuestRoomWithResponseSpec(String hotelIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createGuestRoomRequestCreation(hotelIdentifier, upsertGuestRoomRequestSupplier, winkVersion);
    }
    /**
     * Duplicate Guest Room
     * Create a new duplicate of a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Duplicate room type owned by this hotel identifier
     * @param guestRoomIdentifier Duplicate room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec duplicateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/duplicate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Duplicate Guest Room
     * Create a new duplicate of a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Duplicate room type owned by this hotel identifier
     * @param guestRoomIdentifier Duplicate room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomViewSupplier> duplicateGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Duplicate Guest Room
     * Create a new duplicate of a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Duplicate room type owned by this hotel identifier
     * @param guestRoomIdentifier Duplicate room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;GuestRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GuestRoomViewSupplier>> duplicateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Duplicate Guest Room
     * Create a new duplicate of a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Duplicate room type owned by this hotel identifier
     * @param guestRoomIdentifier Duplicate room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec duplicateGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        return duplicateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion);
    }
    /**
     * Delete Guest Room
     * Remove a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Guest Room
     * Remove a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Guest Room
     * Remove a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removeGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Guest Room
     * Remove a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        return removeGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion);
    }
    /**
     * Delete Guest Room&#39;s Multimedia
     * Remove a room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type media owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type media with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia2RequestCreation(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia2", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Guest Room&#39;s Multimedia
     * Remove a room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type media owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type media with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomView> removeMultimedia2(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Guest Room&#39;s Multimedia
     * Remove a room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type media owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type media with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;GuestRoomView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GuestRoomView>> removeMultimedia2WithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomView> localVarReturnType = new ParameterizedTypeReference<GuestRoomView>() {};
        return removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Guest Room&#39;s Multimedia
     * Remove a room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove room type media owned by this hotel identifier
     * @param guestRoomIdentifier Remove room type media with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMultimedia2WithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        return removeMultimedia2RequestCreation(hotelIdentifier, guestRoomIdentifier, multimediaIdentifier, winkVersion);
    }
    /**
     * Show Guest Room
     * Retrieve a room type by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show room type owned by this hotel identifier
     * @param guestRoomIdentifier Show room type identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Room
     * Retrieve a room type by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show room type owned by this hotel identifier
     * @param guestRoomIdentifier Show room type identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomViewSupplier> showGuestRoom(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Guest Room
     * Retrieve a room type by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show room type owned by this hotel identifier
     * @param guestRoomIdentifier Show room type identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;GuestRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GuestRoomViewSupplier>> showGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Guest Room
     * Retrieve a room type by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show room type owned by this hotel identifier
     * @param guestRoomIdentifier Show room type identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, String winkVersion) throws WebClientResponseException {
        return showGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, winkVersion);
    }
    /**
     * Show Guest Rooms
     * Retrieve list of rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of room types owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GuestRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGuestRoomsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showGuestRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Rooms
     * Retrieve list of rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of room types owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;GuestRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<GuestRoomViewSupplier> showGuestRooms(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return showGuestRoomsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Guest Rooms
     * Retrieve list of rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of room types owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;GuestRoomViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<GuestRoomViewSupplier>>> showGuestRoomsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return showGuestRoomsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Guest Rooms
     * Retrieve list of rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show list of room types owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showGuestRoomsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showGuestRoomsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Guest Room
     * Update a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update room type owned by this hotel identifier
     * @param guestRoomIdentifier Update room type with this identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateGuestRoomRequestCreation(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertGuestRoomRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertGuestRoomRequestSupplier' is set
        if (upsertGuestRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertGuestRoomRequestSupplier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Guest Room
     * Update a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update room type owned by this hotel identifier
     * @param guestRoomIdentifier Update room type with this identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomViewSupplier> updateGuestRoom(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Guest Room
     * Update a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update room type owned by this hotel identifier
     * @param guestRoomIdentifier Update room type with this identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;GuestRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GuestRoomViewSupplier>> updateGuestRoomWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Guest Room
     * Update a room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update room type owned by this hotel identifier
     * @param guestRoomIdentifier Update room type with this identifier
     * @param upsertGuestRoomRequestSupplier The upsertGuestRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateGuestRoomWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateGuestRoomRequestCreation(hotelIdentifier, guestRoomIdentifier, upsertGuestRoomRequestSupplier, winkVersion);
    }
    /**
     * Add Multimedia to Room
     * Uploads a videos and/or images to a room identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload media for room type owned by this hotel identifier
     * @param guestRoomIdentifier Upload media for room type with this identifier
     * @param files The files parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadGuestRoomMediaRequestCreation(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'guestRoomIdentifier' is set
        if (guestRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'guestRoomIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("guestRoomIdentifier", guestRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/room/{guestRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Multimedia to Room
     * Uploads a videos and/or images to a room identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload media for room type owned by this hotel identifier
     * @param guestRoomIdentifier Upload media for room type with this identifier
     * @param files The files parameter
     * @return GuestRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GuestRoomViewSupplier> uploadGuestRoomMedia(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).bodyToMono(localVarReturnType);
    }

    /**
     * Add Multimedia to Room
     * Uploads a videos and/or images to a room identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload media for room type owned by this hotel identifier
     * @param guestRoomIdentifier Upload media for room type with this identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;GuestRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GuestRoomViewSupplier>> uploadGuestRoomMediaWithHttpInfo(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<GuestRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<GuestRoomViewSupplier>() {};
        return uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files).toEntity(localVarReturnType);
    }

    /**
     * Add Multimedia to Room
     * Uploads a videos and/or images to a room identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload media for room type owned by this hotel identifier
     * @param guestRoomIdentifier Upload media for room type with this identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadGuestRoomMediaWithResponseSpec(String hotelIdentifier, String guestRoomIdentifier, List<File> files) throws WebClientResponseException {
        return uploadGuestRoomMediaRequestCreation(hotelIdentifier, guestRoomIdentifier, files);
    }
}
