/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.36.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Multimedia that contains less information than Multimedia object
 */
@JsonPropertyOrder({
  SimpleMultimedia.JSON_PROPERTY_MULTIMEDIA_IDENTIFIER,
  SimpleMultimedia.JSON_PROPERTY_IDENTIFIER,
  SimpleMultimedia.JSON_PROPERTY_TYPE,
  SimpleMultimedia.JSON_PROPERTY_SOURCE,
  SimpleMultimedia.JSON_PROPERTY_SORT,
  SimpleMultimedia.JSON_PROPERTY_ANGLE,
  SimpleMultimedia.JSON_PROPERTY_WIDTH,
  SimpleMultimedia.JSON_PROPERTY_HEIGHT,
  SimpleMultimedia.JSON_PROPERTY_PUBLISHED,
  SimpleMultimedia.JSON_PROPERTY_CATEGORY,
  SimpleMultimedia.JSON_PROPERTY_DESCRIPTIONS,
  SimpleMultimedia.JSON_PROPERTY_LIFESTYLE_TYPE,
  SimpleMultimedia.JSON_PROPERTY_IS_LANDSCAPE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-28T21:19:30.792146187+07:00[Asia/Bangkok]")
public class SimpleMultimedia {
  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
  private UUID multimediaIdentifier;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   */
  public enum TypeEnum {
    IMAGE("IMAGE"),
    
    VIDEO("VIDEO"),
    
    AUDIO("AUDIO"),
    
    RAW("RAW");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   */
  public enum SourceEnum {
    YOUTUBE("YOUTUBE"),
    
    CLOUDINARY("CLOUDINARY");

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  private SourceEnum source = SourceEnum.CLOUDINARY;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort = 999;

  public static final String JSON_PROPERTY_ANGLE = "angle";
  private String angle;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height;

  public static final String JSON_PROPERTY_PUBLISHED = "published";
  private Boolean published = false;

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private String category;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions;

  /**
   * Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
  private Boolean isLandscape;

  public SimpleMultimedia() {
  }

  public SimpleMultimedia multimediaIdentifier(UUID multimediaIdentifier) {
    
    this.multimediaIdentifier = multimediaIdentifier;
    return this;
  }

   /**
   * Document identifier
   * @return multimediaIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getMultimediaIdentifier() {
    return multimediaIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifier(UUID multimediaIdentifier) {
    this.multimediaIdentifier = multimediaIdentifier;
  }


  public SimpleMultimedia identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Use this identifier to communicate with Cloudinary.
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public SimpleMultimedia type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Whether Cloudinary media is a VIDEO or IMAGE.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public SimpleMultimedia source(SourceEnum source) {
    
    this.source = source;
    return this;
  }

   /**
   * Currently ONLY using Cloudinary to store all image / video assets.
   * @return source
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSource(SourceEnum source) {
    this.source = source;
  }


  public SimpleMultimedia sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort allows you to control how you want to sort this record in a list of media records.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public SimpleMultimedia angle(String angle) {
    
    this.angle = angle;
    return this;
  }

   /**
   * Media angle
   * @return angle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAngle() {
    return angle;
  }


  @JsonProperty(JSON_PROPERTY_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAngle(String angle) {
    this.angle = angle;
  }


  public SimpleMultimedia width(Integer width) {
    
    this.width = width;
    return this;
  }

   /**
   * Media width in pixels.
   * @return width
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWidth(Integer width) {
    this.width = width;
  }


  public SimpleMultimedia height(Integer height) {
    
    this.height = height;
    return this;
  }

   /**
   * Media height in pixels.
   * @return height
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHeight(Integer height) {
    this.height = height;
  }


  public SimpleMultimedia published(Boolean published) {
    
    this.published = published;
    return this;
  }

   /**
   * Instead of deleting the media, choose to un-publish it instead for later re-use. Could be you keep seasonal images of the property.
   * @return published
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PUBLISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPublished() {
    return published;
  }


  @JsonProperty(JSON_PROPERTY_PUBLISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublished(Boolean published) {
    this.published = published;
  }


  public SimpleMultimedia category(String category) {
    
    this.category = category;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PIC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return category
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategory(String category) {
    this.category = category;
  }


  public SimpleMultimedia descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SimpleMultimedia addDescriptionsItem(SimpleDescription descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized media captions to give user some context about where this media was taken.
   * @return descriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public SimpleMultimedia lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public SimpleMultimedia isLandscape(Boolean isLandscape) {
    
    this.isLandscape = isLandscape;
    return this;
  }

   /**
   * True if media width is greater or equal to height
   * @return isLandscape
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_LANDSCAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsLandscape() {
    return isLandscape;
  }


  @JsonProperty(JSON_PROPERTY_IS_LANDSCAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsLandscape(Boolean isLandscape) {
    this.isLandscape = isLandscape;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimpleMultimedia simpleMultimedia = (SimpleMultimedia) o;
    return Objects.equals(this.multimediaIdentifier, simpleMultimedia.multimediaIdentifier) &&
        Objects.equals(this.identifier, simpleMultimedia.identifier) &&
        Objects.equals(this.type, simpleMultimedia.type) &&
        Objects.equals(this.source, simpleMultimedia.source) &&
        Objects.equals(this.sort, simpleMultimedia.sort) &&
        Objects.equals(this.angle, simpleMultimedia.angle) &&
        Objects.equals(this.width, simpleMultimedia.width) &&
        Objects.equals(this.height, simpleMultimedia.height) &&
        Objects.equals(this.published, simpleMultimedia.published) &&
        Objects.equals(this.category, simpleMultimedia.category) &&
        Objects.equals(this.descriptions, simpleMultimedia.descriptions) &&
        Objects.equals(this.lifestyleType, simpleMultimedia.lifestyleType) &&
        Objects.equals(this.isLandscape, simpleMultimedia.isLandscape);
  }

  @Override
  public int hashCode() {
    return Objects.hash(multimediaIdentifier, identifier, type, source, sort, angle, width, height, published, category, descriptions, lifestyleType, isLandscape);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimpleMultimedia {\n");
    sb.append("    multimediaIdentifier: ").append(toIndentedString(multimediaIdentifier)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    angle: ").append(toIndentedString(angle)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    published: ").append(toIndentedString(published)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    isLandscape: ").append(toIndentedString(isLandscape)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

