/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CreateMasterRateRequestSupplier;
import travel.wink.sdk.extranet.model.MasterRateViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.RoomRateRemovableResponseSupplier;
import travel.wink.sdk.extranet.model.UpdateMasterRateRequestSupplier;

public class MasterRateApi {
    private ApiClient apiClient;

    public MasterRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public MasterRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createMasterRateRequestCreation(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        CreateMasterRateRequestSupplier postBody = createMasterRateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createMasterRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMasterRateRequestSupplier' when calling createMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MasterRateViewSupplier> createMasterRate(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.createMasterRateRequestCreation(hotelIdentifier, createMasterRateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateViewSupplier>> createMasterRateWithHttpInfo(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.createMasterRateRequestCreation(hotelIdentifier, createMasterRateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createMasterRateWithResponseSpec(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createMasterRateRequestCreation(hotelIdentifier, createMasterRateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removableMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling removableMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomRateRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/removable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomRateRemovableResponseSupplier> removableMasterRate(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomRateRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponseSupplier>(this){};
        return this.removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomRateRemovableResponseSupplier>> removableMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomRateRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponseSupplier>(this){};
        return this.removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removableMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec removeMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling removeMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeMasterRate(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MasterRateViewSupplier> showMasterRate(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateViewSupplier>> showMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showMasterRates1RequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRates1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<MasterRateViewSupplier> showMasterRates1(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRates1RequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<MasterRateViewSupplier>>> showMasterRates1WithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRates1RequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMasterRates1WithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showMasterRates1RequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpdateMasterRateRequestSupplier postBody = updateMasterRateRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateMasterRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMasterRateRequestSupplier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MasterRateViewSupplier> updateMasterRate(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateViewSupplier>> updateMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequestSupplier, winkVersion);
    }
}

